/* 
 * split.c
 * Split Screen Plugin 0.1
 *
 * Copyright (c) 1999 Stefan Gartner <Stefan.Gartner@fhs-hagenberg.ac.at>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */

char name[24]= "Split Screen";	

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
	{ LABEL,	 "Input: 2 strips", 0.0, 0.0, 0.0,   ""},
	{ TOG|INT, "Horizontal",      0.0, 0.0, 1.0,   
	   "Split screen horizontally"},
	{ TOG|INT, "2*2",             0.0, 0.0, 1.0,   
	   "U'll see what U get!"},
	};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
	int dummy;			/* because of the 'label' button */
	int horiz;
	int twice;
} Cast;


/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

static void use_ibuf(char src[3], char dest[3]) {
   int i;
   for (i=0; i<=3; i++) dest[i]= src[i];
}
   

void plugin_seq_doit(Cast *cast, float facf0, float facf1, int x, int y, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{
   char *rectOrg, *rectOrg2, *rectDest;
   int sizeX, sizeY,h,t;
   sizeX = ibuf1->x;
   sizeY = ibuf1->y;
   y = sizeY;
   h= cast->horiz;
   t= cast->twice;
   
   /* if (not_in_the_mood) crash(); */
   if (!ibuf1 || !ibuf2 || ibuf2==ibuf1) return;
   
   rectDest = (char *) out->rect;
   rectOrg  = (char *) ibuf1->rect;
   rectOrg2 = (char *) ibuf2->rect;
   while (y--) {
      x = sizeX;
      while (x--) {
         if (t) {
            if (y <= sizeY/2) { 
               if (x <=sizeX/2) use_ibuf(rectOrg, rectDest);
               else use_ibuf(rectOrg2, rectDest);
            }else {
               if (x <=sizeX/2) use_ibuf(rectOrg2, rectDest);
               else use_ibuf(rectOrg, rectDest);
            }
         } else if (h) {
            if (y <= sizeY/2) {
               use_ibuf(rectOrg2, rectDest);
            } else {
               use_ibuf(rectOrg, rectDest);
            }
         } else {
            if (x <= sizeX/2) {
               use_ibuf(rectOrg, rectDest);
            } else {
               use_ibuf(rectOrg2, rectDest);
            }
         }
         rectDest+=4;
         rectOrg+=4;
         rectOrg2+=4;
      } /* while (x--) */
   } /* while (y--) */
} /* plugin_seq_doit() */
