/* 
 * strobe.c
 * Stroboscope Plugin 0.5
 *
 * Invert given frames or replace them by pure white.
 * May not work with fields.
 *
 * This plugin may cause blindness. You have been warned.
 * Copyright (c) 1999 Stefan Gartner <Stefan.Gartner@fhs-hagenberg.ac.at>
 * Alpha flash added by Eduardo Roldan <trazor@adinet.com.uy>

 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */

char name[24]= "Stroboscope";	

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
	{ LABEL,		"Input: >=1 strip", 0.0, 0.0, 0.0,   ""},
	{ TOG|INT,	"White Flash",	     0.0, 0.0, 1.0,  ""},
	{ TOG|INT,	"Alpha Flash",	     0.0, 0.0, 1.0,  
	   "Use Alpha or 2nd Strip"},
	{ NUMSLI|INT,	"Frames:",	     2.0, 2.0, 25.0, "Which Frames?"},
	};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
	int dummy;			/* because of the 'label' button */
	int white;
	int alphaf;
	int frames;
} Cast;


/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}



void plugin_seq_doit(Cast *cast, float facf0, float facf1, int x, int y, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{
   char *rectOrg, *rectOrg2, *rectDest;
   int sizeX, sizeY, i, even;
   int use_ibuf2= 0;
   float f;
   sizeX = ibuf1->x;
   sizeY = ibuf1->y;
   /* checking of eveness taken from BigWhale's RoboCop plugin */
   f = cfra / cast->frames;
   i = (int) f;
   f = f-i;
   if (f == 0) even=1; else even=0;
   
   if(ibuf1) {
      y = sizeY;
      rectDest = (char *) out->rect;
      rectOrg  = (char *) ibuf1->rect;
      if (!ibuf2 || (ibuf2==ibuf1)) {
         printf("no ibuf2!\n");
         use_ibuf2= 0;
      } else {
         rectOrg2 = (char *) ibuf2->rect;
         use_ibuf2= 1;
      }
      while (y--) {
         x = sizeX;
         while (x--) {
            if (even) {
               if (cast->white) rectDest[0]= rectDest[1]= rectDest[2]= rectDest[3] = 255.0;
               else if (cast->alphaf) {
                  if (use_ibuf2==1) {
                     rectDest[0]= rectOrg2[0];
                     rectDest[1]= rectOrg2[1];
                     rectDest[2]= rectOrg2[2];
                     rectDest[3]= rectOrg2[3];
                  } else rectDest[0]= rectDest[1]= rectDest[2]= rectDest[3]= 0.0;
               } else {
                  rectDest[0] = 255.0 - rectOrg[0];
                  rectDest[1] = 255.0 - rectOrg[1];
                  rectDest[2] = 255.0 - rectOrg[2];
                  rectDest[3] = 255.0 - rectOrg[3];
               }
            } else {
               rectDest[0] = rectOrg[0];
               rectDest[1] = rectOrg[1];
               rectDest[2] = rectOrg[2];
               rectDest[3] = rectOrg[3];
            } /* if (even) */
            rectDest+=4;
            rectOrg+=4;
            rectOrg2+=4;
         } /* while (x--) */
      } /* while (y--) */
   } /* if(ibuf1) */
} /* plug_seq_doit() */
