/* 
 * Copyright (c) 1999, Kiernan Holland
 * 
 */

#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */


char name[24]= "trucate";

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
	{LABEL,		"Note:",		0.0,	0.0, 0.0, ""},
	{LABEL,		"In addition to",		0.0,	0.0, 0.0, ""},
	{LABEL,		"pivot use the",		0.0,	0.0, 0.0, ""},
	{LABEL,		"IPO for a range",		0.0,	0.0, 0.0, ""},
	{NUMSLI|FLO,	"tpivot ",		0.0,	0.0, 1.0, "Trucation range pivot point."}
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
	int label1;
	int label2;
	int label3;
	int label4;
	float tpivot;
} Cast;

/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

/* ************************************************************
	Truncate Pixel Value
	
	This plugin will allow one to truncate pixel intensities
	using one fixed pivot value and the IPOcurve (Fac0)
	to control the truncation over time.. 

	I wrote this mainly to learn who to write my first plugin, 
	and I wanted to combine this with the Z buffer extraction 
	plugin to create faked depth-of-field.. 

	Kiernan
	
   ************************************************************ */


void plugin_seq_doit(Cast *cast, float facf0, float facf1, int sx, int sy, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{

	int a;
	unsigned char pivotBYTE, curveBYTE, valueBYTE;
	char *rectc;
	char *rectIN;
	float IPOcurve;
	

	/* Get the variable IPO curve from blender and give a 
	** more meningful name. 
	*/
	if ((facf0 <= 1.0) && (facf0 >= 0.0)) { 
		IPOcurve = facf0;
		} else { 
		if (facf0 > 1.0) { 
			IPOcurve = 1.0;
			} else { 
			IPOcurve = 0.0;
			}
		}
		
	if(ibuf1) {
		/*
		** if(ibuf1->zbuf==0) {
		** 	printf("no zbuf\n");
		** 	return;
		** }
		** rectz= ibuf1->zbuf; 
		*/

		a= ibuf1->x*ibuf1->y;

		/* rectc and rectIN are the image buffer pointers. 
		*/
		rectc= (char *)out->rect;
		rectIN = (char *)ibuf1->rect;

		/* factor the pivot and curve vars into bytes
		** for comparisons with the pixels in the image buffer
		*/

		/* unsigned chars are safer than signed?
		** anyways, this is where I turn the trucation pivot and the 
		** Fac IPOCurve values into whole-byte integers (of char width). 
		*/
		pivotBYTE = ((unsigned char) ((cast->tpivot) * 255));
		curveBYTE = ((unsigned char) ((IPOcurve) * 255));
		
		while(a--) {
			/* this is only used for purposes of filtering, 
			** I average the primary colors to get a number which I can 
			** use to determine which pixels are filtered out by 
			** intensity.. 
			*/
			valueBYTE = ((rectIN[1] + rectIN[2] + rectIN[0])/3); 

			if (((valueBYTE >= pivotBYTE) && (valueBYTE <= curveBYTE)) ||
				((valueBYTE >= curveBYTE) && ((valueBYTE <= pivotBYTE)))) { 
					rectc[0] = rectIN[0];
					rectc[1] = rectIN[1];
					rectc[2] = rectIN[2];
					rectc[3] = rectIN[3];
					} else { 
					rectc[3]= 255;
					rectc[1]= rectc[2]= rectc[0]= 0;
					}
			rectc+= 4;
			rectIN+= 4;
		}
	}
}

