/* 
 *    Made by Joeri Kassenaar. 
 * 
 */

#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */


char name[24]= "wipeOut";	

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
	{ LABEL,			"Input: 3 strips", 0.0, 0.0, 0.0, ""}, 
	{ TOG|INT,	"mask negative",  0.0,	0.0, 1.0, 
	   "Make the mask negative"}, 
	
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
	int dummy;			/* because of the 'label' button */
    int negmask;
} Cast;


/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

void plugin_seq_doit(Cast *cast, float facf0, float facf1, int x, int y, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *ibufo, ImBuf *use)
{
	float f;
	int xo;
	char *fac, *in1, *in2, *out;	
	
	xo= x;
	fac=  (char *)use->rect;
	in1=  (char *)ibuf1->rect;
	in2=  (char *)ibuf2->rect;
	out=  (char *)ibufo->rect;
	
	if (cast->negmask) {
		while(y--) {
			x= xo;
			while(x--) {
				f = fac[0] / 255.0 ; out[0]= (in1[0] * (1.0 - f)) + ( in2[0] * f );
				f = fac[1] / 255.0 ; out[1]= (in1[1] * (1.0 - f)) + ( in2[1] * f );
				f = fac[2] / 255.0 ; out[2]= (in1[2] * (1.0 - f)) + ( in2[2] * f );
				f = fac[3] / 255.0 ; out[3]= (in1[3] * (1.0 - f)) + ( in2[3] * f );
				
				fac +=4; in1 +=4; in2 +=4;
				out +=4;
			}		
		}	
	}else{
		while(y--) {
			x= xo;
			while(x--) {
				f = fac[0] / 255.0 ; out[0]= (in1[0] * f ) + ( in2[0] * (1.0 - f) );
				f = fac[1] / 255.0 ; out[1]= (in1[1] * f ) + ( in2[1] * (1.0 - f) );
				f = fac[2] / 255.0 ; out[2]= (in1[2] * f ) + ( in2[2] * (1.0 - f) );
				f = fac[3] / 255.0 ; out[3]= (in1[3] * f ) + ( in2[3] * (1.0 - f) );
				
				fac +=4; in1 +=4; in2 +=4;
				out +=4;
			}		
		}
	}
}	


