
/* 
 * Copyright (c) 1999, Excellent Whale. 
 * 
 */
 
#include "math.h"
#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */

/* Texture name */

char name[24]= "Noise";

/* Subtype names must be less than 15 characters */

#define NR_TYPES	3
char stnames[NR_TYPES][16]= {"Intens", "Col", "Bump" };

/* Structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
{	NUM|INT,	"Seed",		    8.0, 	0.0, 255.0, ""} 
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order, 
   INCLUDING dummy variables for label fields. */ 

typedef struct Cast {
	int seed;
} Cast;

/* result:
   Intensity, R, G, B, Alpha, nor.x, nor.y, nor.z
 */

float result[8];

/* cfra: the current frame */

float cfra;

int plugin_tex_doit(int, Cast*, float*, float*, float*);

/* ******************** Fixed functions ***************** */

int plugin_tex_getversion(void) 
{	
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init(void)
{
	
	srandom(12);
}

/* this function should not be changed: */

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->stypes= NR_TYPES;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	
	info->snames= stnames[0];
	info->result= result;
	info->cfra= &cfra;
	info->varstr= varstr;

	info->init= plugin_init;
	info->tex_doit=  (TexDoit) plugin_tex_doit;
	info->callback= plugin_but_changed;
}

/* ********************* the texture ******************** */


/* return 0: One channel texture
   return 1: RGB texture
   return 2: Normals texture */




int plugin_tex_doit(int stype, Cast *cast, float *texvec, float *dxt, float *dyt)
{
	float val = 0.0;
	int seed;

	float tv[3];
	tv[0]=(texvec[0]+1.2)/2.4;
	tv[1]=(texvec[1]+1.2)/2.4;
	tv[2]=(texvec[2]+1.2)/2.4;
	
	srand(cast->seed +(int)(tv[0]*tv[1]*7680));
	seed= rand() % 768;
	srand(seed + (int)(tv[1]*tv[2]*seed));
	seed= rand() % 768;
	srand(seed + (int)(tv[0]*tv[2]*seed));
	seed= rand() % 768;
	srand(seed + (int)(tv[0]*tv[1]*seed));
	
	result[0]= val= (rand() % 512) / 512.0;
	
	if(stype==1) {
		result[1]= (rand() % 512) / 512.0;
		result[2]= (rand() % 512) / 512.0;
		result[3]= (rand() % 512) / 512.0;
		result[4]= 1.0;
		result[0]= (result[1] + result[2] + result[3]) / 3.0;
			
		return 1;
	}
	if(stype==2) {
		result[5]+= val;
		result[6]+= 1.0-val;
		result[7]= 0.0;
		
		return 2;
	}
	
	return 0;
}

