/*
Simple playing with the sin function.
Created by SirDude(mein@cs.umn.edu)
Mon Apr  8 10:13:39 CDT 2002
This plugin is in the public Domain
*/
#include "math.h"
#include "plugin.h"

/* Texture name */
char name[24]= "pattern";

#define NR_TYPES        3
char stnames[NR_TYPES][16]= {"Intens","Color", "Bump"};

/* Structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
   {NUM|FLO,        "Turb",        0.00001, 0.000, 5.000, ""},
};

typedef struct Cast {
        float noise;
} Cast;

float result[8];
float cfra;
int plugin_tex_doit(int, Cast*, float*, float*, float*);

/* Fixed Functions */
int plugin_tex_getversion(void) {
        return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) { }

void plugin_init(void) { 
}

void plugin_getinfo(PluginInfo *info) {
        info->name= name;
        info->stypes= NR_TYPES;
        info->nvars= sizeof(varstr)/sizeof(VarStruct);

        info->snames= stnames[0];
        info->result= result;
        info->cfra= &cfra;
        info->varstr= varstr;

        info->init= plugin_init;
        info->tex_doit=  (TexDoit) plugin_tex_doit;
        info->callback= plugin_but_changed;
}

/* start of texture code */
float do_pattern(float *texvec, Cast *cast) {
   float ans;
   ans = hnoise(cast->noise,sin(texvec[0]),sin(texvec[1]),sin(texvec[2]));

   /* return ans; */
   if (ans >= 0.5) return ans;
   return 0;
}

int plugin_tex_doit(int stype, Cast *cast, float *texvec, float *dxt, 
   float *dyt) {

   result[0]= do_pattern(texvec,cast);
   if (stype == 1) {
      result[1] = fabs(sin(texvec[0]));
      result[2] = fabs(sin(texvec[1]));
      result[3] = fabs(sin(texvec[2]));
      result[4] = result[0];
      return 1;
   } if (stype == 2) {
      result[5] = result[0];
      result[6] = 1- result[0];
      result[7] = 0.0;
      return 2;
   }
   return 0; 
}
