/* Copy lefted.
 * 
 * pie.c
 *
 * blender plugin for pie shaped divs.
 *
 * (source by Robert Wenzlaff, 7/16/00)
 * 
 * Contact:      rwenzla@utoledo.edu
 * Information:  http://www.geocities.com/rwenzlaff/BlenderLinks
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */

#include "math.h"
#include "plugin.h"

#define NR_TYPES	1


float result[8];
float cfra;

int	do_reset = FALSE;

extern float hnoise(float noisesize, float x, float y, float z);

/* set up plugin menu */

char name[]= "Pie";
char stnames[NR_TYPES][16]= {"Pie"};

VarStruct varstr[]= {
	/* type,	name,		default,min,   	max, 	tooltips */
	{ LABEL,	"",	0, 	0,	0,	""},
	{ NUM|INT,	"divs ", 	6.0, 	2.0, 	1000.0,	
	"Pie plugin: Number of slices"},
			/* Number of slices */
	{ NUM|FLO,	"hardness ", 1.0,	0.0, 	5.0,	
	"Pie plugin: Falloff Hardness"},
			/* determins sharpnes of edge, could use some work */
	{ NUM|FLO, 	"ang ofs ", 0.0,	-180.0, 180.0, 	
	"Pie plugin: Angle offset "},
			/* phase angle */
	{ NUM|FLO,    	"turb dep ",0.0,    -5.0, 	5.0,    
	"Pie plugin: Turbulance depth"},
			/* Pos. Turb affects 'white', Neg. affects 'black' */
	{ NUM|FLO, 	"turb siz ",0.25, 	0.0, 	2.0, 	
	"Pie plugin: Turbulance size"}
};
typedef struct Cast {
	float dum1;
	int div;
	float hard;
	float ang;
	float turbd;
	float turbs;
} Cast;

/* ******************************************************************* */

int plugin_tex_doit(int, Cast*, float*, float*, float*);

int plugin_tex_getversion(void) 
{	
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init(void)
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->stypes= NR_TYPES;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	
	info->snames= stnames[0];
	info->result= result;
	info->cfra= &cfra;
	info->varstr= varstr;

	info->init= plugin_init;
	info->tex_doit=  (TexDoit) plugin_tex_doit;
	info->callback= plugin_but_changed;
}

int plugin_tex_doit(int stype, Cast *cast, float *texvec, float *dxt, float *dyt)
{
	float angle, turb=0;

	angle = atan2(texvec[0],texvec[1]) + cast->ang*3.1415926/180.0;

	if ( cast->turbd !=0.0 )  {     /* save time if no turb */
		turb = cast->turbd * hnoise(cast->turbs,texvec[0],texvec[1], texvec[2]);
		/*printf("turb: %f\n",turb);*/
	}

	result[0]= 0.5 - 0.5*sin(angle * cast->div - turb - 0.5);
	if (cast->hard !=1) result[0]= pow(result[0], cast->hard);  /*Very slow, better way?*/

    if (result[0] > 1) result[0] = 1.0;
	else if (result[0]<0) result[0]=0;

	result[4]= 1.0;

	return 0;
}

