#ifndef r_texture_h
#define r_texture_h

#include "plugin.h"

#define HASHVEC(x,y,z) hashvectf+3*hash[ (hash[ (hash[(z) & 255]+(y)) & 255]+(x)) & 255]
#define rand_map(x,y,z) hash[ (hash[ (hash[(z) & 255]+(y)) & 255]+(x)) & 255]
#define s_curve(t) ( (t) * (t) * (3. - 2. * (t)) )

extern  unsigned char hash[256];
extern float hashvectf[256 * 3];

extern void turb(float noisesize, float xc, float yc, float zc, float *vec, int seed);
extern void point_turbulance(float noise_size, int hard, float x,float y, float z, float *vec, int depth, int wrap_x, int wrap_y,int seed);
void vec_normalize(float *v);


unsigned char hash[256]= {
 198, 12, 146, 95, 44, 18, 240, 28, 151, 32, 45, 20, 30, 23, 141, 248,
 168, 254, 178, 85, 92, 216, 236, 175, 47, 88, 67, 136, 234, 1, 72, 106,
 79, 220, 24, 171, 26, 224, 128, 137, 223, 16, 105, 195, 231, 183, 29,
 132, 241, 122, 252, 135, 5, 181, 130, 213, 49, 204, 70, 176, 144, 35, 
 64, 104, 19, 39, 46, 13, 246, 233, 9, 177, 31, 61, 154, 117, 129, 75,
 139, 118, 68, 42, 207, 86, 112, 27, 158, 8, 247, 250, 109, 163, 242, 
 52, 160, 164, 43, 83, 62, 190, 57, 155, 169, 98, 6, 51, 38, 150, 80,
 84, 114, 14, 253, 194, 4, 138, 101, 25, 60, 97, 167, 188, 148, 209, 
 77, 192, 131, 227, 36, 191, 237, 76, 214, 17, 251, 81, 71, 123, 119,
 232, 0, 244, 87, 53, 66, 126, 187, 110, 107, 2, 212, 93, 74, 211, 249,
 63, 102, 113, 255, 11, 173, 197, 166, 157, 226, 124, 90, 199, 59, 10, 
 100, 140, 89, 208, 221, 37, 33, 230, 121, 174, 189, 165, 149, 34, 179,
 15, 108, 40, 55, 91, 7, 200, 147, 120, 134, 56, 184, 133, 115, 202, 245,
 94, 82, 152, 116, 143, 210, 206, 145, 203, 193, 127, 180, 125, 22, 159, 
 142, 156, 219, 111, 99, 217, 96, 41, 162, 228, 3, 161, 58, 229, 153, 235, 
 215, 54, 205, 50, 218, 103, 69, 21, 48, 186, 170, 73, 65, 222, 238, 225, 
 78, 172, 185, 196, 182, 239, 201, 243
};

float hashvectf[256 * 3] = {
0.550781, 0.600098, -0.625488, -0.659668, -0.590820, 0.797363, -0.626953, 0.854492, 0.494629,
 0.187988, 0.665527, 0.365723, 0.450195, 0.883301, 0.800293, -0.417969, -0.900879, 0.577637,
 -0.797852, 0.703613, 0.408203, -0.341309, -0.160645, 0.428223, 0.481934, -0.772949, -0.829102, 
 0.105957, -0.911133, 0.517578, -0.126465, 0.556152, -0.783691, 0.230469, 0.854492, 0.037598,
 -0.839844, 0.268555, 0.038574, -0.126465, -0.357422, 0.377930, 0.443359, 0.238281, 0.463867,
 0.198730, 0.032715, 0.594238, -0.817871, -0.780273, -0.150391, -0.712891, 0.328125, -0.862305,
 0.933594, 0.800781, -0.352051, -0.871582, 0.517578, -0.837891, -0.120605, 0.517578, 0.006836,
 0.008301, 0.558105, -0.638184, -0.762207, -0.194824, 0.355957, -0.563965, -0.479980, 0.725586,
 0.449219, 0.124512, -0.041992, -0.317871, -0.580566, -0.279785, -0.444336, 0.018066, 0.186523, 
 0.630371, -0.401855, 0.349121, -0.531250, 0.987305, 0.822754, -0.929688, 0.278809, -0.833496,
 -0.139160, -0.989746, -0.049805, -0.290527, -0.529297, 0.748535, 0.190430, -0.845703, -0.956055, 
 -0.915527, -0.327637, 0.272949, -0.100586, -0.836426, -0.348145, -0.787598, -0.146484,
 0.764160, -0.882324, 0.044434, -0.425293, -0.767578, -0.025391, -0.780273, -0.782715, -0.418945,
 0.754883, 0.430176, -0.161621, 0.240723, -0.636719, 0.376465, 0.095215, 0.967285, -0.648926, 
 -0.059082, 0.722168, -0.593262, 0.225586, -0.731934, -0.707031, 0.816895, 0.285156, -0.747559,
 -0.240723, -0.557617, 0.489258, -0.072266, -0.725098, 0.050293, -0.140625, 0.269531, 0.798340, 
 0.116699, 0.910645, -0.102051, -0.023438, -0.825195, -0.386719, -0.811035, 0.812988, -0.183594, 
 0.388672, 0.292969, 0.614746, 0.849121, 0.633789, -0.440918, 0.718750, -0.888184, -0.722168,
 -0.136719, -0.495605, 0.444336, -0.129883, -0.654297, 0.181641, 0.315918, 0.700195, -0.945313,
 -0.133301, 0.606934, 0.445801, -0.006836, 0.432129, -0.950684, -0.143066, 0.074707, -0.355469, 
 -0.178711, -0.030762, -0.514160, -0.921387, -0.199219, -0.656250, 0.951660, -0.685547, 0.972168,
 0.848633, -0.587891, 0.917480, -0.508301, 0.459961, -0.400391, -0.302734, -0.092285, 0.603516,
 0.026855, 0.748047, -0.962402, 0.521973, -0.120605, -0.227051, 0.000488, 0.176758,
 -0.687012, 0.184570, 0.909180, 0.177734, -0.338867, 0.492188, 0.711914, 0.248047, 0.043945,
 0.466797, 0.697754, 0.717285, 0.888184, 0.588379, 0.153320, -0.454102, 0.847656, -0.725098,
 0.676270, -0.615234, -0.362305, 0.391113, -0.351563, -0.839844, -0.731934, -0.458984,
 -0.638672, 0.693848, 0.185547, -0.361816, 0.297852, 0.853516, 0.826172, 0.261719, -0.924805, 
 -0.264160, -0.933594, -0.711914, -0.461426, -0.623535, 0.085938, -0.690430, -0.488281, 
 -0.503418, -0.863770, -0.668457, -0.291504, 0.777344, -0.286621, 0.248535, -0.706055, 0.166504, 
 -0.361816, 0.606445, 0.608398, 0.716309, -0.458496, -0.857422, -0.458984, 0.453125, 0.259766, 
 0.607910, 0.064941, 0.777344, -0.368652, -0.629395, -0.573242, 0.894531, -0.798828, -0.698242,
 0.492188, 0.779785, -0.665527, 0.439941, -0.253906, -0.829102, -0.767578, 0.937988, -0.545898,
 -0.906738, 0.356934, 0.794922, 0.474121, -0.582031, -0.240234, -0.138184, 0.228516, 0.948242,
 -0.179688, 0.634277, 0.330566, -0.460938, 0.886719, 0.325195, 0.368164, 0.748047, -0.674805,
 0.718750, 0.342285,
 0.517090, -0.524414, 0.303223, 0.264160, 0.383789, 0.011719, -0.811523, -0.595215,
 -0.271973, -0.788574, -0.697266, -0.293457, -0.455566, -0.374023, 0.371582, -0.154785, 
 0.252441, 0.664063, 0.176758, 0.450195, 0.030762, -0.422852, -0.401855, 0.984375, 0.188965,
 -0.648926, 0.936035, 0.774414, 0.067383, 0.005859, 0.013184, 0.701172, -0.033203, -0.200684,
 0.562012, 0.045898, 0.614258, 0.841309, -0.611328, 0.992188, -0.344238, -0.392090, 0.820313, 
 -0.717285, -0.318359, 0.867676, 0.935059, -0.463867, 0.283203, -0.489258, 0.071289, -0.284668,
 0.640625, 0.784668, 0.116699, -0.743652, -0.857910, -0.561523, -0.916504, -0.650391, 0.535156,
 0.270508, -0.539551, -0.118164, -0.893066, 0.583496, 0.847168, -0.470703, 0.396973, -0.955078, 
 -0.628418, -0.488281, -0.056641, -0.542480, 0.384766, -0.501465, -0.444336, -0.069824, 0.942871,
 0.175781, -0.376465, -0.040527, 0.564453, 0.964844, -0.047363, -0.084473, 0.771973, -0.600586,
 -0.363770, -0.565430, -0.086426, 0.660156, 0.453125, -0.782227, -0.231934, -0.236816, 0.300781,
 0.737305, 0.428711,
  0.905273, -0.842285, 0.345703, -0.030762, 0.467285, 0.078613, 0.295410, -0.608887, 0.170898, 
	-0.282227, -0.838867, -0.647949, 0.893555, 0.886719, 0.170898, -0.823730, -0.359863, -0.356445,
	-0.058105, 0.645508, 0.168457, -0.590332, 0.123047, -0.930176, -0.227051, 0.621582, 0.444336, 
	0.142578, 0.724121, 0.411621, -0.328613, -0.924316, 0.865723, 0.822754, 0.966309, 0.514160,
	-0.137207, 0.049805, 0.156738, -0.266602, -0.384277, -0.782227, -0.591797, -0.380859,
	-0.682129, -0.813965, 0.805176, -0.073730, -0.316895, -0.111328, 0.336914, -0.680176,
	0.816895, 0.700684, 0.790527, 0.696777, 0.253906, 0.340820, 0.048828, 0.291504, -0.355957, 
	0.802734, -0.704102, -0.941895, 0.601074, -0.183105, -0.370605, 0.838379, 0.202637, 0.345215, 
	-0.423828, -0.193359, 0.649414, -0.393066, 0.018555, -0.298340, -0.421875, 0.135254,
	-0.977539, -0.666504, -0.465332, -0.636230, -0.926758, 0.876465, -0.900879, 0.247559,
	-0.778320, -0.560547, 0.169434, -0.587402, 0.627930, 0.421875, -0.098633, -0.662598, 
	0.020508, -0.854492, -0.196289, -0.933594, -0.442871,
 -0.726563, 0.490234, -0.046875, -0.410156, 0.504883, 0.588379, 0.936035, 0.840820, 0.056152,
 0.302734, -0.153320, 0.482422, 0.417969, 0.136230, -0.755859, 0.623535, -0.102051, -0.731445,
 -0.711426, -0.298828, 0.442383, 0.086426, 0.137207, -0.720703, -0.759766, -0.624512, 0.379395,
 0.756348, 0.606934, 0.665039, -0.002441, 0.472656, 0.651367, 0.229980, 0.361816, -0.268066,
 -0.776855, -0.750488, -0.243652, 0.221680, -0.359863, 0.620605, 0.934082, -0.653809, 0.698730,
 0.929688, -0.793457, -0.039551, -0.534180, 0.079102, -0.437988, -0.985352, -0.650391, -0.929688,
 -0.684570, -0.398438, -0.046387, 0.444336, 0.791016, 0.912598, -0.787598, -0.124512, 0.535156, 
 0.598633, 0.305176, -0.574707, -0.440430, 0.038086, -0.144043, 0.948730, -0.882324, -0.990723, 
 -0.089844, 0.160645, 0.511230, 0.272949, 0.195801, -0.144531, -0.573730, 0.556152, -0.837402,
 0.784668, -0.693848, 0.447266, 0.306152, 0.688965, 0.248047, -0.308594, 0.270020, -0.012207, 
 -0.063477, 0.399902, -0.769043, 0.627441, -0.894043, 0.657715, 0.065430, 0.580078, 0.034668, 
 -0.956543, 0.797363,
 0.502441, 0.571777, 0.551270, 0.823730, -0.947754, 0.190430, 0.423340, -0.571289, -0.644043,
 0.579590, 0.384277, -0.929688, -0.860352, -0.740234, -0.215820, -0.043945, -0.992676, 0.735840, 
 0.147461, 0.395020, -0.615234, -0.321777, -0.371582, -0.567871, 0.612305, 0.634766, -0.127441,
 0.265625, 0.698242, 0.775879, -0.217285, 0.941895, -0.772461, 0.168945, 0.695313, 0.837891, 
 -0.076172, 0.085938, -0.542480, -0.583496, 0.372559, -0.158691, -0.083496, -0.229492,
 -0.602539, 0.660156, -0.689941, -0.555664, 0.592773, -0.920410, 0.066406, -0.962891, 
 0.513184, 0.380371, -0.491699, -0.913574, 0.020508, 0.548340, -0.034180, -0.263184,
 -0.715820, -0.729492, -0.208008, -0.314941, 0.939941, 0.459473, -0.211426, 0.909180, 
 -0.095703, 0.810059, -0.464844, -0.321289, 0.346191, 0.887695, 0.125977, 0.345703, 
 0.312012, -0.753906, -0.189453, 0.415527, 0.511230, 0.080078, -0.953613, -0.598145, 
 -0.247070, 0.905273, -0.550781, -0.037598, -0.455566, 0.771973, -0.840332, -0.188965, 
 0.341309, -0.492676, -0.894531, 0.919922, -0.043945, 0.495117, 0.679199, 0.494629, 
 0.622559,
  -0.522949, -0.682617, 0.235352, -0.781738, -0.105469, 0.485352, 0.377441, -0.862305,
	-0.743652, 0.571289, -0.986328, 0.329102, -0.961426, -0.815430, -0.802246, -0.017090,
	0.617188, -0.637695, 0.329590, 0.375000, -0.269043, 0.177246, 0.320801, 0.373535, -0.024902,
	0.258789, -0.957520, -0.907715, -0.173828, 0.715332, -0.447754, 0.208008, -0.300293, -0.036621, 
	-0.394043, -0.569824, -0.462402, 0.966797, -0.051758, -0.372070, -0.571777, -0.623535, 
	-0.116699, 0.113281, -0.245117, -0.920410, 0.630859, 0.581055, -0.621094, -0.343262, 
	0.958008, 0.204102, 0.352051, 0.241211, -0.401855, 0.385254, -0.338867, 0.287109, 0.945801,
	-0.334473, 0.503418, -0.256836, 0.537598,
 -0.710449
 };

float perlinnoise(float noisesize, float x, float y, float z)
{
	float *h;
	float ox, oy, oz,jx,jy,jz;
	float sx,sy,sz;
	float u,v,a,b,c,d,e;
	int ix, iy, iz,b00, b01, b10, b11, b20, b21;

	if(noisesize<0.001) return 0.0;

	x= (1.0+x)/noisesize;
	y= (1.0+y)/noisesize;
	z= (1.0+z)/noisesize;

	ox= (x- (ix= (int)floorf(x)) );
	oy= (y- (iy= (int)floorf(y)) );
	oz= (z- (iz= (int)floorf(z)) );

	jx= ox-1.0;
	jy= oy-1.0;
	jz= oz-1.0;

	b00= hash[ (hash[ix & 255]+ iy) & 255];
	b10= hash[ (hash[(ix+1) & 255]+iy) & 255];
	b01= hash[ (hash[ix & 255]+ (iy+1)) & 255];
	b11= hash[ (hash[(ix+1) & 255]+ (iy+1)) & 255];

	b20=iz & 255; b21= (iz+1) & 255;
 
	sx = s_curve(ox);
	sy = s_curve(oy);
	sz = s_curve(oz);

	h=hashvectf+ 3*hash[(b20+b00) & 255];
	u = (h[0]*ox+h[1]*oy+h[2]*oz);

	h=hashvectf+ 3*hash[(b20+b10) & 255];
	v=  (h[0]*jx+h[1]*oy+h[2]*oz);

	a = LERP(sx,u,v);

	h=hashvectf+ 3*hash[(b20+b01) & 255];
	u= (h[0]*ox+h[1]*jy+h[2]*oz);

	h=hashvectf+ 3*hash[(b20+b11) & 255];
	v=  (h[0]*jx+h[1]*jy+h[2]*oz);

	b = LERP(sx,u,v);

	c = LERP(sy,a,b);

	h=hashvectf+ 3*hash[(b21+b00) & 255];
	u= (h[0]*ox+h[1]*oy+h[2]*jz);

	h=hashvectf+ 3*hash[(b21+b10) & 255];
	v= (h[0]*jx+h[1]*oy+h[2]*jz);

	a = LERP(sx,u,v);

	h=hashvectf+ 3*hash[(b21+b01) & 255];
	u= (h[0]*ox+h[1]*jy+h[2]*jz);

	h=hashvectf+ 3*hash[(b21+b11) & 255];
	v= (h[0]*jx+h[1]*jy+h[2]*jz);

	b = LERP(sx,u,v);

	d = LERP(sy,a,b);

	e = LERP(sz,c,d) + 0.5;
	return e;
}

float hnoise(float noisesize, float x, float y, float z)
{
	register float cn1, cn2, cn3, cn4, cn5, cn6, i, *h;
	float ox, oy, oz, jx, jy, jz;
	float n= 0.5;
	int ix, iy, iz,b00, b01, b10, b11, b20, b21;

	if(noisesize==0.0) return 0.0;

	x= (1.0+x)/noisesize;
	y= (1.0+y)/noisesize;
	z= (1.0+z)/noisesize;


	ox= (x- (ix= (int)floorf(x)) );
	oy= (y- (iy= (int)floorf(y)) );
	oz= (z- (iz= (int)floorf(z)) );

	jx= ox-1;
	jy= oy-1;
	jz= oz-1;

	cn1=ox*ox; cn2=oy*oy; cn3=oz*oz;
	cn4=jx*jx; cn5=jy*jy; cn6=jz*jz;

	cn1= 1.0-3.0*cn1+2.0*cn1*ox;
	cn2= 1.0-3.0*cn2+2.0*cn2*oy;
	cn3= 1.0-3.0*cn3+2.0*cn3*oz;
	cn4= 1.0-3.0*cn4-2.0*cn4*jx;
	cn5= 1.0-3.0*cn5-2.0*cn5*jy;
	cn6= 1.0-3.0*cn6-2.0*cn6*jz;

	b00= hash[ (hash[ix & 255]+ iy) & 255];
	b10= hash[ (hash[(ix+1) & 255]+iy) & 255];
	b01= hash[ (hash[ix & 255]+ (iy+1)) & 255];
	b11= hash[ (hash[(ix+1) & 255]+ (iy+1)) & 255];

	b20=iz & 255; b21= (iz+1) & 255;

	i= (cn1*cn2*cn3);
		h=hashvectf+ 3*hash[(b20+b00) & 255];
		n+= i*(h[0]*ox+h[1]*oy+h[2]*oz);

	i= (cn1*cn2*cn6);
		h=hashvectf+ 3*hash[(b21+b00) & 255];
		n+= i*(h[0]*ox+h[1]*oy+h[2]*jz);

	i= (cn1*cn5*cn3);
		h=hashvectf+ 3*hash[(b20+b01) & 255];
		n+= i*(h[0]*ox+h[1]*jy+h[2]*oz);

	i= (cn1*cn5*cn6);
		h=hashvectf+ 3*hash[(b21+b01) & 255];
		n+= i*(h[0]*ox+h[1]*jy+h[2]*jz);

	i= cn4*cn2*cn3;
		h=hashvectf+ 3*hash[(b20+b10) & 255];
		n+= i*(h[0]*jx+h[1]*oy+h[2]*oz);

	i= cn4*cn2*cn6;
		h=hashvectf+ 3*hash[(b21+b10) & 255];
		n+= i*(h[0]*jx+h[1]*oy+h[2]*jz);

	i= cn4*cn5*cn3;
		h=hashvectf+ 3*hash[(b20+b11) & 255];
		n+=  i*(h[0]*jx+h[1]*jy+h[2]*oz);

	i= (cn4*cn5*cn6);
		h=hashvectf+ 3*hash[(b21+b11) & 255];
		n+= i*(h[0]*jx+h[1]*jy+h[2]*jz);

	if(n<0.0) n=0.0; else if(n>1.0) n=1.0 ;
	return n;
}


void turb(float noisesize, float xc, float yc, float zc, float *vec, int seed)
{
	register float cn1, cn2, cn3, cn4, cn5, cn6, i, *h;
	float x,y,z,ox, oy, oz, jx, jy, jz;
	int ix, iy, iz,b00, b01, b10, b11, b20, b21;
	int kx,ky,kz;

	vec[0] = vec[1] = vec[2] = 0;

	if(noisesize==0.0) 
	 return;


	x= (1.0+xc)/noisesize;
	y= (1.0+yc)/noisesize;
	z= (1.0+zc)/noisesize;


	ox= (x- (ix= (int)floorf(x)) );
	oy= (y- (iy= (int)floorf(y)) );
	oz= (z- (iz= (int)floorf(z)) );

	jx= ox-1;
	jy= oy-1;
	jz= oz-1;

	kx = ix + 1;
	ky = iy + 1;
	kz = iz + 1;
/*
	if (wrap_x)
	{
		if (xc > (1.0 - noisesize))
			kx = 0;
	}
*/
	cn1=ox*ox; cn2=oy*oy; cn3=oz*oz;
	cn4=jx*jx; cn5=jy*jy; cn6=jz*jz;

	cn1= 1.0-3.0*cn1+2.0*cn1*ox;
	cn2= 1.0-3.0*cn2+2.0*cn2*oy;
	cn3= 1.0-3.0*cn3+2.0*cn3*oz;
	cn4= 1.0-3.0*cn4-2.0*cn4*jx;
	cn5= 1.0-3.0*cn5-2.0*cn5*jy;
	cn6= 1.0-3.0*cn6-2.0*cn6*jz;

	b00= hash[ (hash[ix & 255]+ iy) & 255];
	b10= hash[ (hash[kx & 255]+iy) & 255];
	b01= hash[ (hash[ix & 255]+ ky) & 255];
	b11= hash[ (hash[kx & 255]+ ky) & 255];

	b20=iz & 255; b21= kz & 255;

	i= (cn1*cn2*cn3);
	h=hashvectf+ 3*hash[(b20+b00+ seed) & 255];
	vec[0] += h[0]*ox*i;
	vec[1] += h[1]*oy*i;
	vec[2] += h[2]*oz*i;

	
	i= (cn1*cn2*cn6);
		h=hashvectf+ 3*hash[(b21+b00+ seed) & 255];
	vec[0] += h[0]*ox*i;
	vec[1] += h[1]*oy*i;
	vec[2] += h[2]*jz*i;

	i= (cn1*cn5*cn3);
		h=hashvectf+ 3*hash[(b20+b01+ seed) & 255];
	vec[0] += h[0]*ox*i;
	vec[1] += h[1]*jy*i;
	vec[2] += h[2]*oz*i;

	i= (cn1*cn5*cn6);
		h=hashvectf+ 3*hash[(b21+b01+ seed) & 255];
	vec[0] += h[0]*ox*i;
	vec[1] += h[1]*jy*i;
	vec[2] += h[2]*jz*i;

	i= cn4*cn2*cn3;
		h=hashvectf+ 3*hash[(b20+b10+ seed) & 255];
	vec[0] += h[0]*jx*i;
	vec[1] += h[1]*oy*i;
	vec[2] += h[2]*oz*i;

	i= cn4*cn2*cn6;
		h=hashvectf+ 3*hash[(b21+b10+ seed) & 255];
	vec[0] += h[0]*jx*i;
	vec[1] += h[1]*oy*i;
	vec[2] += h[2]*jz*i;

	i= cn4*cn5*cn3;
		h=hashvectf+ 3*hash[(b20+b11+ seed) & 255];
	vec[0] += h[0]*jx*i;
	vec[1] += h[1]*jy*i;
	vec[2] += h[2]*oz*i;

	i= (cn4*cn5*cn6);
		h=hashvectf+ 3*hash[(b21+b11 + seed) & 255];
	vec[0] += h[0]*jx*i;
	vec[1] += h[1]*jy*i;
	vec[2] += h[2]*jz*i;
}


void recursive_turb(float noisesize, int hard, float x, float y, float z, float *vec, int nr, int seed)
{
	float d= 1.0, div = 0.0;
	float tvec[3];
	float total;	

	vec[0] = vec[1] = vec[2] = 0;
	while (nr >= 0)
	{
		turb(noisesize *d, x,y,z,tvec,seed);

		if (hard)
		{
			total = tvec[0] + tvec[1] + tvec[2];
			if (total < 0.0)
				total -= 2.0;
			else
				total += 2.0;
			tvec[0] *= total;
			tvec[1] *= total;
			tvec[2] *= total;
		}
		vec[0] += tvec[0] * d;
		vec[1] += tvec[1] * d;
		vec[2] += tvec[2] * d;

		div+= d;
		d *= 0.61;
		nr --;
	}
	vec[0] /= div;
	vec[1] /= div;
	vec[2] /= div;
}

float turbulence(float noisesize, float x, float y, float z, int nr)
{
	float s, d= 0.5, div=1.0;

	s= hnoise(noisesize, x, y, z);

	while(nr>0) {

		s+= d*hnoise(noisesize*d, x, y, z);
		div+= d;
		d*= 0.5;

		nr--;
	}
	return s/div;
}

float turbulence1(float noisesize, float x, float y, float z, int nr)
{
	float s, d= 0.5, div=1.0;

	s= fabs( (-1.0+2.0*hnoise(noisesize, x, y, z)));

	while(nr>0) {

		s+= fabs(d* (-1.0+2.0*hnoise(noisesize*d, x, y, z)));
		div+= d;
		d*= 0.5;

		nr--;
	}
	return s/div;
}
void vec_copy(float *va, float *vb)
{
	va[0] = vb[0];
	va[1] = vb[1];
	va[2] = vb[2];
}
float vec_len(float *v)
{
	return fsqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
}
void vec_add(float *v,float *va, float *vb)
{
	v[0] = va[0] + vb[0];
	v[1] = va[1] + vb[1];
	v[2] = va[2] + vb[2];
}
void vec_sub(float *v,float *va, float *vb)
{
	v[0] = va[0] - vb[0];
	v[1] = va[1] - vb[1];
	v[2] = va[2] - vb[2];
}

void vec_normalize(float *v)
{
	double l = vec_len(v);
	float li;
	if (l < 0.0000000001) l = 0.0000000001;
	li = 1.0 / l;
	v[0] *= li;
	v[1] *= li;
	v[2] *= li;
}

void point_turbulance(float noise_size, int hard, float x,float y, float z, float *vec, int depth, int wrap_x, int wrap_y, int seed)
{
	float vecb[3];
	float vecc[3];
	float  p1,p2;
	if (wrap_x)
	{
		x = (0.5 * (x + 1.0));
		x = x - floorf(x);
		x = (x)* 2.0 - 1.0;
	}
	if (wrap_y)
	{
		y = (0.5 * (y + 1.0));
		y = y - floorf(y);
		y = (y)* 2.0 - 1.0;
	}
	recursive_turb(noise_size, hard, x, y, z,vec,depth,seed);

	if (wrap_x)
	{
		recursive_turb(noise_size, hard, x - 2.0, y, z,vecb,depth,seed);
		p1 = s_curve((1.0 - (x))*0.5);
		p2 = s_curve((x +1.0)*0.5);
		vec[0] = (vec[0] * p1 + vecb[0] * p2);
		vec[1] = (vec[1] * p1 + vecb[1] * p2);
		vec[2] = (vec[2] * p1 + vecb[2] * p2);
	}

	if (wrap_y)
	{
		if (wrap_x)
		{
			recursive_turb(noise_size, hard, x, y-2.0, z,vecc,depth,seed);
			recursive_turb(noise_size, hard, x - 2.0, y-2.0, z,vecb,depth,seed);
			p1 = s_curve((1.0 - (x))*0.5);
			p2 = s_curve((x +1.0)*0.5);
			vecc[0] = (vecc[0] * p1 + vecb[0] * p2);
			vecc[1] = (vecc[1] * p1 + vecb[1] * p2);
			vecc[2] = (vecc[2] * p1 + vecb[2] * p2);

			p1 = s_curve((1.0 - (y))*0.5);
			p2 = s_curve((y+1.0) * 0.5);
			vec[0] = (vec[0] * p1 + vecc[0] * p2);
			vec[1] = (vec[1] * p1 + vecc[1] * p2);
			vec[2] = (vec[2] * p1 + vecc[2] * p2);
		}
		else
		{
			recursive_turb(noise_size, hard, x , y -2.0, z,vecb,depth,seed);
			p1 = s_curve((1.0 - (y))*0.5);
			p2 = s_curve((y+1.0) * 0.5);
			vec[0] = (vec[0] * p1 + vecb[0] * p2);
			vec[1] = (vec[1] * p1 + vecb[1] * p2);
			vec[2] = (vec[2] * p1 + vecb[2] * p2);
		}
	}
}


#endif

