/* Copy lefted.
 * 
 * rings2.c
 *
 * blender plugin for pie shaped divs.
 *
 * (source by Robert Wenzlaff, 9/27/00)
 * 
 * Contact:      rwenzlaff@soylent-green.com
 * Information:  http://www.soylent-green.com
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


#include "math.h"
#include "plugin.h"

#define NR_TYPES	1

#define REV "0.1.0"
#define SPACER LABEL,"",0,0,0,""

float result[8];
float cfra;

int	do_reset = FALSE;

extern float hnoise(float noisesize, float x, float y, float z);

/* set up plugin menu */

char name[]= "Rings2";
char stnames[NR_TYPES][16]= {"Rings2 "};



VarStruct varstr[]= {
	/* type,	name,		default,min,   	max, 	tooltips */
	{ LABEL,	REV,	0, 	0,	0,	""},
	{ NUM|FLO,	"phase ", 	0.5, 	-1.0, 	1.0,	
	   "Start phase of rings"},
			/* Start Phase */
	{ SPACER },
   	{ NUM|FLO,	"phase vel ", 	0.0, 	-10.0, 	10.0,	
	   "Phase rate of change" },
			/* Phase first deriv. */
        { NUM|FLO,	"Vel rand. ", 0.0,	0.0, 	5.0,	
	   "Velocity randomness"},
    		/* Vel. Randomnes */
	{ SPACER },
	{ NUM|FLO, 	"phase accel ", 0.0,	-10.0,		10.0,	
	   "Rate of vel. change"},
			/* Second Deriv. */
	{ NUM|FLO,	"accel rand. ", 0.0,	0.0, 	5.0,	
	   "Accel randomness "},
			/* determins sharpnes of edge, could use some work */
	{ SPACER },
	{ NUM|FLO,    "turb dep ",0.0,    0.0, 	5.0,    "Turbulance depth"},
			/* Pos. Turb affects 'white', Neg. affects 'black' */
	{ NUM|FLO, 	"turb siz ",0.0, 	0.0, 	2.0,	
           "Turbulance size"},
	{ SPACER },
	{ NUM|FLO, 	"Thresh",	0.5,	0.0,	1.0,    
	   "Treshhold "},
	{ NUM|FLO, 	"hardness ", 0.70,	0.0,	1.0, 	
           "Falloff hardness "},
	{ SPACER }
			/* falloff rate */

};
typedef struct Cast {
	float dum1;
	float phase;
	float dum2;
	float vel;
	float vnoise;
	float dum3;
	float accel;
	float anoise;
	float dum4;
	float turbd;
	float turbs;
	float dum5;
	float thresh;
	float hard;
	float dum6;
} Cast;

/* ******************************************************************* */

int plugin_tex_doit(int, Cast*, float*, float*, float*);

int plugin_tex_getversion(void) 
{	
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{



}

void plugin_init(void)
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->stypes= NR_TYPES;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	
	info->snames= stnames[0];
	info->result= result;
	info->cfra= &cfra;
	info->varstr= varstr;

	info->init= plugin_init;
	info->tex_doit=  (TexDoit) plugin_tex_doit;
	info->callback= plugin_but_changed;
}

int plugin_tex_doit(int stype, Cast *cast, float *texvec, float *dxt, float *dyt)
{

	float dist,an=0,vn=0,turb=0,hard;
    float x,y,z;
	
	x=texvec[0]; y=texvec[1]; z=texvec[2];

	if (cast->turbd!=0.0) turb=turbulence(cast->turbs,x,y,z,cast->turbd)/10;
    if (cast->anoise!=0.0) an=hnoise(cast->anoise,x,y,z)/100;
	if (cast->vnoise!=0.0) vn=hnoise(cast->vnoise,x,y,z)/100;

	
	hard=(1-cast->hard) / 4;
    	
	dist=sqrt(x*x+y*y)	+ cast->phase
				+ (cast->vel/100 + vn )* cfra
				+ 0.5*(cast->accel/1000 + an )* cfra * cfra
				+ turb;

	
	dist=(dist-(int)dist)+(1&dist<0);
	
	
    if (dist < hard) {
     	 result[0]=result[1]=result[2]=dist/hard;
	}
	else if ((dist >= hard)&&(dist < cast->thresh) ){
         result[0]=result[1]=result[2]=1.0;
     	}
	else if ((dist >= cast->thresh) && (dist < cast->thresh + hard) ) {
         result[0]=result[1]=result[2]=1.0- (dist-cast->thresh)/hard;
	}
	else result[0]=result[1]=result[2]=0.0;
    	
	return 0;
}

