/* Copy lefted.
 * 
 * scales.c
 *
 * blender plugin for pie shaped divs.
 *
 * (source by Robert Wenzlaff, 7/18/00)
 * 
 * Contact:      rwenzla@utoledo.edu
 * Information:  http://www.geocities.com/rwenzlaff/BlenderLinks
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	Rev   0.1.0   7-18-00  -RPW
 *		Initial Release.
 *		TODO: Edge lines on normals? Like Feathers?
 *			  Normalize settings to useful values
 *			  eg: Edge noise looks best w/ siz=0.08 & dep = 0.01
 *			  move sweet spot to a midrange value.
 */


#include "math.h"
#include "plugin.h"

#define NR_TYPES	1

#define REV "0.1.0"			/*Release 7/20/00*/


float result[8];
float cfra;

int	do_reset = FALSE;

extern float hnoise(float noisesize, float x, float y, float z);

/* set up plugin menu */

char name[]= "Scales ";
char stnames[NR_TYPES][16]= {"Scales "};

VarStruct varstr[]= {
	/* type,	name,		default,min,   	max, 	tooltips */
			/* Leftmost Red/Gr/Bl Val */
	{ NUM|FLO,	"StRed ", 	0.3, 	0.0, 	1.0,	
	   "Scales plugin: Starting Red"},
	{ NUM|FLO,	"StGrn ", 	0.3,	0.0, 	1.0,	
	   "Scales Plugin: Starting Green"},
	{ NUM|FLO,	"StBlu ", 	0.3,	0.0, 	1.0,	
	   "Scales Plugin: Starting Blue"},
   			/* Final Colors (Rightmost)*/
        { NUM|FLO,	"FinRed ", 	0.8, 	0.0, 	1.0,	
	   "Scales plugin: Starting Red"},
	{ NUM|FLO,	"FinGrn ", 	0.8,	0.0, 	1.0,	
	   "Scales Plugin: Starting Green"},
	{ NUM|FLO,	"FinBlu ",	0.8,	0.0, 	1.0,	
	   "Scales Plugin: Starting Blue"},
        { LABEL,		REV,	0, 	0,	0,	""},
    		/* Color Noise */
	{ NUM|FLO,    "ColNoiseS ", 0.0, 	0.0, 	1.0,    
	   "Scales Plugin: Color Noise Size "},
	{ NUM|FLO,    "ColNoiseD ", 0.0, 	0.0, 	1.0,    
	   "Scales Plugin: Color Noise Depth "},
        { LABEL,		"", 	0, 	0,	0,	""},
	        /* Edge Noise */
	{ NUM|FLO,	"EdgNoiseS ", 0.0, 	0.0, 	1.0, 	
	   "Scales Plugin: Edge Noise Size "},
        { NUM|FLO,    "EdgNoiseD ", 0.0, 	0.0, 	1.0,    
	   "Scales Plugin: Edge Noise Depth "},
          /* Normal Noise */
	{ LABEL, 		"", 	0, 0,	0, 	""},
        { NUM|FLO,  	"NorNoiseS ", 0.0, 	0.0, 	1.0, 	
	   "Scales Plugin: Norm Noise Size "},
	{ NUM|FLO, 	"NorNoiseD ", 0.0, 	0.0, 	1.0, 	
	   "Scales Plugin: Norm Noise Depth."}

};

typedef struct Cast {
	float StRed, StGrn, StBlu;
	float FinRed, FinGrn, FinBlu;
	float dum3;
	float ColNoiseSiz,  ColNoiseDep;
	float dum4;
	float EdgeNoiseSiz, EdgeNoiseDep;
	float dum5;
	float NorNoiseDep, NorNoiseSiz;
} Cast;

/* ******************************************************************* */

int plugin_tex_doit(int, Cast*, float*, float*, float*);

int plugin_tex_getversion(void) 
{	
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init(void)
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->stypes= NR_TYPES;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	
	info->snames= stnames[0];
	info->result= result;
	info->cfra= &cfra;
	info->varstr= varstr;

	info->init= plugin_init;
	info->tex_doit=  (TexDoit) plugin_tex_doit;
	info->callback= plugin_but_changed;
}

int plugin_tex_doit(int stype, Cast *cast, float *texvec, float *dxt, float *dyt)
{
	/* mod x, y */
    float cr=0,cg=0,cb=0,er=0, nx=0, ny=0,x,y;

	y=5001-texvec[0];    /* Normalize to 0-1  */
	y=y-(int)y;

	x=5001-texvec[1];
	x=x-(int)x;

/* printf("Args: texvec[0]= %f X=%f Y=%f\n",texvec[1],x,y); */

	if (cast->EdgeNoiseDep !=0) {
	er=hnoise(cast->EdgeNoiseSiz,texvec[0], texvec[1], texvec[2])-0.5;
    er*=cast->EdgeNoiseDep;
	}

	if (cast->ColNoiseDep !=0) {
		cr=hnoise(cast->ColNoiseSiz, texvec[0], texvec[1], texvec[2])-0.5;
		cr*=cast->ColNoiseDep;
		cg=hnoise(cast->ColNoiseSiz, texvec[2], texvec[0], texvec[1])-0.5;
		cg*=cast->ColNoiseDep;
		cb=hnoise(cast->ColNoiseSiz, texvec[0], texvec[2], texvec[1])-0.5;
		cb*=cast->ColNoiseDep;
	}

	if (cast->NorNoiseDep!=0){
		nx=hnoise(cast->NorNoiseSiz, texvec[0], texvec[1], texvec[2])-0.5;
		nx*=cast->NorNoiseDep;	
		nx=hnoise(cast->NorNoiseSiz, texvec[1], texvec[0], texvec[2])-0.5;
		nx*=cast->NorNoiseDep;			
	}


	if ( ((x-0.5)*(x-0.5)+(y+er)*(y+er) )< 0.25 ) {   /* -.5>y>.5, 0>x>1 */
		
		result[1]=(0.5-y)*cast->StRed+(0.5+y)*cast->FinRed +cr;
		result[2]=(0.5-y)*cast->StGrn+(0.5+y)*cast->FinGrn +cg;
		result[3]=(0.5-y)*cast->StBlu+(0.5+y)*cast->FinBlu +cb;
		result[0]=(result[1]+result[2]+result[3])/3.0;
		/*printf("case 1: Results %f %f %f %f\n", result[0],result[1],result[2],result[3]); */
		
		result[5]=(4*(x-0.5)*(x-0.5)+nx);
		result[6]=y+ny;

    }
	
    else if ( ( ( x*x   + (y-0.5+er)*(y-0.5+er) ) < 0.25)  ||
			( ( (x-1)*(x-1) + (y-0.5+er)*(y-0.5+er) ) < 0.25) ) {  /*0<y1, 0<x<1*/
		result[1]=(1-y)*cast->StRed+(y+cr)*cast->FinRed +cr;
		result[2]=(1-y)*cast->StGrn+(y+cg)*cast->FinGrn +cg;
		result[3]=(1-y)*cast->StBlu+(y+cb)*cast->FinBlu +cb;
		result[0]=(result[1]+result[2]+result[3])/3.0;
        /*printf("case 2: Results %f %f %f %f\n", result[0],result[1],result[2],result[3]); */

		if (x>0.5) x=1-x;
		result[5]=(4*x*x)+nx;
		result[6]=(y-0.5)+ny;
	}

	else  {
		result[1]=(1.5-y)*cast->StRed+(y-0.5)*cast->FinRed + cr;
		result[2]=(1.5-y)*cast->StGrn+(y-0.5)*cast->FinGrn + cg;
		result[3]=(1.5-y)*cast->StBlu+(y-0.5)*cast->FinBlu + cb;
		result[0]=(result[1]+result[2]+result[3])/3.0;
        /*printf("Default: Results %f %f %f %f\n", result[0],result[1],result[2],result[3]); */

		result[5]=(4*(x-0.5)*(x-0.5)+nx);
		result[6]=(y-1)+ny;
	}

	result[4]=1.0;
	result[7]=0;

	return 3;   /* Everything */
}

