/* 
Simple playing with the sin function.
Created by SirDude(mein@cs.umn.edu)
Tue Aug  7 12:58:35 CDT 2001
*/

#include "math.h"
#include "plugin.h"

/* Texture name */
char name[24]= "Sinus";

#define NR_TYPES        3
char stnames[NR_TYPES][16]= {"Intens","Color", "Bump"};

/* Structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
   {NUM|FLO,        "Const 1",       1.7,        -1.0, 1.0, ""},
   {NUM|FLO,        "Const 2",       1.5,        -1.0, 1.0, ""},
   {NUM|FLO,        "Const 3",        .9,        -1.0, 1.0, ""},
   {NUM|FLO,        "Tolerance",        .1,        0, 1.0, ""},
};


typedef struct Cast {
        float a,b,c,tol;
} Cast;

float result[8];
float cfra;
int plugin_tex_doit(int, Cast*, float*, float*, float*);

/* Fixed Functions */
int plugin_tex_getversion(void) {
        return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) { }

void plugin_init(void) { }

void plugin_getinfo(PluginInfo *info) {
        info->name= name;
        info->stypes= NR_TYPES;
        info->nvars= sizeof(varstr)/sizeof(VarStruct);

        info->snames= stnames[0];
        info->result= result;
        info->cfra= &cfra;
        info->varstr= varstr;

        info->init= plugin_init;
        info->tex_doit=  (TexDoit) plugin_tex_doit;
        info->callback= plugin_but_changed;
}

/* Start of texture code */
int plugin_tex_doit(int stype, Cast *cast, float *texvec, float *dxt, 
   float *dyt) {
   float z1,z2,z3, ans;

   z1=(float)sin(((texvec[0]+texvec[2]))/(cast->a*2));
   z2=(float)sin((texvec[0]/3+texvec[1])/cast->b*2);
   z3=(float)sin((texvec[1]+texvec[2])/(cast->c*2));
   ans = (float)(z1 + z2 + z3)/ 3.0;
   if (ans < cast->tol) {
      result[0] = ans;
   } else {
      result[0] = 1;
   }
   if (stype == 1) {
      result[1] = z1;
      result[2] = z2;
      result[3] = z3;
      result[4] = result[0];
      return 1;
   } if (stype == 2) {
      result[5] = result[0];
      result[6] = 1- result[0];
      result[7] = 0.0;
      return 2;
   }
   return 0; 
}
