/*
 * Copyright (c) 2001, Armagan YAVUZ
 * based on sample file by NAN
 */

#include <math.h>
#include "t_texture.h"

char name[24]= "T_Clouds";

/* Subtype names must be less than 15 characters */

#define NR_TYPES	0
/*char stnames[NR_TYPES][16]= {}; */

/* Structure for buttons,
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
{	LABEL|INT,   " ",             0.,    0.,   0.,   ""},
{	NUM|FLO,	"Noise Size",		0.25, 	0.0001, 2.0, ""},
{	NUM|INT,	"Noise Depth",		2.0, 	0.0, 6.0, ""},
{	NUM|FLO,	"Detail Size",		0.5, 	0.0001, 1.0, ""},
{ 	TOG|INT,	"Hard Noise",   0.0,	 0.0, 1.0,  ""},
{	NUM|INT,	"Seed",		0.0, 	0.0, 255.0, ""},
{ 	TOG|INT,	"BumpMap",   1.0,	 0.0, 1.0,  
	"Generate bump map"},
{	NUM|FLO,	"Filter",		0.15, 	0.0001, 1.0, 
	"Lower means better accuracy, higher means less artefacts"},
{ 	TOG|INT,	"Two-way filter",   0.0,	 0.0, 1.0,  
	"Use slower (and higher quality) bumpmap method"},
{	NUM|INT,	"OSA",		1.0, 	1.0, 16.0, 
	"Number of samples used in OSA mode"},
{	NUM|FLO,	"Map Max",		1.0, 	0.0, 1.0, ""},
{	NUM|FLO,	"Map Min",		0.0, 	0.0, 1.0, ""},
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order,
   INCLUDING dummy variables for label fields. */

typedef struct Cast {
	int dummy;
	float noise_size;
	int depth;
	float falloff;
	int hard_noise;
	int seed;
	int do_bump;
	float filter;
	int double_bump;
	int osa;
	float map_max;
	float map_min;
} Cast;

/* result:
   Intensity, R, G, B, Alpha, nor.x, nor.y, nor.z
 */

float result[8];

/* cfra: the current frame */

float cfra;

int plugin_tex_doit(int, Cast*, float*, float*, float*);

/* ******************** Fixed functions ***************** */

int plugin_tex_getversion(void)
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but)
{
}

void plugin_init(void)
{

}

/* this function should not be changed: */

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->stypes= NR_TYPES;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);

	info->snames= NULL; 
	info->result= result;
	info->cfra= &cfra;
	info->varstr= varstr;

	info->init= plugin_init;
	info->tex_doit=  (TexDoit) plugin_tex_doit;
	info->callback= plugin_but_changed;
}

float intensity(int stype, Cast *cast, float x,float y, float z)
{
	float vec[3];
	float res;
	float max;
	float min;
	point_turbulance(cast->noise_size, cast->falloff, cast->hard_noise, 
		x, y, z, vec, cast->depth,cast->seed);

	res = (vec[0]  + vec[1] + vec[2] ) + 0.5;

	if (cast->hard_noise == 1)
	{
		res = (vec[0]  + vec[1] + vec[2]);
	}
	max = cast->map_max;
	min = cast->map_min;
	if (max <= min)
	{
		max = (max + min) * 0.05;
		min = max - 0.01;
	}
	if (res < min)
		res = 0.0;
	else if (res > max)
		res = 1.0;
	else
		res = (res - min) / (max - min);
	res = CLAMP(res,0.0,1.0);
	return res;
}


#define between(x,a,b) (((a) <= (x))&&((x) < (b)))
#define FRAND (((((float)(((unsigned int)rand()) & 8191)) / 4096.0) - 1.0) * 0.5)
/*#define FIXED_RAND(x,y,z,seed) float(hash[(hash[(hash[((seed) + (x)) & 255] + (y)) & 255] + (z)) & 255]) / 256.0; */

int plugin_tex_doit(int stype, Cast *cast, float *texvec, float *dxt, 
	float *dyt)
{
	float s;
	int i,optimum_osa_level;
	float sample_factor;
	float osa_size,good_osa_size;
	float bump_factor;
	float fx,fy;
	float osa_color;
	float x,y,z,tresult,first_result;

	bump_factor = 0.05;
	s = cast->noise_size;
  	s = s * cast->filter;
	if (cast->depth > 0)
		s = s * cast->falloff;
	for (i=1; i<cast->depth; i++)
	  s = s * 0.6;
	if (dxt) 
	{
		osa_size = vec_len(dxt) + vec_len(dyt);
		good_osa_size = (cast->noise_size * 0.5); 
		sample_factor = 1.0;
		if (osa_size > good_osa_size)
		{
			sample_factor = (osa_size / good_osa_size);
		}
		bump_factor /= sample_factor;

		osa_color = 0.0f;
/*		optimum_osa_level = MIN2(cast->osa, (int)(sample_factor)); */
		optimum_osa_level = cast->osa;
		for (i=0; i<optimum_osa_level; i++)
		{
			fx = fixed_rand(2 *i,texvec[0],texvec[1],texvec[2]) - 
				0.5;
			fy = fixed_rand(2 *i +1,texvec[0],texvec[1],texvec[2]) -
				0.5;
			tresult = intensity(stype,cast,texvec[0] + 
				(dxt[0] * fx + dyt[0] * fy) , texvec[1] + 
				(dxt[1] * fx + dyt[1] * fy) , texvec[2] + 
				(dxt[2] * fx + dyt[2] * fy));
			if (i==0)
			{
				first_result = tresult;
				x = texvec[0] + (dxt[0] * fx + dyt[0] * fy);
				y = texvec[1] + (dxt[1] * fx + dyt[1] * fy);
				z = texvec[2] + (dxt[2] * fx + dyt[2] * fy);
			}
			osa_color += tresult;
		}
		result[0] = osa_color / (float)(optimum_osa_level);
	}
	else
	{
		x = texvec[0];
		y = texvec[1];
		z = texvec[2];
		first_result = intensity(stype,cast,texvec[0], texvec[1], 
			texvec[2]);
		result[0] = first_result;
	}
	if (cast->do_bump)
	{
		result[5] = intensity(stype,cast,x + s, y    , z    ) - 
			first_result ;
		result[6] = intensity(stype,cast,x    , y + s, z    ) - 
			first_result ;
		result[7] = intensity(stype,cast,x    , y    , z + s) - 
			first_result ;
		if (cast->double_bump)
		{
			result[5] -= intensity(stype,cast,x - s, y    , z    ) 
				- first_result ;
			result[6] -= intensity(stype,cast,x    , y - s, z    ) 
				- first_result ;
			result[7] -= intensity(stype,cast,x    , y    , z - s) 
				- first_result ;
			result[5] *= 0.5;
			result[6] *= 0.5;
			result[7] *= 0.5;	
		}
		result[5] *= bump_factor / s;
		result[6] *= bump_factor / s;
		result[7] *= bump_factor / s;
		return 2;
	}
	return 0;
}
