#include <math.h>
#include <string.h>

typedef unsigned short word;
typedef unsigned char byte;
typedef unsigned uint;

const int	rwDATA				    = 1;
const int	rwSTRING				= 2;
const int	rwEXTENSION				= 3;
const int	rwTEXTURE				= 6;
const int	rwMATERIALLIST			= 8;
const int	rwMATERIAL				= 7;
const int	rwFRAMELIST				= 14;
const int	rwGEOMETRY				= 15;
const int	rwCLUMP					= 16;
const int	rwLIGHT					= 18;
const int	rwATOMIC				= 20;
const int	rwTEXTURENATIVE			= 21;
const int	rwTEXTUREDICTIONARY		= 22;
const int	rwGEOMETRYLIST			= 26;
const int	rwMORPH_PLG				= 261;
const int	rwSKYMIPMAPVAL			= 272;
const int	rwHANIM_PLG				= 286;
const int	rwMATERIALSPLIT			= 1294;
const int	rwFRAME					= 39056126;

const int	rwOBJECT_VERTEX_UV		= 4;
const int	rwOBJECT_VERTEX_COLOR	= 8;
const int	rwOBJECT_VERTEX_NORMAL	= 16;

const int	MOVE_AMOUNT = 3;
const int	ROT_AMOUNT = 3;


// helper types

struct TVector2f {
	float	v[2];
};

struct TVector3f {
	float	v[3];
};

struct TMatrix3f {
	GLfloat	v[9];
};

//Added by Colossus on 17/10/04 to multiply the relative matrix of a frame with the absolute one of its parent
struct TMatrix4f {
	GLfloat	v[16];
};

struct TColorub {
	byte	r;
	byte	g;
	byte	b;
	byte	a;
};

struct THeader {
	uint	Start;
	uint	Back;
	uint	Tag;
	uint	Size;
	word	Data1; //D: 784
	word	Data2; //D: 784
};


// DFF types

struct TDFFFace {
	word		V2;
	word		V1;
	word		Extra;
	word		V3;
};

struct TDFFUV {
	float		U, V;
};

struct TDFFFrame {
	char		Name[64];
	TMatrix3f	Matrix;
	TMatrix4f	Copy_of_Matrix;
	TMatrix4f	LTM;
	TVector3f	Coord;
	uint		Parent;
	word	Other1, Other2;
};

struct TDFFDataClump {
	uint		ObjectCount;
};

struct TDFFDataFrameList {
	uint		FrameCount;
	TDFFFrame	*Frame;
	uint		FrameUpTo;
};

struct TDFFDataGeometryList {
	uint		GeometryCount;
};

struct TDFFDataAtomic {
	uint		FrameNum;
	uint		GeometryNum;
	uint		Other1; //D: 5
	uint		Other2; //D: 0
};

struct TDFFHeaderDataGeometry {
	word		Flags1;
	word		Flags2;
	uint		TriangleCount;
	uint		VertexCount;
	uint		OtherCount;
};
                
struct TDFFLightHeaderDataGeometry {
	float		Ambient;
	float		Diffuse;
	float		Specular;
};

struct TDFFExtraDataGeometry {
	float		U1, U2, U3, U4;
	uint		Other1, Other2; //D: 1
};

struct TDFFDataGeometry {
	TDFFHeaderDataGeometry		Header;
	TDFFLightHeaderDataGeometry	LightHeader;
	TColorub					*Color;
	TVector2f					*UV;
	TDFFFace					*Face;
	TDFFExtraDataGeometry		Extra;
	TVector3f					*Vertex;
	TVector3f					*Normal;
};

struct TDFFDataMaterialList {
	uint	MaterialCount;
	uint	Other; //D: FF
};

struct TDFFDataMaterial {
	uint		Other1; //D: 0
	byte		Color[4];
	uint		Other3;
	uint		TextureCount; //D: 1
	float		Other5; //D: 1.0
	float		Other6;
	float		Other7; //D: 1.0
};

struct TDFFTexture {
	char		Name[32];
	char		Alpha[32];
	//Texture		*tex;
};

struct TDFFMaterial {
	TDFFDataMaterial	Data;
	TDFFTexture		Texture;
};

struct TDFFHeaderMaterialSplit {
	uint		Data;
	uint		SplitCount;
	uint		FaceCount;
};

struct TDFFSplit {
	uint		FaceCount;
	uint		MaterialIndex;
	uint		*Index;
};

struct TDFFMaterialSplit {
	TDFFHeaderMaterialSplit	Header;
	TDFFSplit				*Split;
};

struct TDFFMaterialList {
	TDFFDataMaterialList	Data;
	TDFFMaterial			*Material;
	uint					MaterialCount;
};

struct TDFFGeometry {
	TDFFDataGeometry	Data;
	TDFFMaterialList	MaterialList;
	TDFFMaterialSplit	MaterialSplit;
};

struct TDFFFrameList {
	TDFFDataFrameList	Data;
};

struct TDFFGeometryList {
	TDFFDataGeometryList	Data;
	TDFFGeometry			*Geometry;
	uint					GeometryCount;
};

struct TDFFAtomic {
	TDFFDataAtomic		Data;
	TDFFAtomic			*next;
};

struct TDFFClump {
	TDFFDataClump		Data;
	TDFFFrameList		FrameList;
	TDFFGeometryList	GeometryList;
	TDFFAtomic			*Atomic;
};


// TXD types

struct TTXDDataTexture {
	uint				const8;
	uint				flags1;
	char				name[32];
	char				alphaname[32];
	uint				flags2;
	uint				hasalpha;
	word				width;
	word				height;
	byte				bpp;
	byte				mipmaps;
	byte				const4;
	byte				compression;
};

struct TTXDTexture {
	TTXDDataTexture		Data;
};

struct TTXDDict {
	uint				TextureCount;
	TTXDTexture			*Textures;
	uint				CurrentTex;
};
