/***************************************************************************
 *   Copyright (C) 2004 by Colossus (Giuseppe Torelli)                     *
 *   gt67@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GLWIDGET_H
#define GLWIDGET_H

#include <qgl.h>
#include <qevent.h>
#include <qcursor.h>
#include <qlineedit.h>
#include "3ds.h"
#include "glwindow.h"

struct CVector7
{
	bool checked;
	GLfloat x,y,z,xrot,yrot,zrot,sx,sy,sz;
	inline CVector7() {}
	inline CVector7( bool _checked , GLfloat _x, GLfloat _y, GLfloat _z, GLfloat _xrot, GLfloat _yrot, GLfloat _zrot, GLfloat _sx, GLfloat _sy, GLfloat _sz ) :
 	checked(_checked), x(_x), y(_y), z(_z), xrot(_xrot), yrot(_yrot), zrot(_zrot), sx(_sx), sy(_sy), sz(_sz) {}
};
class GlWindow;

class GLWidget : public QGLWidget
{
    Q_OBJECT

public:
	GLWidget( TextureLoader *m_textureLoaderClass , GlWindow* window, QWidget *parent, const char* name );
	GLWidget();
	~GLWidget();
	GlWindow *GlWindowClass;
	TextureLoader* TextureClassPointer;
	void SetCamera();
	void getOpenGLmouseCoords();
	void UpdateItemEditorDialog ( unsigned int );
	GLuint GetObjectHitByMouse();
	void DeleteModel ( unsigned int ChoosedModel );
	bool LeftMousePressed , RightMousePressed, Ctrl_Pressed;
	int mouseX , mouseY;
	vector <CVector7> Model;
	vector <int> Models_Deleted;
	GLuint ChoosedModel;
	GLfloat AngleX , AngleY , AngleZ , Depth, Tx , Ty, Default_AngleX , Default_AngleY , Default_AngleZ , Default_Tx , Default_Ty, Default_Depth;
	GLdouble IpX , IpY , IpZ;
	GLenum mode;
	QString model_values;
	
protected:
	void	initializeGL();
	void	paintGL();
	void resizeGL( int w, int h );
	
protected slots:
	virtual void mouseMoveEvent ( QMouseEvent * event );
	virtual void mousePressEvent ( QMouseEvent * );
	virtual void mouseReleaseEvent ( QMouseEvent * );
	virtual void keyPressEvent ( QKeyEvent * );
	virtual void wheelEvent ( QWheelEvent * we );
};
#endif // GLWIDGET_H


