/***************************************************************************
 *   Copyright (C) 2004 by Colossus (Giuseppe Torelli)                     *
 *   gt67@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GLOBJWIN_H
#define GLOBJWIN_H

#include <qwidget.h>
#include <qslider.h> 
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>
#include <qtooltip.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qapplication.h>
#include <qmainwindow.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qstatusbar.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qpixmap.h>

#include "glwidget.h"
#include "3ds.h"
#include "dff.h"
#include "itemdialog.h"
#include "textureloader.h"

class GLWidget;
class ItemDialogClass;
class TextureLoader;
class Undo;

class GlWindow : public QMainWindow
{
Q_OBJECT
public:
	GlWindow();
	~GlWindow();
	bool IsModified , del , Insert_Flag , Insert_in_Dummy_Flag;
	GLWidget *c;
	QToolButton *sceneNewAction , *openSceneAction, *deleteModelAction, *importModelAction, *quitAction, *setCameraAction, *setInsertPointAction, *saveSceneAction, *aboutAction, *undoAction, *redoAction;
	ItemDialogClass *ItemDialog;
	Undo *UndoClass;
	QStatusBar *StatusBar;
	GLuint Index_Display_List;
	int response;
	string Copy_of_filename;
	TextureLoader *m_textureLoaderClass;
	QString SceneFileName , Different_Path_Name;
	QFile FileHandle;
	vector <uint> dummy_id_vector;
	map < GLuint , string > DisplayList;
	map < string , int > SameTextureListCnt;
	multimap < GLuint , string > TextureNamesMap;
	int LoadModelFile ( QString dummyfilename );
	GLfloat FrameMatrix[16];
	GLuint Generate_3DS_Display_List ( Load3ds::t3DModel g_3DModel );
	GLuint Generate_DFF_Display_List ();
	void DeleteEverything ();
	void Add_Model_Coordinates ( bool _checked , GLfloat _x, GLfloat _y, GLfloat _z, GLfloat _xrot, GLfloat _yrot, GLfloat _zrot, GLfloat _sx, GLfloat _sy, GLfloat _sz );
			
private:
	Load3ds my3ds;
	LoadDFF mydff;
	Load3ds::t3DModel g_3DModel;

public slots:
	void New_Scene();
	void Import_Object();
 	void Open_Scene();
	void Delete_Object();
	void InsertPoint();
 	void Save_Scene();
	void About();
	void Undo_Action();
	void Redo_Action();
	void closeEvent( QCloseEvent* ce );
	void Set_Default_ViewPoint();
};

#endif // GLOBJWIN_H
