/***************************************************************************
 *   Copyright (C) 2004 by Colossus (Giuseppe Torelli)                     *
 *   gt67@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include <qvariant.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <qlistbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include "itemdialog.h"

static const unsigned char image0_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x9d, 0x92, 0x5d, 0xf2, 0x00, 0x00, 0x00,
    0x54, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xed, 0xd4, 0xc1, 0x09, 0x00,
    0x30, 0x08, 0x03, 0xc0, 0xd8, 0xb1, 0xdc, 0x9f, 0xac, 0xd5, 0xbe, 0xfa,
    0xac, 0xc6, 0xe2, 0xa7, 0xd0, 0x0c, 0x70, 0x84, 0x08, 0x1a, 0x49, 0x74,
    0x64, 0xb4, 0x28, 0x6f, 0x41, 0xee, 0x3e, 0x5b, 0xa0, 0x2a, 0x76, 0x84,
    0x48, 0x5a, 0x05, 0x0b, 0x1b, 0x55, 0xb0, 0x74, 0x6c, 0x15, 0x93, 0xae,
    0xa6, 0x60, 0x12, 0xb4, 0x81, 0x0d, 0x5e, 0x41, 0x0a, 0x92, 0x42, 0x2a,
    0x12, 0x42, 0x15, 0x24, 0x6d, 0xa4, 0x22, 0x00, 0x60, 0xff, 0x8d, 0xa4,
    0x59, 0x44, 0xd4, 0x2a, 0x76, 0xd2, 0xcd, 0xd3, 0x1f, 0x00, 0x00, 0x00,
    0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image1_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x9d, 0x92, 0x5d, 0xf2, 0x00, 0x00, 0x00,
    0x52, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xed, 0xd4, 0x31, 0x0e, 0x00,
    0x20, 0x08, 0x03, 0x40, 0xf1, 0x59, 0xfc, 0x3f, 0xfd, 0x96, 0x4e, 0xac,
    0xb4, 0x28, 0x8b, 0x89, 0x7d, 0xc0, 0x0d, 0x2d, 0xc1, 0x00, 0x8c, 0x8e,
    0xcc, 0x16, 0xe5, 0x7d, 0xc8, 0xdd, 0xd7, 0x35, 0x94, 0x21, 0x32, 0x14,
    0x08, 0x00, 0x3b, 0x86, 0x14, 0x84, 0x42, 0x2a, 0x92, 0x42, 0x15, 0x24,
    0x85, 0x02, 0x60, 0x25, 0x53, 0xa8, 0x8a, 0xd1, 0xb2, 0x55, 0x4c, 0x9a,
    0x5f, 0xc1, 0xe4, 0x83, 0x64, 0xa5, 0xdb, 0x7f, 0x23, 0x34, 0x1b, 0xf3,
    0x41, 0x2a, 0x76, 0x05, 0xc6, 0x37, 0x17, 0x00, 0x00, 0x00, 0x00, 0x49,
    0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image2_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x9d, 0x92, 0x5d, 0xf2, 0x00, 0x00, 0x00,
    0x56, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xed, 0xd3, 0x31, 0x0a, 0xc0,
    0x30, 0x0c, 0x03, 0x40, 0xb9, 0xcf, 0xf2, 0xff, 0xd1, 0xb7, 0xd2, 0xa9,
    0x10, 0x4c, 0x2c, 0x2a, 0x08, 0x59, 0x5a, 0x6f, 0x1a, 0x7c, 0x08, 0x83,
    0x83, 0x24, 0x76, 0xcc, 0xb5, 0x45, 0xf9, 0x20, 0x94, 0x99, 0x43, 0x65,
    0xab, 0x91, 0x8b, 0x2d, 0x21, 0x92, 0x31, 0x2f, 0xd7, 0x6c, 0x35, 0x72,
    0x31, 0x79, 0x6c, 0x07, 0x93, 0x50, 0x07, 0x3c, 0xf9, 0x15, 0xe4, 0x20,
    0x2d, 0xe4, 0x22, 0xb2, 0x51, 0x5d, 0x52, 0x08, 0x00, 0xc4, 0xff, 0xfd,
    0xe7, 0xa0, 0x1b, 0x62, 0x46, 0x40, 0x23, 0x30, 0x74, 0x9a, 0x43, 0x00,
    0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const char* const image3_data[] = { 
"18 19 10 1",
"a c #000000",
". c #e6e2d7",
"h c #e7e3d8",
"g c #e8e4da",
"f c #eae6db",
"e c #ebe7dc",
"d c #ece8dd",
"c c #ede9de",
"b c #efebdf",
"# c #f0ece1",
"..................",
"..................",
"..................",
"..................",
"..................",
"....####abbba.....",
"....bbbaabbaa.....",
"....ccaacbaac.....",
"....daadbaadd.....",
"....aaebaaeee.....",
"....faafbaaff.....",
"....ggaagbaag.....",
"....hhhaahhaa.....",
"........a...a.....",
"..................",
"..................",
"..................",
"..................",
".................."};


ItemDialogClass::ItemDialogClass( GLWidget *pointer , QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl ), image3( (const char **) image3_data )
{
    GlWidgetClass = pointer;
    UndoClass = new Undo ( GlWidgetClass , GlWidgetClass->GlWindowClass );
    ka = false;
    Add_Flag = true;
    QImage img;
    img.loadFromData( image0_data, sizeof( image0_data ), "PNG" );
    image0 = img;
    img.loadFromData( image1_data, sizeof( image1_data ), "PNG" );
    image1 = img;
    img.loadFromData( image2_data, sizeof( image2_data ), "PNG" );
    image2 = img;
    if ( !name )
	setName( "ItemDialog" );
    setMinimumSize( QSize( 470, 250 ) );
    setMaximumSize( QSize( 470, 250 ) );
    //move ( QApplication::desktop()->width() - 470, (QApplication::desktop()->height() - 250) ) ;

	Xpos_decrease = new QPushButton( this, "Xpos_decrease" );
	Xpos_decrease->setGeometry( QRect( 78, 139, 16, 16 ) );
	Xpos_decrease->setPixmap( image1 );
	Xpos_decrease->setAutoRepeat( TRUE );
	connect ( Xpos_decrease, SIGNAL( clicked() ), this, SLOT(Xpos_dec() ) );
	
	Xpos_decrease_fast = new QPushButton( this, "Xpos_decrease_fast" );
	Xpos_decrease_fast->setGeometry( QRect( 60, 139, 16, 16 ) );
	Xpos_decrease_fast->setPixmap( image3 );
	connect ( Xpos_decrease_fast, SIGNAL( clicked() ), this, SLOT(Xpos_dec_fast() ) );
	Xpos_decrease_fast->setAutoRepeat( TRUE );
	
	Xpos_increase = new QPushButton( this, "Xpos_increase" );
	Xpos_increase->setGeometry( QRect( 96, 139, 16, 16 ) );
	Xpos_increase->setPixmap( image0 );
	connect ( Xpos_increase, SIGNAL( clicked() ), this, SLOT(Xpos_inc() ) );
	Xpos_increase->setAutoRepeat( TRUE );
	
	Xpos_increase_fast = new QPushButton( this, "Xpos_increase_fast" );
	Xpos_increase_fast->setGeometry( QRect( 115, 139, 16, 16 ) );
	Xpos_increase_fast->setPixmap( image2 );
	Xpos_increase_fast->setAutoRepeat( TRUE );
	connect ( Xpos_increase_fast , SIGNAL( clicked() ), this, SLOT( Xpos_inc_fast() ) ) ;
	
	Ypos_decrease = new QPushButton( this, "Ypos_decrease" );
	Ypos_decrease->setGeometry( QRect( 158, 139, 16, 16 ) );
	Ypos_decrease->setPixmap( image1 );
	connect ( Ypos_decrease , SIGNAL( clicked() ), this, SLOT( Ypos_dec() ) ) ;
	Ypos_decrease->setAutoRepeat( TRUE );
	
    	Ypos_decrease_fast = new QPushButton( this, "Ypos_decrease_fast" );
	Ypos_decrease_fast->setGeometry( QRect( 140, 139, 16, 16 ) );
	Ypos_decrease_fast->setPixmap( image3 );
	Ypos_decrease_fast->setAutoRepeat( TRUE );
	connect ( Ypos_decrease_fast , SIGNAL( clicked() ), this, SLOT( Ypos_dec_fast() ) ) ;
	
	Ypos_increase = new QPushButton( this, "Ypos_increase" );
	Ypos_increase->setGeometry( QRect( 176, 139, 16, 16 ) );
	Ypos_increase->setPixmap( image0 );
	Ypos_increase->setAutoRepeat( TRUE );
	connect ( Ypos_increase , SIGNAL( clicked() ), this, SLOT( Ypos_inc() ) ) ;
		
	Ypos_increase_fast = new QPushButton( this, "Ypos_increase_fast" );
	Ypos_increase_fast->setGeometry( QRect( 195, 139, 16, 16 ) );
	Ypos_increase_fast->setPixmap( image2 );
	Ypos_increase_fast->setAutoRepeat( TRUE );
    	connect ( Ypos_increase_fast , SIGNAL( clicked() ), this, SLOT( Ypos_inc_fast() ) ) ;
	
	Zpos_increase_fast = new QPushButton( this, "Zpos_increase_fast" );
	Zpos_increase_fast->setGeometry( QRect( 275, 139, 16, 16 ) );
	Zpos_increase_fast->setPixmap( image2 );
	Zpos_increase_fast->setAutoRepeat( TRUE );
	connect ( Zpos_increase_fast , SIGNAL( clicked() ), this, SLOT( Zpos_inc_fast() ) ) ;
	
	Zpos_increase = new QPushButton( this, "Zpos_increase" );
	Zpos_increase->setGeometry( QRect( 256, 139, 16, 16 ) );
	Zpos_increase->setPixmap( image0 );
    	Zpos_increase->setAutoRepeat( TRUE );
	connect ( Zpos_increase , SIGNAL( clicked() ), this, SLOT( Zpos_inc() ) ) ;
    
	Zpos_decrease = new QPushButton( this, "Zpos_decrease" );
	Zpos_decrease->setGeometry( QRect( 238, 139, 16, 16 ) );
	Zpos_decrease->setPixmap( image1 );
	Zpos_decrease->setAutoRepeat( TRUE );
	connect ( Zpos_decrease , SIGNAL( clicked() ), this, SLOT( Zpos_dec() ) ) ;
	
	Zpos_decrease_fast = new QPushButton( this, "Zpos_decrease_fast" );
	Zpos_decrease_fast->setGeometry( QRect( 220, 139, 16, 16 ) );
	Zpos_decrease_fast->setPixmap( image3 );
    	Zpos_decrease_fast->setAutoRepeat( TRUE );
	connect ( Zpos_decrease_fast , SIGNAL( clicked() ), this, SLOT( Zpos_dec_fast() ) ) ;
	
	Xrot_decrease_fast = new QPushButton( this, "Xrot_decrease_fast" );
	Xrot_decrease_fast->setGeometry( QRect( 60, 86, 16, 16 ) );
	Xrot_decrease_fast->setPixmap( image3 );
	Xrot_decrease_fast->setAutoRepeat( TRUE );
	connect ( Xrot_decrease_fast , SIGNAL( clicked() ), this, SLOT( Xrot_dec_fast() ) ) ;
	
	Xrot_decrease = new QPushButton( this, "Xrot_decrease" );
	Xrot_decrease->setGeometry( QRect( 78, 86, 16, 16 ) );
	Xrot_decrease->setPixmap( image1 );
	Xrot_decrease->setAutoRepeat( TRUE );
	connect ( Xrot_decrease , SIGNAL( clicked() ), this, SLOT( Xrot_dec() ) ) ;
	
	Xrot_increase = new QPushButton( this, "Xrot_increase" );
	Xrot_increase->setGeometry( QRect( 96, 86, 16, 16 ) );
	Xrot_increase->setPixmap( image0 );
	Xrot_increase->setAutoRepeat( TRUE );
	connect ( Xrot_increase , SIGNAL( clicked() ), this, SLOT( Xrot_inc() ) ) ;
    
	Xrot_increase_fast = new QPushButton( this, "Xrot_increase_fast" );
	Xrot_increase_fast->setGeometry( QRect( 115, 86, 16, 16 ) );
	Xrot_increase_fast->setPixmap( image2 );
	Xrot_increase_fast->setAutoRepeat( TRUE );
	connect ( Xrot_increase_fast , SIGNAL( clicked() ), this, SLOT( Xrot_inc_fast() ) ) ;
	
	Yrot_decrease = new QPushButton( this, "Yrot_decrease" );
	Yrot_decrease->setGeometry( QRect( 158, 86, 16, 16 ) );
	Yrot_decrease->setPixmap( image1 );
	Yrot_decrease->setAutoRepeat( TRUE );
	connect ( Yrot_decrease , SIGNAL( clicked() ), this, SLOT( Yrot_dec() ) ) ;
	
	Yrot_increase_fast = new QPushButton( this, "Yrot_increase_fast" );
	Yrot_increase_fast->setGeometry( QRect( 195, 86, 16, 16 ) );
	Yrot_increase_fast->setPixmap( image2 );
	Yrot_increase_fast->setAutoRepeat( TRUE );
	connect ( Yrot_increase_fast , SIGNAL( clicked() ), this, SLOT( Yrot_inc_fast() ) ) ;
	
	Yrot_increase = new QPushButton( this, "Yrot_increase" );
	Yrot_increase->setGeometry( QRect( 176, 86, 16, 16 ) );
	Yrot_increase->setPixmap( image0 );
    	Yrot_increase->setAutoRepeat( TRUE );
	connect ( Yrot_increase , SIGNAL( clicked() ), this, SLOT( Yrot_inc() ) ) ;
    	
	Yrot_decrease_fast = new QPushButton( this, "Yrot_decrease_fast" );
    	Yrot_decrease_fast->setGeometry( QRect( 140, 86, 16, 16 ) );
    	Yrot_decrease_fast->setPixmap( image3 );
    	Yrot_decrease_fast->setAutoRepeat( TRUE );
	connect ( Yrot_decrease_fast , SIGNAL( clicked() ), this, SLOT( Yrot_dec_fast() ) ) ;
	
	Zrot_decrease = new QPushButton( this, "Zrot_decrease" );
	Zrot_decrease->setGeometry( QRect( 238, 86, 16, 16 ) );
	Zrot_decrease->setPixmap( image1 );
	Zrot_decrease->setAutoRepeat( TRUE );
	connect ( Zrot_decrease , SIGNAL( clicked() ), this, SLOT( Zrot_dec() ) ) ;
	
	Zrot_decrease_fast = new QPushButton( this, "Zrot_decrease_fast" );
    	Zrot_decrease_fast->setGeometry( QRect( 220, 86, 16, 16 ) );
    	Zrot_decrease_fast->setPixmap( image3 );
	Zrot_decrease_fast->setAutoRepeat( TRUE );
	connect ( Zrot_decrease_fast , SIGNAL( clicked() ), this, SLOT( Zrot_dec_fast() ) ) ;
	
	Zrot_increase_fast = new QPushButton( this, "Zrot_increase_fast" );
    	Zrot_increase_fast->setGeometry( QRect( 275, 86, 16, 16 ) );
    	Zrot_increase_fast->setPixmap( image2 );
	Zrot_increase_fast->setAutoRepeat( TRUE );
	connect ( Zrot_increase_fast , SIGNAL( clicked() ), this, SLOT( Zrot_inc_fast() ) ) ;
	
	Zrot_increase = new QPushButton( this, "Zrot_increase" );
	Zrot_increase->setGeometry( QRect( 256, 86, 16, 16 ) );
	Zrot_increase->setPixmap( image0 );
	Zrot_increase->setAutoRepeat( TRUE );
	connect ( Zrot_increase , SIGNAL( clicked() ), this, SLOT( Zrot_inc() ) ) ;
	
    Zpos_label = new QLabel( this, "Zpos_label" );
    Zpos_label->setGeometry( QRect( 228, 114, 52, 21 ) );
      
    rotation = new QLabel( this, "rotation" );
    rotation->setGeometry( QRect( 3, 56, 60, 21 ) );
   
     Xpos_label = new QLabel( this, "Xpos_label" );
    Xpos_label->setGeometry( QRect( 71, 114, 52, 21 ) );

    Yrot_label = new QLabel( this, "Yrot_label" );
    Yrot_label->setGeometry( QRect( 149, 57, 52, 21 ) );
   
    position = new QLabel( this, "position" );
    position->setGeometry( QRect( 3, 113, 60, 21 ) );
   
    
    Xrot = new QLabel( this, "Xrot" );
    Xrot->setGeometry( QRect( 79, 56, 52, 21 ) );

    Ypos_label = new QLabel( this, "Ypos_label" );
    Ypos_label->setGeometry( QRect( 149, 114, 52, 21 ) );

    Xrot_label = new QLabel( this, "Xrot_label" );
    Xrot_label->setGeometry( QRect( 71, 57, 52, 21 ) );

    Yrot = new QLabel( this, "Yrot" );
    Yrot->setGeometry( QRect( 156, 56, 52, 21 ) );

    Zrot_label = new QLabel( this, "Zrot_label" );
    Zrot_label->setGeometry( QRect( 228, 57, 52, 21 ) );

    Zrot = new QLabel( this, "Zrot" );
    Zrot->setGeometry( QRect( 232, 56, 52, 21 ) );

    model_string = new QLineEdit( this, "model_string" );
    model_string->setGeometry( QRect( 9, 220, 450, 22 ) );
    model_string->setReadOnly( TRUE );

    id_number = new QLabel( this, "id_number" );
    id_number->setGeometry( QRect( 4, 35, 20, 20 ) );

    keep_aspect = new QCheckBox( this, "keep_aspect" );
    keep_aspect->setEnabled( FALSE );
    keep_aspect->setGeometry( QRect( 18, 192, 100, 20 ) );
    connect( keep_aspect, SIGNAL(toggled(bool)), this, SLOT(setAspectState(bool)) );
    
    Scale = new QCheckBox( this, "Scale" );
    Scale->setEnabled( TRUE );
    Scale->setGeometry( QRect( 4, 166, 60, 20 ) );
    connect( Scale, SIGNAL(toggled(bool)), this, SLOT(setSliderState(bool)) );
    
    scaleX = new QSlider( 1 , 100 , 10 , 100 , Qt::Horizontal , this, "scaleX" );
    scaleX->setEnabled( FALSE );
    scaleX->setGeometry( QRect( 67, 162, 60, 30 ) );
    scaleX->setOrientation( QSlider::Horizontal );
       
    scaleY = new QSlider( 1 , 100 , 10 , 100 , Qt::Horizontal , this, "scaleY" );
    scaleY->setEnabled( FALSE );
    scaleY->setGeometry( QRect( 146, 162, 60, 30 ) );
    scaleY->setOrientation( QSlider::Horizontal );
        
    scaleZ = new QSlider( 1 , 100 , 10 , 100 , Qt::Horizontal , this, "scaleZ" );
    scaleZ->setEnabled( FALSE );
    scaleZ->setGeometry( QRect( 226, 162, 60, 30 ) );
    scaleZ->setOrientation( QSlider::Horizontal );
        
    connect ( scaleX , SIGNAL(valueChanged( int )), this , SLOT( ChangeScaleX ( int )) );
    connect ( scaleY , SIGNAL(valueChanged( int )), this , SLOT( ChangeScaleY ( int )) );
    connect ( scaleZ , SIGNAL(valueChanged( int )), this , SLOT( ChangeScaleZ ( int )) );
        
    texture_listbox = new QListBox( this, "texture_listbox" );
    texture_listbox->setGeometry( QRect( 309, 72, 150, 140 ) );

    id_label = new QLabel( this, "id_label" );
    id_label->setGeometry( QRect( 29, 35, 30, 20 ) );

    textLabel2 = new QLabel( this, "textLabel2" );
    textLabel2->setGeometry( QRect( 342, 49, 90, 21 ) );

    filename_edit = new QLineEdit( this, "filename_edit" );
    filename_edit->setEnabled( TRUE );
    filename_edit->setGeometry( QRect( 38, 6, 420, 22 ) );
    filename_edit->setReadOnly( TRUE );

    textLabel1 = new QLabel( this, "textLabel1" );
    textLabel1->setGeometry( QRect( 4, 6, 24, 21 ) );

    model_label = new QLabel( this, "model_label" );
    //QFont model_label_font(  model_label->font() );
    //model_label_font.setPointSize( 9 );
    //model_label->setFont( model_label_font );
    model_label->setGeometry( QRect( 68,35,390,16 ) );
    languageChange();
    resize( QSize(470, 250).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
}

ItemDialogClass::~ItemDialogClass()
{
	delete UndoClass;
}

void ItemDialogClass::ChangeScaleX ( int x )
{
	scaleX->setValue ( x );
	if (ka)
	{
		scaleY->setValue ( x );
		scaleZ->setValue ( x );
	}
	GlWidgetClass->Model [ ChoosedModel ].sx = x / 111.0f;
	UpdateModelString ();
	GlWidgetClass->updateGL();
}

void ItemDialogClass::ChangeScaleY ( int y )
{
	scaleY->setValue ( y );
	if (ka)
	{
		scaleX->setValue ( y );
		scaleZ->setValue ( y );
	}
	GlWidgetClass->Model [ ChoosedModel ].sy = y / 111.0f;
	UpdateModelString ();
	GlWidgetClass->updateGL();
}

void ItemDialogClass::ChangeScaleZ ( int z )
{
	scaleZ->setValue ( z );
	if (ka)
	{
		scaleX->setValue ( z );
		scaleY->setValue ( z );
	}
	GlWidgetClass->Model [ ChoosedModel ].sz = z / 111.0f;
	UpdateModelString ();
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Xpos_inc_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].x += 5.0f;
	Xpos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].x ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveX , 5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Xpos_dec_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].x -= 5.0f;
	Xpos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].x ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveX , -5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Xpos_dec()
{
	GlWidgetClass->Model [ ChoosedModel ].x -= 0.1f;
	Xpos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].x ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveX , -0.1f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Xpos_inc()
{
	GlWidgetClass->Model [ ChoosedModel ].x += 0.1f; 
	Xpos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].x ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveX , 0.1f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Ypos_inc_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].y += 5.0f;
	Ypos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].y ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveY , 5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Ypos_dec_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].y -= 5.0f;
	Ypos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].y ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveY , -5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Ypos_dec()
{
	GlWidgetClass->Model [ ChoosedModel ].y -= 0.1f;
	Ypos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].y ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveY , -0.1f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Ypos_inc()
{
	GlWidgetClass->Model [ ChoosedModel ].y += 0.1f; 
	Ypos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].y ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveY , 0.1f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Zpos_inc_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].z += 5.0f;
	Zpos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].z ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveZ , 5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Zpos_dec_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].z -= 5.0f;
	Zpos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].z ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveZ , -5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Zpos_dec()
{
	GlWidgetClass->Model [ ChoosedModel ].z -= 0.1f;
	Zpos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].z ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveZ , -0.1f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Zpos_inc()
{
	GlWidgetClass->Model [ ChoosedModel ].z += 0.1f; 
	Zpos_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].z ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( moveZ , 0.1f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Xrot_inc_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].xrot += 5.0f;
	if ( GlWidgetClass->Model [ ChoosedModel ].xrot  >= 360) GlWidgetClass->Model [ ChoosedModel ].xrot -= 360.0f;
	Xrot_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].xrot ) );
	UpdateModelString();
	if ( Add_Flag ) UndoClass->AddAction ( rotateX , 5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Xrot_dec_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].xrot -= 5.0f;
	if ( GlWidgetClass->Model [ ChoosedModel ].xrot  < 0) GlWidgetClass->Model [ ChoosedModel ].xrot += 360.0f;
	Xrot_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].xrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateX , -5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Xrot_dec()
{
	GlWidgetClass->Model [ ChoosedModel ].xrot -= 0.5f;
	if ( GlWidgetClass->Model [ ChoosedModel ].xrot  < 0)
	GlWidgetClass->Model [ ChoosedModel ].xrot += 360.0f;
	Xrot_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].xrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateX , -0.5f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Xrot_inc()
{
	GlWidgetClass->Model [ ChoosedModel ].xrot += 0.5f; 
	if ( GlWidgetClass->Model [ ChoosedModel ].xrot >= 360) GlWidgetClass->Model [ ChoosedModel ].xrot -= 360.0f;
	Xrot_label->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].xrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateX , 0.5f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Yrot_inc_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].yrot += 5.0f;
	if ( GlWidgetClass->Model [ ChoosedModel ].yrot  >= 360) GlWidgetClass->Model [ ChoosedModel ].yrot -= 360.0f;
	Yrot->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].yrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateY , 5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Yrot_dec_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].yrot -= 5.0f;
	if ( GlWidgetClass->Model [ ChoosedModel ].yrot  < 0) GlWidgetClass->Model [ ChoosedModel ].yrot += 360.0f;
	Yrot->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].yrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateY , -5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Yrot_dec()
{
	GlWidgetClass->Model [ ChoosedModel ].yrot -= 0.5f;
	if ( GlWidgetClass->Model [ ChoosedModel ].yrot  < 0) GlWidgetClass->Model [ ChoosedModel ].yrot += 360.0f;
	Yrot->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].yrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateY , -0.5f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Yrot_inc()
{
	GlWidgetClass->Model [ ChoosedModel ].yrot += 0.5f;
	if ( GlWidgetClass->Model [ ChoosedModel ].yrot  >= 360) GlWidgetClass->Model [ ChoosedModel ].yrot -= 360.0f;
	Yrot->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].yrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateY , 0.5f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Zrot_inc_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].zrot += 5.0f;
	if ( GlWidgetClass->Model [ ChoosedModel ].zrot  >= 360) GlWidgetClass->Model [ ChoosedModel ].zrot -= 360.0f;
	Zrot->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].zrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateZ , 5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Zrot_dec_fast()
{
	GlWidgetClass->Model [ ChoosedModel ].zrot -= 5.0f;
	if ( GlWidgetClass->Model [ ChoosedModel ].zrot  < 0) GlWidgetClass->Model [ ChoosedModel ].zrot += 360.0f;
	Zrot->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].zrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateZ , -5.0f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Zrot_dec()
{
	GlWidgetClass->Model [ ChoosedModel ].zrot -= 0.5f;
	if ( GlWidgetClass->Model [ ChoosedModel ].zrot  < 0) GlWidgetClass->Model [ ChoosedModel ].zrot += 360.0f;
	Zrot->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].zrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateZ , -0.5f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::Zrot_inc()
{
	GlWidgetClass->Model [ ChoosedModel ].zrot += 0.5f;
	if ( GlWidgetClass->Model [ ChoosedModel ].zrot  >= 360) GlWidgetClass->Model [ ChoosedModel ].zrot -= 360.0f;
	Zrot->setText ( QString("%1").arg ( GlWidgetClass->Model [ ChoosedModel ].zrot ) );
	UpdateModelString ();
	if ( Add_Flag ) UndoClass->AddAction ( rotateZ , 0.5f , ChoosedModel );
	Add_Flag = true;
	GlWidgetClass->updateGL();
}

void ItemDialogClass::UpdateModelString ()
{
	//Let's remove the path from the model filename
	ModelName = model_label->text();
	ModelName = ModelName.mid ( ModelName.findRev( "/", -1 )+1 );
	if (ModelName == NULL) ModelName = GlWidgetClass->GlWindowClass->Copy_of_filename.c_str();
	QString dummystring = 		id_label->text() + "," +
							ModelName + "," +
							Xpos_label->text() + "," +
							Ypos_label->text() + "," +
							Zpos_label->text() + "," +
							Xrot_label->text() + "," +
							Yrot->text() + "," +
							Zrot->text() ;
	if ( Scale->isChecked() )
	{
		dummystring = dummystring + "," +
		QString::number (scaleX->value() / 111.0f ) + "," +
		QString::number (scaleY->value() / 111.0f ) + "," + 
		QString::number (scaleZ->value() / 111.0f ) ;
	}
	model_string->setText ( dummystring );
}

void ItemDialogClass::setSliderState(bool b)
{
	if ( b )
	{
		GlWidgetClass->Model [ ChoosedModel ].checked = TRUE;
		scaleX->setEnabled( TRUE );
		scaleY->setEnabled( TRUE );
		scaleZ->setEnabled( TRUE );
		UpdateModelString();
		keep_aspect->setEnabled( TRUE );
	}
	
	 else
	 {
	 	GlWidgetClass->Model [ ChoosedModel ].checked = FALSE;
	 	scaleX->setEnabled( FALSE );
		scaleY->setEnabled( FALSE );
		scaleZ->setEnabled( FALSE );
		UpdateModelString();
		keep_aspect->setEnabled( FALSE );
	 }
}
 
void ItemDialogClass::setAspectState(bool b)
{
	if ( b ) ka = TRUE;
	else ka = FALSE;
}

void ItemDialogClass::languageChange()
{
    setCaption( tr( "Item Dialog Editor" ) );
    Zrot_increase->setText( QString::null );
    Xpos_decrease->setText( QString::null );
    Zpos_increase_fast->setText( QString::null );
    Xrot_decrease_fast->setText( QString::null );
    Yrot_decrease->setText( QString::null );
    Zpos_label->setText( QString::null );
    Yrot_increase_fast->setText( QString::null );
    Xpos_increase->setText( QString::null );
    Ypos_decrease->setText( QString::null );
    Yrot_increase->setText( QString::null );
    Xpos_decrease_fast->setText( QString::null );
    rotation->setText( tr( "Rotation:" ) );
    Xrot_decrease->setText( QString::null );
    Zpos_increase->setText( QString::null );
    Ypos_decrease_fast->setText( QString::null );
    Xpos_label->setText( QString::null );
    Xrot_increase_fast->setText( QString::null );
    Xpos_increase_fast->setText( QString::null );
    Yrot_label->setText( QString::null );
    Zrot_decrease_fast->setText( QString::null );
    position->setText( tr( "Position:" ) );
    Xrot_increase->setText( QString::null );
    Xrot->setText( QString::null );
    Ypos_label->setText( QString::null );
    Xrot_label->setText( QString::null );
    Yrot->setText( QString::null );
    Ypos_increase->setText( QString::null );
    Yrot_decrease_fast->setText( QString::null );
    Zrot_decrease->setText( QString::null );
    Zrot_increase_fast->setText( QString::null );
    Zpos_decrease->setText( QString::null );
    Ypos_increase_fast->setText( QString::null );
    Zrot_label->setText( QString::null );
    Zrot->setText( QString::null );
    Zpos_decrease_fast->setText( QString::null );
    id_number->setText( tr( "Id:" ) );
    keep_aspect->setText( tr( "keep aspect" ) );
    Scale->setText( tr( "Scale:" ) );
    id_label->setText( QString::null );
    textLabel2->setText( tr( "Textures List:" ) );
    textLabel1->setText( tr( "File:" ) );
    model_label->setText( QString::null );
}

