/***********************************************************************
//
//	TextureLoader class
//	By Colossus (Giuseppe Torelli) on 07 August 2004:
//
//	This class loads a TGA / JPG / BMP file
//	and sets the OpenGL appropriate parameters
//	
//	Credit for the image loaders go to the respective authors.
//	I just assembled them all in one class for convenience
//	This texture loader class changes the case of the texture file names when not found
*************************************************************************
 */
 
#ifndef _TEXTURELOADER_H
#define _TEXTURELOADER_H

#define XMD_H		// This to avoid the previous declaration error with qglobal.h and jmorecfg.h
#define TGA_RGB	2	// This tells us it's a normal RGB (really BGR) file
#define TGA_A		3	// This tells us it's a ALPHA file
#define TGA_RLE	10	// This tells us that the targa is Run-Length Encoded (RLE)
#include <stdio.h>
#include <map>
#include <string>
#include <ctype.h>
#include <GL/glu.h>

extern "C"
{
	#include <jpeglib.h>
	#include <jerror.h>
	#include <setjmp.h>
}

using namespace std;

typedef unsigned char  byte;
typedef unsigned short WORD;
typedef unsigned int   UINT;

class TextureLoader
{
public:
	
	TextureLoader();
	~TextureLoader();
	
	typedef struct
	{
		GLenum texFormat;			// GL_RGB, GL_RGBA ou GL_LUMINANCE
		int width;
		int height;
		unsigned char bitCount;
		unsigned char *imageData;
	} glTexture;
	
	struct libjpeg_my_error_mgr
	{
		struct jpeg_error_mgr pub;  // "public" fields
		jmp_buf setjmp_buffer;      // for return to caller
	};

	typedef struct libjpeg_my_error_mgr;

	glTexture texture;
	map <string , GLuint> TextureMap;
	char *Copy_of_strFileName;
	int LoadBMP ( string Path , string FileName, glTexture *texture );
	int LoadTGA ( string Path , string FileName, glTexture *texture );
	int LoadJPG ( string Path , string FileName, glTexture *texture );
	int CreateTexture ( string Path , string strFileName , unsigned int textureID );
	void SetOpenGLTexParam ( glTexture *texture );
	string ChangeCase ( string s2 );
	string toUpper ( string s3 );
	string toLower ( string s4 );
	string RemoveMeshFileNameFromPath ( string strFileName );
};
#endif
