/***************************************************************************
 *   Copyright (C) 2004 by Colossus (Giuseppe Torelli)                     *
 *   gt67@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "undo.h"

Undo::Undo ( GLWidget *pointer , GlWindow* dummy )
{
	ArrayIndex = 0;
	GlWidgetClass = pointer;
	GlWindowClass = dummy;
}

Undo::~Undo()
{
}

void Undo::AddAction ( type action, float amount , uint id )
{
	if ( GlWindowClass->undoAction->isEnabled() == false ) GlWindowClass->undoAction->setEnabled ( true );
	if ( (uint) ArrayIndex < UndoArray.size() ) UndoArray [ ArrayIndex ] = UndoStruct (action, amount , id );
		else UndoArray.push_back ( UndoStruct (action, amount , id ) );
	ArrayIndex++;
}

void Undo::AddAction ( type action, string dummyname , uint id )
{
	if ( GlWindowClass->undoAction->isEnabled() == false ) GlWindowClass->undoAction->setEnabled ( true );
	if ( (uint) ArrayIndex < UndoArray.size() ) UndoArray [ ArrayIndex ] = UndoStruct (action, dummyname , id );
		else UndoArray.push_back ( UndoStruct (action, dummyname , id ) );
	ArrayIndex++;
}

void Undo::AddAction ( type action, vector <uint> id_To_Delete , string modelname )
{
	if ( GlWindowClass->undoAction->isEnabled() == false ) GlWindowClass->undoAction->setEnabled ( true );
	if ( (uint) ArrayIndex < UndoArray.size() ) UndoArray [ ArrayIndex ] = UndoStruct ( action, id_To_Delete , modelname );
		else UndoArray.push_back ( UndoStruct (action, id_To_Delete , modelname ) );
	ArrayIndex++;
}

void Undo::RedoAction()
{
	if ( GlWindowClass->undoAction->isEnabled() == false) GlWindowClass->undoAction->setEnabled ( true );
	switch ( UndoArray [ ArrayIndex ].action )
	{
		case deleteScene:
			GlWindowClass->SceneFileName = UndoArray [ ArrayIndex ].modelname.c_str();
			GlWindowClass->Insert_in_Dummy_Flag = false;
			GlWindowClass->ItemDialog->Add_Flag = false;
			GlWindowClass->Open_Scene();
			GlWidgetClass->updateGL();
			GlWindowClass->ItemDialog->Add_Flag = true;
		break;
		case deleteModel:
			GlWindowClass->ItemDialog->Add_Flag = false;
			GlWidgetClass->DeleteModel ( UndoArray [ ArrayIndex ].id );
			GlWidgetClass->updateGL();
			GlWindowClass->ItemDialog->Add_Flag = true;
		break;
		case unLoadModel:
			GlWindowClass->LoadModelFile ( UndoArray [ ArrayIndex ].modelname.c_str() );
			GlWidgetClass->updateGL();
		break;
		case rotateX:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xrot_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xrot_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xrot_dec();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xrot_inc();
			}
		break;
		case rotateY:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Yrot_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Yrot_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Yrot_dec();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Yrot_inc();
			}
		break;
		case rotateZ:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zrot_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zrot_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zrot_dec();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zrot_inc();
			}
		break;
		case moveX:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xpos_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xpos_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xpos_dec();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xpos_inc();
			}
		break;
		case moveY:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Ypos_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Ypos_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Ypos_dec();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Ypos_inc();
			}
		break;
		case moveZ:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zpos_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zpos_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zpos_dec();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zpos_inc();
			}
		break;
	}
	ArrayIndex++;
	if ( (uint) ArrayIndex == UndoArray.size() )
	{
		GlWindowClass->redoAction->setEnabled ( false );
		return;
	}
}

void Undo::UndoAction()
{
	ArrayIndex--;
	switch ( UndoArray [ ArrayIndex ].action )
	{
		case deleteScene:
			GlWindowClass->ItemDialog->Add_Flag = false;
			//vector <uint>::iterator begin = UndoArray [ArrayIndex].id_To_Delete->begin();
			//vector <uint>::iterator end = UndoArray [ArrayIndex].id_To_Delete->end();
			//for ( vector<uint>::iterator it = begin; it != end; ++it)
			for ( uint f = 0; f < UndoArray [ArrayIndex].id_To_Delete.size(); f++ )
			{
				//GlWidgetClass->DeleteModel ( *it );
				GlWidgetClass->DeleteModel ( UndoArray [ArrayIndex].id_To_Delete[ f ] );
				printf ("%d\n",UndoArray [ArrayIndex].id_To_Delete[ f ]);
			}
			GlWindowClass->ItemDialog->Add_Flag = true;
		break;
		case deleteModel:
			GlWindowClass->LoadModelFile ( UndoArray [ArrayIndex].modelname.c_str() );
			GlWidgetClass->updateGL();
			GlWindowClass->statusBar()->message ("");
		break;
		case unLoadModel:
			GlWindowClass->ItemDialog->Add_Flag = false;
			GlWidgetClass->DeleteModel ( UndoArray [ArrayIndex].id );
			GlWidgetClass->updateGL();
			GlWindowClass->ItemDialog->Add_Flag = true;
		break;
		case rotateX:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xrot_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xrot_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xrot_inc();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xrot_dec();
			}
		break;
		case rotateY:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Yrot_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Yrot_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Yrot_inc();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Yrot_dec();
			}
		break;
		case rotateZ:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zrot_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zrot_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zrot_inc();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.5f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zrot_dec();
			}
		break;
		case moveX:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xpos_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xpos_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xpos_inc();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Xpos_dec();
			}
		break;
		case moveY:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Ypos_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Ypos_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Ypos_inc();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Ypos_dec();
			}
		break;
		case moveZ:
			GlWindowClass->ItemDialog->ChoosedModel = UndoArray [ ArrayIndex ].id;
			if (UndoArray [ ArrayIndex ].amount == -5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zpos_inc_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == 5.0f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zpos_dec_fast();
			}
			if (UndoArray [ ArrayIndex ].amount == -0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zpos_inc();
			}
			if (UndoArray [ ArrayIndex ].amount == 0.1f)
			{
				GlWindowClass->ItemDialog->Add_Flag = false;
				GlWindowClass->ItemDialog->Zpos_dec();
			}
		break;
	}
	if ( ArrayIndex == 0 ) GlWindowClass->undoAction->setEnabled ( false);
	if ( GlWindowClass->redoAction->isEnabled() == false ) GlWindowClass->redoAction->setEnabled ( true );
}
