// Source file for evolvotron
// Copyright (C) 2002,2003 Tim Day
/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*! \file
  \brief Implementation of class DialogMutatableImageDisplay.
*/

#include "dialog_mutatable_image_display.h"

DialogMutatableImageDisplay::DialogMutatableImageDisplay(QWidget* parent)
  :QDialog(parent,0,TRUE)
{
  setCaption("Image Properties");
  setMinimumSize(256,128);

  _vbox=new QVBox(this);

  _message=new QLabel(QString(""),_vbox);

  _ok=new QPushButton("OK",_vbox);

  //! \todo: These button settings don't seem to do anything.  Find out what's up.
  _ok->setAutoDefault(true);
  _ok->setDefault(true);

  connect(
	  _ok,SIGNAL(clicked()),
	  this,SLOT(hide())
	  );
}

void DialogMutatableImageDisplay::resizeEvent(QResizeEvent*)
{
  _vbox->resize(size());
}

void DialogMutatableImageDisplay::set_message(const std::string& m)
{
  _message->setText(QString(m.c_str()));
  _message->adjustSize();

  adjustSize();
  updateGeometry();
}

