/*
 *  ShowFontFile.cpp
 *  Transform Examples
 *
 *  Created by smackay on Tue Jun 02 2004.
 *  Copyright (c) 2004 Flagstone Software Ltd. All rights reserved.
 *
 *  This code is distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESS OR IMPLIED, AND Flagstone HEREBY DISCLAIMS ALL SUCH WARRANTIES, INCLUDING
 *  WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 *  PURPOSE, AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 */

#ifndef __ShowFontFile_h__
#define __ShowFontFile_h__ 1

/*
 * This example shows how the FSTextConstructor class can be used to generate a 
 * font definition using a font definition from a file. The file may be either a
 * Flash file containing an existing font definition or a TrueType or OpenType
 * font file.
 * 
 * The example loads the font definition and generates a movie displaying the 
 * first 2048 characters as a block of text containing 32 rows of 64 characters 
 * - enough to display all the characters displayed in Latin and Cyrillic fonts 
 * along with the majority of special characters and symbols.
 *
 * To run this example, type the following on a command line:
 *
 *     examples --example ShowFontFile --file font-file [--resultDir path]
 *
 * where
 * 
 *     font-file is the path to the file containing the font definition.
 *
 *     resultDir is the directory where the Flash files generated by the example is
 *     written to.  The file will be written to the directory where the example
 *     was run if omitted.
 *
 * The name of the Flash file generated is the same as the font file. If an 
 * OpenType or TrueType file is specified the file extension is replaced with 
 * a '.swf' suffix.
 */
class ShowFontFile
{
public:
	ShowFontFile(map< string, string>& options)
	{
cout<<"hello world";
		string fontFile = stringOption(options, "file");
cout<<"bişey "+fontFile<<endl;
		FSTextConstructor* textGenerator = TextConstructor();
		FSMovie movie;

		int status = TransformUtil::OK;

		if ((status = textGenerator->setFontFromFile(fontFile.c_str())) != TransformUtil::OK)
		{
			switch (status)
			{
				case TransformUtil::FileNotFound:
					cout << "Could not find font file" << endl; break;
				case TransformUtil::ReadError:
					cout << "Could not read font file" << endl; break;
				case TransformUtil::FormatError:
					cout << "Could not read font file" << endl; break;
			}
		}

		if (status == TransformUtil::OK)
		{
			int layer = 0;                // Starting layer for objects in the display list.
			int fontSize = 280;           // Font size in twips 1 point = 20 twips
			int lineSpacing = fontSize;   // The font size defines a suitable line spacing
	        
			/*
			* The movie will be sized to match the block of text generated.
			* The margins are defined so the text is displayed without touching
			* the edge of the Flash Player screen.
			*/
			int leftMargin = fontSize;
			int rightMargin = fontSize;
			int topMargin = fontSize;
			int bottomMargin = fontSize;
	        
			FSColor black = FSColorTable::black();
	        
			textGenerator->setIdentifier(movie.newIdentifier());
			textGenerator->setSize(fontSize);
			textGenerator->setColor(&black);

			/* 
			* The block of text is generated before the font definition. This ensures
			* that only the characters displayed will be included in the font. Unused
			* characters will be omitted, greatly reducing the size of the Flash file
			* generated. Once the FSDefineFont2 object has been generated any text 
			* objects created with characters not previously used, will not be 
			* displayed correctly - a new font definition would need to be generated
			* to include the new characters.
			* 
			* The FSDefineText2 object contains an array of FSText objects, each
			* specifying an offset relative to the origin of the entire block. These
			* can easily be changed if a line needs to be indented or the line spacing
			* adjusted. 
			*/
			//FSDefineText2* text = textGenerator->defineWideTextBlock(movie.newIdentifier(), 
			//	(const wchar_t **)lines, 32, lineSpacing);
FSDefineText2* text = textGenerator->defineText(movie.newIdentifier(),"hello");

			FSDefineFont2* font = textGenerator->defineFont();

			/* 
			* Define the size of the Flash Player screen using the bounding 
			* rectangle defined for the block of text plus a suitable margin so 
			* the text does not touch the edge of the screen.
			*/
			int screenWidth = text->getBounds().getWidth() + leftMargin + rightMargin;
			int screenHeight = text->getBounds().getHeight() + topMargin + bottomMargin;
	        
			/* 
			* Add all the objects together to create the movie. The origin of the 
			* block of text (0,0) is the top left corner as viewed on the Flash 
			* Player screen. The left and top margins offsets the text correctly
			* from the edge of the screen.
			*/
			movie.setFrameSize(FSBounds(0, 0, screenWidth, screenHeight));
			movie.setFrameRate(1.0f);
			movie.add(new FSSetBackgroundColor(FSColorTable::lightblue()));
			movie.add(font);
			movie.add(text);
			movie.add(new FSPlaceObject2(text->getIdentifier(), ++layer, leftMargin , topMargin));
			movie.add(new FSShowFrame());
	        
			saveMovie(movie, stringOption(options, "resultDir"), "ShowFontFile.swf");
		}
		delete textGenerator;
	}
};

#endif
