/////////////////////////////////////////////////////////////////////////////
// Name:        BurnDlg.h
// Purpose:     Burn dialog
// Author:      Alex Thuering
// Created:	23.03.2003
// RCS-ID:      $Id: BurnDlg.cpp,v 1.12 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "BurnDlg.h"
#include "Config.h"
#include <wx/utils.h>
#include <wxVillaLib/utils.h>

BEGIN_EVENT_TABLE(BurnDlg, wxDialog)
  EVT_BUTTON(TEMP_DIR_BT_ID, BurnDlg::OnChooseTempDir)
  EVT_RADIOBUTTON(GENERATE_RADIO_BT_ID, BurnDlg::OnRadioBt)
  EVT_RADIOBUTTON(ISO_RADIO_BT_ID, BurnDlg::OnRadioBt)
  EVT_BUTTON(ISO_BT_ID, BurnDlg::OnChooseIsoFile)
  EVT_RADIOBUTTON(BURN_RADIO_BT_ID, BurnDlg::OnRadioBt)
  EVT_BUTTON(RESET_BT_ID, BurnDlg::OnReset)
  EVT_BUTTON(wxID_OK, BurnDlg::OnOk)
END_EVENT_TABLE()

BurnDlg::BurnDlg(wxWindow* parent):
 wxDialog(parent, -1, wxEmptyString, wxDefaultPosition, wxDefaultSize,
 wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER)
{
    // begin wxGlade: BurnDlg::BurnDlg
    m_tempDirLabel = new wxStaticText(this, -1, _("Temp directory:"));
    m_tempDirText = new wxTextCtrl(this, -1, wxT(""));
    m_tempDirBt = new wxButton(this, TEMP_DIR_BT_ID, _("..."));
    m_previewCheck = new wxCheckBox(this, PREVIEW_CHECK_ID, _("preview"));
    m_generateRadioBt = new wxRadioButton(this, GENERATE_RADIO_BT_ID, _("just generate"), wxDefaultPosition, wxDefaultSize, wxRB_GROUP);
    m_isoRadioBt = new wxRadioButton(this, ISO_RADIO_BT_ID, _("create iso image"));
    m_isoLabel = new wxStaticText(this, -1, _("Save to:"));
    m_isoText = new wxTextCtrl(this, -1, wxT(""));
    m_isoBt = new wxButton(this, ISO_BT_ID, _("..."));
    m_burnRadioBt = new wxRadioButton(this, BURN_RADIO_BT_ID, _("burn"));
    m_formatCheck = new wxCheckBox(this, -1, _("format DVD-RW"));
    m_deviceLabel = new wxStaticText(this, -1, _("Device:"));
    const wxString m_deviceChoice_choices[] = {
        
    };
    m_deviceChoice = new wxComboBox(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, 0, m_deviceChoice_choices, wxCB_DROPDOWN);
    m_speedLabel = new wxStaticText(this, -1, _("Speed:"));
    const wxString m_speedChoice_choices[] = {
        
    };
    m_speedChoice = new wxComboBox(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, 0, m_speedChoice_choices, wxCB_DROPDOWN);
    m_devPanel = new wxPanel(this, -1);
    m_spacer = new wxPanel(this, -1);
    m_startBt = new wxButton(this, wxID_OK, _("Start"));
    m_cancelBt = new wxButton(this, wxID_CANCEL, _("Cancel"));
    m_resetBt = new wxButton(this, RESET_BT_ID, _("Reset"));

    set_properties();
    do_layout();
    // end wxGlade
}

void BurnDlg::set_properties()
{
    // begin wxGlade: BurnDlg::set_properties
    SetTitle(_("Burn"));
    m_tempDirBt->SetSize(wxSize(21, 21));
    m_isoBt->SetSize(wxSize(21, 21));
    m_deviceChoice->SetSelection(-1);
    m_speedChoice->SetSelection(-1);
    m_startBt->SetDefault();
    // end wxGlade
	
	int h = m_tempDirText->GetSize().GetHeight() > 21 ?
	  m_tempDirText->GetSize().GetHeight() : 21;
	m_tempDirBt->SetSizeHints(h, h, h, h);
	m_isoBt->SetSizeHints(h, h, h, h);
	
	// set devices
#ifdef __WXMSW__
    if (s_config.GetBurnScanCmd().length() &&
        s_config.GetBurnScanCmd().Find(wxT("cdrecord")))
    {
      wxString cmd = s_config.GetBurnScanCmd();
      cmd = wxGetAppPath() + wxString(wxFILE_SEP_PATH) + _T("..") +
          wxString(wxFILE_SEP_PATH) + _T("dvdauthor") +
          wxString(wxFILE_SEP_PATH) + cmd;
      wxArrayString output;
      if (wxExecute(cmd, output, wxEXEC_SYNC) == 0)
      {
        for (unsigned int i=0; i<output.Count(); i++)
        {
          if (output[i].length() && output[i][0] == wxT('\t') &&
              output[i].Find(wxT("Removable CD-ROM"))>0)
          {
            wxString dev = output[i].Strip(wxString::leading).BeforeFirst(wxT('\t'));
            wxString descrAll = output[i].AfterFirst(wxT('\'')).BeforeLast(wxT('\''));
            wxString descr = descrAll.BeforeFirst(wxT('\'')).Strip(wxString::both);
            descrAll = descrAll.AfterFirst(wxT('\'')).AfterFirst(wxT('\''));
            descr += wxT(' ') + descrAll.BeforeFirst(wxT('\'')).Strip(wxString::both);
            m_devices.Add(dev); m_deviceChoice->Append(descr);
          }
        }
      }
      if (m_devices.Count() == 0)
      {
        m_devices.Add(wxT("1,0,0")); m_deviceChoice->Append(wxT("1,0,0"));
        m_devices.Add(wxT("1,1,0")); m_deviceChoice->Append(wxT("1,1,0"));
      }
    }
    else
    {
      m_deviceChoice->Append(wxT("1,0,0"));
      m_deviceChoice->Append(wxT("1,1,0"));
    }
#else
	const wxString devices[] = { _T("/dev/dvd"), _T("/dev/cdrom") };
	for (int i=0; i<=16; i++)
	{
	  wxString dev;
	  if (i<2)
		dev = devices[i];
	  else
		dev = wxString::Format(_T("/dev/sg%d"), i-2);
	  //if (wxFileExists(dev))
	  m_deviceChoice->Append(dev);
	}
#endif

	m_speedChoice->Append(_T("auto"));
	for (int speed = 1; speed <= 8; speed = speed*2)
	  m_speedChoice->Append(wxString::Format(_T("%dx"), speed));
  
	UpdateCtrls();
#if defined(__WXGTK__) && wxCHECK_VERSION(2,5,2) && !wxCHECK_VERSION(2,5,4)
	m_startBt->SetSizeHints(-1, m_startBt->GetSize().GetY()+8);
#endif
#ifdef __WXMSW__
    if (!s_config.GetPreviewCmd().length())
	   m_previewCheck->Enable(false);
    if (!s_config.GetBurnCmd().length())
	  m_burnRadioBt->Enable(false);
    if (!s_config.GetFormatCmd().length())
	  m_formatCheck->Enable(false);
#endif
}

void BurnDlg::do_layout()
{
    // begin wxGlade: BurnDlg::do_layout
    wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* btSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* panelSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* deviceSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* formatSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* isoSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* tempDirSizer = new wxBoxSizer(wxHORIZONTAL);
    tempDirSizer->Add(m_tempDirLabel, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 4);
    tempDirSizer->Add(m_tempDirText, 1, 0, 0);
    tempDirSizer->Add(4, 16, 0, 0, 0);
    tempDirSizer->Add(m_tempDirBt, 0, 0, 0);
    panelSizer->Add(tempDirSizer, 1, wxTOP|wxBOTTOM|wxEXPAND, 4);
    panelSizer->Add(m_previewCheck, 0, wxBOTTOM, 6);
    panelSizer->Add(m_generateRadioBt, 0, 0, 0);
    panelSizer->Add(m_isoRadioBt, 0, 0, 0);
    isoSizer->Add(16, 8, 0, 0, 0);
    isoSizer->Add(m_isoLabel, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 4);
    isoSizer->Add(m_isoText, 1, 0, 0);
    isoSizer->Add(4, 16, 0, 0, 0);
    isoSizer->Add(m_isoBt, 0, 0, 0);
    panelSizer->Add(isoSizer, 1, wxTOP|wxBOTTOM|wxEXPAND, 4);
    panelSizer->Add(m_burnRadioBt, 0, 0, 0);
    formatSizer->Add(16, 8, 0, 0, 0);
    formatSizer->Add(m_formatCheck, 0, wxEXPAND, 0);
    panelSizer->Add(formatSizer, 1, wxEXPAND, 0);
    deviceSizer->Add(16, 8, 0, 0, 0);
    deviceSizer->Add(m_deviceLabel, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 4);
    deviceSizer->Add(m_deviceChoice, 0, 0, 0);
    deviceSizer->Add(12, 20, 0, 0, 0);
    deviceSizer->Add(m_speedLabel, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 12);
    deviceSizer->Add(m_speedChoice, 0, 0, 0);
    deviceSizer->Add(m_devPanel, 1, wxEXPAND, 0);
    panelSizer->Add(deviceSizer, 1, wxTOP|wxBOTTOM|wxEXPAND, 4);
    mainSizer->Add(panelSizer, 0, wxALL|wxEXPAND, 6);
    mainSizer->Add(m_spacer, 1, wxEXPAND, 0);
    btSizer->Add(50, 20, 1, wxEXPAND, 0);
    btSizer->Add(m_startBt, 0, wxALIGN_CENTER_VERTICAL, 0);
    btSizer->Add(10, 20, 0, 0, 0);
    btSizer->Add(m_cancelBt, 0, wxALIGN_CENTER_VERTICAL, 0);
    btSizer->Add(10, 20, 0, 0, 0);
    btSizer->Add(m_resetBt, 0, wxALIGN_CENTER_VERTICAL, 0);
    btSizer->Add(50, 20, 1, wxEXPAND, 0);
    mainSizer->Add(btSizer, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND|wxALIGN_BOTTOM, 10);
    SetAutoLayout(true);
    SetSizer(mainSizer);
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);
    Layout();
    Centre();
    // end wxGlade
}

wxString BurnDlg::GetDevice()
{
  if (m_devices.Count())
    return m_devices[m_deviceChoice->GetSelection()];
  else
    return m_deviceChoice->GetValue();
}

void BurnDlg::SetDevice(wxString device)
{
  if (m_devices.Count())
  {
    int n = m_devices.Index(device);
    if (n<0)
      n = 0;
    m_deviceChoice->SetSelection(n);
  }
  else
    m_deviceChoice->SetValue(device);
}

int BurnDlg::GetSpeed()
{
  long speed = 0;
  if (m_speedChoice->GetSelection() > 0)
	m_speedChoice->GetStringSelection().BeforeFirst(wxT('x')).ToLong(&speed);
  return speed;
}

void BurnDlg::SetSpeed(int speed)
{
  if (speed == 0)
	m_speedChoice->SetSelection(0);
  else
	m_speedChoice->SetStringSelection(wxString::Format(_T("%dx"), speed));
}

void BurnDlg::UpdateCtrls(bool def)
{
  m_tempDirText->SetValue(s_config.GetTempDir(def));
  m_previewCheck->SetValue(s_config.GetPreviewDo(def));
  m_generateRadioBt->SetValue(s_config.GetGenerateDo(def));
  m_isoRadioBt->SetValue(s_config.GetIsoDo(def));
  m_isoText->SetValue(s_config.GetIsoSaveTo(def));
  m_burnRadioBt->SetValue(s_config.GetBurnDo(def));
  m_formatCheck->SetValue(s_config.GetFormatDo(def));
  SetDevice(s_config.GetBurnDevice(def));
  SetSpeed(s_config.GetBurnSpeed(def));
  wxCommandEvent evt;
  OnRadioBt(evt);
}

void BurnDlg::OnChooseTempDir(wxCommandEvent& event)
{
  wxDirDialog dlg(this, _("Choose a directory"), GetTempDir(),
    wxDD_NEW_DIR_BUTTON);
  if (dlg.ShowModal() != wxID_OK)
    return;
  wxString dir = dlg.GetPath();
  dir += wxFILE_SEP_PATH + wxString(_T("dvd")) + wxFILE_SEP_PATH;
  m_tempDirText->SetValue(dir);  
}

void BurnDlg::OnRadioBt(wxCommandEvent& event)
{
  m_isoLabel->Enable(DoCreateIso());
  m_isoText->Enable(DoCreateIso());
  m_isoBt->Enable(DoCreateIso());
  m_formatCheck->Enable(DoBurn());
  m_deviceLabel->Enable(DoBurn());
  m_deviceChoice->Enable(DoBurn());
  m_speedLabel->Enable(DoBurn());
  m_speedChoice->Enable(DoBurn());
}

void BurnDlg::OnChooseIsoFile(wxCommandEvent& event)
{
  wxFileDialog dlg(this, _("Choose a file to save iso image"),
   wxPathOnly(GetIsoFile()), _T("dvd.iso"), _T("*.iso"), wxSAVE);
  if (dlg.ShowModal() != wxID_OK)
     return;
  m_isoText->SetValue(dlg.GetPath());
}

void BurnDlg::OnReset(wxCommandEvent& event)
{
  UpdateCtrls(true);
}

void BurnDlg::OnOk(wxCommandEvent& event)
{
  s_config.SetTempDir(m_tempDirText->GetValue());
  s_config.SetPreviewDo(m_previewCheck->GetValue());
  s_config.SetGenerateDo(m_generateRadioBt->GetValue());
  s_config.SetIsoDo(m_isoRadioBt->GetValue());
  s_config.SetIsoSaveTo(m_isoText->GetValue());
  s_config.SetBurnDo(m_burnRadioBt->GetValue());
  s_config.SetFormatDo(m_formatCheck->GetValue());
  s_config.SetBurnDevice(GetDevice());
  s_config.SetBurnSpeed(GetSpeed());
  s_config.Flush();
  EndModal(wxID_OK);
}
