/////////////////////////////////////////////////////////////////////////////
// Name:        BurnDlg.h
// Purpose:     Burn dialog
// Author:      Alex Thuering
// Created:	23.03.2003
// RCS-ID:      $Id: BurnDlg.h,v 1.8 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include <wx/wx.h>
#include <wx/image.h>

#ifndef BURNDLG_H
#define BURNDLG_H

// begin wxGlade: dependencies
// end wxGlade

class BurnDlg: public wxDialog
{
  public:
    // begin wxGlade: BurnDlg::ids
    enum {
        TEMP_DIR_BT_ID = 2000,
        PREVIEW_CHECK_ID = 2010,
        GENERATE_RADIO_BT_ID = 2020,
        ISO_RADIO_BT_ID = 2030,
        ISO_BT_ID = 2031,
        BURN_RADIO_BT_ID = 2040,
        RESET_BT_ID = 2050
    };
    // end wxGlade
    BurnDlg(wxWindow* parent);
    wxString GetTempDir() { return m_tempDirText->GetValue(); }
	bool DoPreview() { return m_previewCheck->GetValue(); }
	bool DoGenerate() { return m_generateRadioBt->GetValue(); }
	bool DoCreateIso() { return m_isoRadioBt->GetValue(); }
	wxString GetIsoFile() { return m_isoText->GetValue(); }
	bool DoBurn() { return m_burnRadioBt->GetValue(); }
	bool DoFormat() { return m_formatCheck->GetValue(); }
	wxString GetDevice();
	int GetSpeed();

  private:
    // begin wxGlade: BurnDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade

  protected:
    // begin wxGlade: BurnDlg::attributes
    wxStaticText* m_tempDirLabel;
    wxTextCtrl* m_tempDirText;
    wxButton* m_tempDirBt;
    wxCheckBox* m_previewCheck;
    wxRadioButton* m_generateRadioBt;
    wxRadioButton* m_isoRadioBt;
    wxStaticText* m_isoLabel;
    wxTextCtrl* m_isoText;
    wxButton* m_isoBt;
    wxRadioButton* m_burnRadioBt;
    wxCheckBox* m_formatCheck;
    wxStaticText* m_deviceLabel;
    wxComboBox* m_deviceChoice;
    wxStaticText* m_speedLabel;
    wxComboBox* m_speedChoice;
    wxPanel* m_devPanel;
    wxPanel* m_spacer;
    wxButton* m_startBt;
    wxButton* m_cancelBt;
    wxButton* m_resetBt;
    // end wxGlade
	
	wxArrayString m_devices;
	void SetDevice(wxString device);
	void SetSpeed(int speed);
	void UpdateCtrls(bool def = false);
	void OnChooseTempDir(wxCommandEvent& WXUNUSED(event));
	void OnRadioBt(wxCommandEvent& WXUNUSED(event));
	void OnChooseIsoFile(wxCommandEvent& WXUNUSED(event));
	void OnReset(wxCommandEvent& WXUNUSED(event));
	void OnOk(wxCommandEvent& WXUNUSED(event));
	
  private:
    DECLARE_EVENT_TABLE()
};

#endif // BURNDLG_H
