/////////////////////////////////////////////////////////////////////////////
// Name:        Menu.h
// Purpose:     The class to store a DVD Menu
// Author:      Alex Thuering
// Created:	04.11.2003
// RCS-ID:      $Id: Menu.h,v 1.31 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef MENU_H
#define MENU_H

#include "MenuObject.h"

enum VideoFormat
{
  vfPAL = 0,
  vfNTSC
};

enum AudioFormat
{
  afMP2 = 0,
  afAC3
};

enum MenuDrawType
{
  mdALL,
  mdBACKGROUND,
  mdBUTTONS_NORMAL,
  mdBUTTONS_HIGHLIGHTED,
  mdBUTTONS_SELECTED
};

WX_DEFINE_ARRAY(MenuObject*, MenuObjects);

class Menu
{
  public:
	Menu(VideoFormat videoFormat = vfPAL);
	~Menu();
    
    inline wxSVGDocument* GetSVG() { return m_svg; }
	
	inline VideoFormat GetVideoFormat() { return m_videoFormat; }
	void SetVideoFormat(VideoFormat format);
	wxSize GetResolution();
	
	inline wxString GetStartTime() { return m_startTime; }
	inline void 	SetStartTime(wxString time) { m_startTime = time; }
	inline wxString GetEndTime() { return m_endTime; }
	inline void 	SetEndTime(wxString time) { m_endTime = time; }
	
    void SetBackground(wxString fileName);
    wxString GetBackground();
    void SetBackgroundColour(wxColour colour);
    wxColour GetBackgroundColour();
    bool HasVideoBackground();
	
	wxString AddImage(wxString fileName, int x = -1, int y = -1);
	wxString AddText(wxString text, int x = -1, int y = -1);
    wxString AddObject(wxString fileName, wxString param, int x = -1, int y = -1);
	
	int GetObjectsCount() { return m_objects.Count(); }
    MenuObject* GetObject(int index) { return m_objects[index]; }
	MenuObject* GetObject(wxString id);
    void RemoveObject(wxString id);
    inline void ObjectToFront(wxString id) { MenuObject* obj = GetObject(id); if (obj) obj->ToFront(); }
    inline void ObjectForward(wxString id) { MenuObject* obj = GetObject(id); if (obj) obj->Forward(); }
    inline void ObjectBackward(wxString id) { MenuObject* obj = GetObject(id); if (obj) obj->Backward(); }
    inline void ObjectToBack(wxString id) { MenuObject* obj = GetObject(id); if (obj) obj->ToBack(); }
    inline bool IsFirstObject(wxString id) { MenuObject* obj = GetObject(id); return obj && obj->IsFirst(); }
    inline bool IsLastObject(wxString id) { MenuObject* obj = GetObject(id); return obj && obj->IsLast(); }
	
	void SetTransparentColor();
	wxImage GetImage(int width, int height);
	
	bool ReduceColours();
	wxImage* GetImages();
	
	bool SaveSpumux(wxString fileName,  wxString btFile, wxString hlFile, wxString selFile);
	wxXmlNode* GetXML(DVDFileType type, int playAllRegister = -1, wxXmlNode* node = NULL);
	bool PutXML(wxXmlNode* node);
    wxString AddObject(wxXmlNode* node, bool fixPosition = false);

  private:
    wxSVGDocument* m_svg;
	VideoFormat m_videoFormat;
	wxString 	m_startTime, m_endTime;
	wxColour 	m_transpColour;
	MenuObjects m_objects;
	void FixPosition(MenuObject* obj); /** for copy & paste */
    bool IsDefElement(wxSVGElement* element);
    void RemoveChangeable(wxSVGElement* element, MenuObject* obj);
    bool RemoveNotChangeable(wxSVGElement* element, MenuObject* obj);
    wxSVGSVGElement* GetSVGCopy();
    wxImage RenderImage(MenuDrawType drawType, int width, int height);
    wxImage GetImage(MenuDrawType drawType, int width = -1, int height = -1);
};

#endif // MENU_H
