/////////////////////////////////////////////////////////////////////////////
// Name:        Slideshow.h
// Purpose:     The class to store information for slideshow
// Author:      Alex Thuering
// Created:	26.06.2005
// RCS-ID:      $Id: Slideshow.h,v 1.3 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef SLIDESHOW_H
#define SLIDESHOW_H

#include "Menu.h"

class Slide
{
  public:
    Slide() {}
    Slide(const wxString& filename): m_filename(filename) {}
    Slide(wxXmlNode* node) { PutXML(node); }
    
    inline wxString GetFilename() { return m_filename; }
    inline void SetFilename(const wxString& filename) { m_filename = filename; }
    
    wxXmlNode* GetXML();
	bool PutXML(wxXmlNode* node);
  
  protected:
    wxString m_filename;
};

WX_DEFINE_ARRAY(Slide*, SlideArray);

class Slideshow: public SlideArray
{
  public:
    Slideshow(VideoFormat videoFormat = vfPAL);
    Slideshow(wxXmlNode* node);
    ~Slideshow();
    
    inline VideoFormat GetVideoFormat() { return m_videoFormat; }
	inline void SetVideoFormat(VideoFormat format) { m_videoFormat = format; }
	wxSize GetResolution();
    float GetFPS();
    
    inline int GetDuration() { return m_duration; }
    inline void SetDuration(int duration) { m_duration = duration; }
    
    wxImage GetThumbImage(int width, int height);
    wxImage GetImage(int index);
    
    wxXmlNode* GetXML(DVDFileType type, wxXmlNode* node = NULL);
	bool PutXML(wxXmlNode* node);
  
  protected:
    VideoFormat m_videoFormat;
    int m_duration;
};

#endif //SLIDESHOW_H
