/////////////////////////////////////////////////////////////////////////////
// Name:        TitlePropDlg.cpp
// Purpose:     DVD title properties dialog
// Author:      Alex Thuering
// Created:     31.01.2004
// RCS-ID:      $Id: TitlePropDlg.cpp,v 1.19 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "TitlePropDlg.h"
#include "TitlesetManager.h"
#include "AVPropDlg.h"

enum
{
  AV_BT_ID = 7850
};

BEGIN_EVENT_TABLE(TitlePropDlg, wxPropDlg)
  EVT_BUTTON(AV_BT_ID, TitlePropDlg::OnAV)
END_EVENT_TABLE()

TitlePropDlg::TitlePropDlg(wxWindow* parent, DVD* dvd,
 Audio* audio, Video* video, Pgc* pgc, Vob* vob):
  wxPropDlg(parent), m_dvd(dvd), m_audio(audio), m_video(video), m_pgc(pgc), m_vob(vob)
{
  Create();
  SetSize(360,-1);
}

void TitlePropDlg::CreatePropPanel(wxSizer* sizer)
{
  if (m_vob->GetSlideshow())
  {
    Slideshow* slideshow = m_vob->GetSlideshow();
    wxSizer* grpSizer = BeginGroup(sizer, _("Slideshow"));
    wxFlexGridSizer* grid = new wxFlexGridSizer(2, 2, 4, 16);
    grid->AddGrowableCol(1);
    wxArrayString formats = DVD::GetVideoFormatStrings();
    AddComboProp(grid, _("Format:"), formats[slideshow->GetVideoFormat()],
      formats, wxCB_READONLY);
    AddSpinProp(grid, _("Duration (sec):"), slideshow->GetDuration(), 1, 1000);
    grpSizer->Add(grid, 0, wxEXPAND|wxALL, 6);
  }
  else
  {
    wxSizer* grpSizer = BeginGroup(sizer, _("Video object"));
    wxFlexGridSizer* grid = new wxFlexGridSizer(2, 4, 16);
    grid->AddGrowableCol(1);
    if (m_vob->GetFilename().length())
      AddStaticTextProp(grid, _("File name:"), m_vob->GetFilename());
    else if (m_vob->GetVideoFilename().length())
      AddStaticTextProp(grid, _("Video:"), m_vob->GetVideoFilename());
    for (unsigned int i=0; i<m_vob->GetAudioFilenames().Count(); i++)
    {
      grid->Add(1,1); grid->Add(1,1);
      AddStaticTextProp(grid, _("Audio:"), m_vob->GetAudioFilenames()[i]);
    }
    for (unsigned int i=0; i<m_vob->GetSubtitles().Count(); i++)
    {
      grid->Add(1,1); grid->Add(1,1);
      AddStaticTextProp(grid, _("Subtitle:"), m_vob->GetSubtitles()[i]->GetFilename());
    }
    grid->Add(2,2); grid->Add(2,2);
    AddTextProp(grid, _("Chapters:"), m_vob->GetChapters());
    AddSpinProp(grid, _("Pause:"), m_vob->GetPause(), -1, 254);
    grpSizer->Add(grid, 0, wxEXPAND|wxALL, 6);
  }
  sizer->Add(6,6);
  
  wxSizer* grpSizer = BeginGroup(sizer, _("Title"));
  wxFlexGridSizer* grid = new wxFlexGridSizer(2, 2, 4, 16);
  grid->AddGrowableCol(1);
  wxArrayString commands;
  for (int pgci=0; pgci<(int)m_dvd->GetVmgm().Count(); pgci++)
	commands.Add(wxString::Format(_T("call vmgm menu %d;"),pgci+1));
  for (int tsi=0; tsi<(int)m_dvd->GetTitlesets().Count(); tsi++)
  {
	Titleset* ts = m_dvd->GetTitlesets()[tsi];
	if (ts->GetMenus().Count()>0)
	  commands.Add(_T("call menu;"));
	if (m_dvd->IsJumppadsEnabled())
	{
	  for (int pgci=1; pgci<(int)ts->GetMenus().Count(); pgci++)
		commands.Add(wxString::Format(_T("call menu %d;"),pgci+1));
	}
	for (int pgci=0; pgci<(int)ts->GetTitles().Count(); pgci++)
	  commands.Add(wxString::Format(_T("jump title %d;"),pgci+1));
  }
  AddComboProp(grid, _("Pre commands:"), m_pgc->GetPreCommands(), commands);
  AddComboProp(grid, _("Post commands:"), m_pgc->GetPostCommands(), commands);
  grpSizer->Add(grid, 0, wxEXPAND|wxALL, 6);
}

bool TitlePropDlg::SetValues()
{
  int n = 0;
  if (m_vob->GetSlideshow())
  {
    Slideshow* slideshow = m_vob->GetSlideshow();
    slideshow->SetVideoFormat((VideoFormat) GetInt(n++));
    slideshow->SetDuration(GetInt(n++));
  }
  else
  {
    if (m_vob->GetFilename().length() ||
        m_vob->GetVideoFilename().length())
      n++;
    n += m_vob->GetAudioFilenames().Count();
    n += m_vob->GetSubtitles().Count();
    m_vob->SetChapters(GetString(n++));
    m_vob->SetPause(GetInt(n++));
  }
  m_pgc->SetPreCommands(GetString(n++));
  m_pgc->SetPostCommands(GetString(n++));
  return true;
}

void TitlePropDlg::CreateButtonPane(wxSizer* sizer, bool resetButton)
{
  wxBoxSizer* buttonPane = new wxBoxSizer(wxHORIZONTAL);
  wxButton* avBt = new wxButton(this, AV_BT_ID, _("Audio/Video..."));
  buttonPane->Add(avBt, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL);
  buttonPane->Add(10, 10, 1, wxEXPAND);
  wxButton* okBt = new wxButton(this, wxID_OK, _("OK"));
  okBt->SetDefault();
#if defined(__WXGTK__) && wxCHECK_VERSION(2,5,2) && !wxCHECK_VERSION(2,5,4)
  okBt->SetSizeHints(-1, okBt->GetSize().GetY()+8);
#endif
  buttonPane->Add(okBt, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL);
  buttonPane->Add(8, 0);
  wxButton* cancelBt = new wxButton(this, wxID_CANCEL, _("Cancel"));
  buttonPane->Add(cancelBt, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL);
  sizer->Add(buttonPane, 0, wxEXPAND|wxLEFT|wxRIGHT|wxBOTTOM, 10);
}

void TitlePropDlg::OnAV(wxCommandEvent& event)
{
  AVPropDlg propDlg(this, m_audio, m_video, false);
  if (propDlg.ShowModal() == wxID_OK)
  {
	wxCommandEvent evt(EVT_COMMAND_DVD_CHANGED, this->GetId());
	GetEventHandler()->ProcessEvent(evt);
  }
}
