#!/usr/bin/perl -w

# This script counts on the mailto: having a somewhat reasonable format...
#  it is likely that a sneaky user could do shell injection tricks here,
#  and we don't stop them. Send patches.

# This needs to be in your prefs.js file in firefox:
#user_pref("network.protocol-handler.expose.mailto", true);
#user_pref("network.protocol-handler.app.mailto", "/where/i/copied/mailto-thunderbird.pl");

use warnings;
use strict;

sub find_in_path {
    my $bin = shift;

    # If binary has absolute or relative path, don't search $PATH...
    if ($bin =~ /\//) {
        if (-x $bin) {
            return $bin;
        } else {
            return undef;
        }
    }

    # Search the $PATH...
    my @paths = split /:/,$ENV{'PATH'};
    foreach (@paths) {
        my $full = "$_/$bin";
        return $full if (-x $full);
    }

    return undef;  # not in $PATH.
}

sub find_installed_name {
    my $product = shift;
    my @names = @_;
    foreach (@names) {
        my $fname = find_in_path($_);
        return $fname if defined $fname;
    }

    print STDERR "Can't find $product in \$PATH. Giving up.\n";
    exit 1
}

# Mainline ...

die("USAGE: $0 <mailto:url>\n") if (scalar @ARGV != 1);
my $mailexe = find_installed_name('Mozilla Thunderbird', 'mozilla-thunderbird', 'thunderbird');
my $mailto = $ARGV[0];
$mailto =~ s/\Amailto\://;

my $to = '';
my $args = '';

if ( $mailto =~ /\A(.*?)\?(.*)\Z/ ) {
    $to = $1;
    $args = $2;
} else {
    # assume whole thing is the To: address.
    $to = $mailto;
}

my @attachments;
my $cmdline = $mailexe . ' -remote "xfeDoCommand(composeMessage';

$cmdline .= ",to=$to" if ($to ne '');

my @pairs = split /\&/, $args;
foreach my $pair (@pairs) {
   if($pair=~m/([^=]+)=(.*)/) {
      my $field = $1;
      my $value = $2;
      $field =~ tr/A-Z/a-z/;
      if ($field eq 'attach') {
        $value =~ s#\Afile://##;
        push @attachments, $value;
      } else {
        $cmdline .= ",${field}=${value}";
      }
   }
}

if (@attachments) {
    $cmdline .= ",attachment='";
    my $comma = '';
    foreach my $attach (@attachments) {
        $cmdline .= "${comma}file://${attach}";
        $comma = ',';
    }
    $cmdline .= "'";
}

$cmdline .= ')"';

#print $cmdline . "\n";

# exec thunderbird if there's no instance running
system("$mailexe -remote 'ping()'");
my $launched = ($? == 0);
system("$mailexe &") if (not $launched);

# Wait for it to respond...
my $maxwait = 15;  # wait 15 seconds, tops.
for (my $i = 0; ((not $launched) and ($i < $maxwait)); $i++) {
    sleep 1;
    system("$mailexe -remote 'ping()'");
    $launched = ($? == 0);
}

if (not $launched) {
    print STDERR "Failed to launch $mailexe ...";
    exit 1;
}

# Raise the Thunderbird window.
system("$mailexe -remote 'xfeDoCommand(openInbox)'");

# and maybe send the mailto:
system($cmdline);

# end of mailto-thunderbird.pl ...


