/***************************************************************************
                          correlationmeter.cpp  -  description
                             -------------------
    begin                : Sun Feb 18 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "correlationmeter.h"

#include <qpainter.h>

CorrelationMeter::CorrelationMeter(QWidget *parent, const char *name ) : QFrame(parent,name)
{
  setBackgroundColor(QColor(0, 0, 0));
  setFrameStyle(WinPanel | Sunken);
  setLineWidth(2);

  pointerPen.setWidth(3);
  ereaserPen.setWidth(3);
  gridPen.setWidth(1);
  iPosition = 0;

  uAverageDots = 20000;
  l = new char [uAverageDots];
  r = new char [uAverageDots];
  memset(l, 0, uAverageDots * sizeof(char));
  memset(r, 0, uAverageDots * sizeof(char));
  uAveragePointer = 0;

}
CorrelationMeter::~CorrelationMeter(){

  delete [] l;
  delete [] r;

}
/** sets colour for pointer pen */
void CorrelationMeter::setPointerPenColour(QColor colour){

	pointerPen.setColor(colour);
}

/** sets colour for grid pen */
void CorrelationMeter::setGridPenColour(QColor colour){

	gridPen.setColor(colour);
}
/** sets colour of background */
void CorrelationMeter::setBackgroundColour(QColor colour){

  setBackgroundColor(colour);
	ereaserPen.setColor(colour);
}

void CorrelationMeter::paintEvent(QPaintEvent* qpevt) {
  QPainter qp;
  if (qp.begin(this)) {
    drawFrame(&qp);

    qp.setPen(gridPen);
    for (int i = 0; i < 17; i++){
      qp.drawLine(_iGridArray[i], 3, _iGridArray[i], height() - 3);
    }

    qp.setPen(pointerPen);
    qp.moveTo(iPosition, 3);
    qp.drawLine(iPosition, 3, iPosition, height() - 3);

    qp.end();
  }
}

/** Input for new sampled data. */
void CorrelationMeter::newData(const unsigned char *buffer,
																	unsigned int uDataStart,
																	unsigned int uDataEnd,
																	unsigned int uBuffer_Size){

  unsigned int i;
  float f_kSum = 0;
  float f_rqSum = 0;
  float f_lqSum = 0;

  /* average dots should never be 0 - otherwise it'll crash!!*/

  unsigned int uDots = (uDataEnd >= uDataStart ? uDataEnd - uDataStart : uDataEnd + uBuffer_Size - uDataStart) / 2;
  for (i = 0; i < uDots; i++) {
    unsigned int j = (i + uAveragePointer) % uAverageDots;
    unsigned int k = (uDataStart + i * 2) % uBuffer_Size;
    r[j] = buffer[k] - 128;
    l[j] = buffer[k + 1] - 128;
  }
  uAveragePointer = (uAveragePointer + uDots) % uAverageDots;

  for (i = 0; i < uAverageDots; i++) {
    f_kSum += r[i] * l[i];
    f_rqSum += r[i] * r[i];
    f_lqSum += l[i] * l[i];
  }
  float fNewCorrelation = f_kSum / sqrt(f_lqSum * f_rqSum);

  int iNewPosition =
    (int) ((fNewCorrelation + 1.0) * (width() - 6)) / 2 + 6;

  if (iPosition != iNewPosition) {
    QPainter qp;
    if (qp.begin(this)) {
      // delete old pointe 
			// since the pointer is thicker than the grid lines 
			// we have to delete it first 
      qp.setPen(ereaserPen);
      qp.drawLine(iPosition, 3, iPosition, height() - 3);

			// and afterwards we can deal with concealed grid lines
			// if pointer concealed a grid line restore it
			for (int i = 0; i < 17; i++){
				int x = _iGridArray[i];
				if(iPosition >= x - 1 && iPosition <= x + 1){
					qp.setPen(gridPen);
					qp.drawLine(x, 3, x, height() - 3);
					break;
				}
			}

      // draw new pointer
      qp.setPen(pointerPen);
      qp.moveTo(iNewPosition, 3);
      qp.lineTo(iNewPosition, height() - 3);

      qp.end();

      iPosition = iNewPosition;
    }
  }
}
/** No descriptions */
void CorrelationMeter::setAverage(unsigned int n){

	if (n > 0) {
    delete [] l;
    delete [] r;
    uAverageDots = n;
    l = new char [uAverageDots];
    r = new char [uAverageDots];
    memset(l, 0, uAverageDots * sizeof(char));
    memset(r, 0, uAverageDots * sizeof(char));
    uAveragePointer = 0;
  }else{

  	/* prevents new Data from crashing? */
		uAverageDots = 1;
  }

}
/** gets background colour  */
QColor CorrelationMeter::getBackGroundColour(){

	return ereaserPen.color();
}

/** gets ray colour  */
QColor CorrelationMeter::getRayColour(){

	return pointerPen.color();
}

/** gets grid colour  */
QColor CorrelationMeter::getGridColour(){

	return gridPen.color();
}

void CorrelationMeter::mousePressEvent(QMouseEvent *e){

	if(e->button() == RightButton)
		emit rbPressed(e->globalPos());
}

void CorrelationMeter::resizeEvent(QResizeEvent* qrevt) {
		QFrame::resizeEvent(qrevt);

		int w2 = width() >> 1;
		int paintArea = width() - 6;
		int dist = paintArea / 16;
		_iGridArray[0] = w2;
		_iGridArray[1] = 5;
		_iGridArray[2]  = paintArea;
		// paint area in x direction limited 
		// from  |>5 - - - - - - - -  5<|
		
		for (int i = 1; i < 8; i++){
			_iGridArray[i*2+1]= i*dist + 5;
			_iGridArray[i*2+2]= paintArea - i*dist;
    }
}
