/* **************************************************************************
                          correlationmeter.h  -  description
                             -------------------
    begin                : Sun Feb 18 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/
/** korrelation meter */
/* **************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CORRELATIONMETER_H
#define CORRELATIONMETER_H
#define KDE_NO_COMPAT

#include <qframe.h>
#include <qpen.h>

#include <math.h>

/**Widget displaying the correlation of the left and the right stereo channel
  *@author M. Ritscher
  */

class QColor;

class CorrelationMeter : public QFrame  {
   Q_OBJECT
public: 
	CorrelationMeter(QWidget *parent=0, const char *name=0);
	~CorrelationMeter();
  /** sets colour for pointer pen */
  void setPointerPenColour(QColor colour);
  /** sets colour for grid pen */
  void setGridPenColour(QColor colour);
  /** sets colour of background */
  void setBackgroundColour(QColor colour);	
  /** gets background colour  */
  QColor getBackGroundColour();
  /** gets ray colour  */
  QColor getRayColour();
  /** gets grid colour  */
  QColor getGridColour();

  /** Input for new sampled data. */
  void newData(const unsigned char *buffer,
  							unsigned int uDataStart,
  							unsigned int uDataEnd,
  							unsigned int uBuffer_Size);
  /** No descriptions */
  void setAverage(unsigned int);

protected:
void paintEvent(QPaintEvent* );
void resizeEvent(QResizeEvent* qrevt);
void mousePressEvent(QMouseEvent *);
private:
	QPen gridPen;
  QPen pointerPen;
  QPen ereaserPen;
	int _iGridArray[18];
  /** current position of pen */
  int iPosition;
  unsigned int uAverageDots, uAveragePointer;
  /**  */
  char *l, *r;
signals: // Signals
  /** sent if right mouse button is clicked */
  void rbPressed(QPoint );
};

#endif
