/***************************************************************************
                          correlationscope.cpp  -  description
                             -------------------
    begin                : Sun Feb 18 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "correlationscope.h"

#include <stdlib.h>

#include <qcolor.h>
#include <qpainter.h>

#include <kmessagebox.h>

CorrelationScope::CorrelationScope(QWidget *parent, const char *name, unsigned int t ) : QFrame(parent,name)
{

  uTrace = t;
  x = new int [uTrace];
  memset(x, 0, uTrace * sizeof(int));
  y = new int [uTrace];
  memset(x, 0, uTrace * sizeof(int));
  uDotPointer = 0;
  uDots = 0;

  setMinimumSize(260, 260);
  setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Minimum ) );
  setBackgroundColor(bgColour);
  setFrameStyle(WinPanel | Sunken);
  setLineWidth(2);

}

CorrelationScope::~CorrelationScope(){

  delete [] x;
  delete [] y;

}

void CorrelationScope::resizeEvent(QResizeEvent* qrevt){
	QFrame::resizeEvent(qrevt);
	_w2 = width() >> 1;
	_h2 = height() >> 1;
	_max = ( _w2 > _h2)? _h2 - 60 : _w2 - 60;
	if( _max < 140 && _max >= 70)
		_max = 70;
}

void CorrelationScope::paintEvent(QPaintEvent* qpevt) {

  QPainter qp;
  if (qp.begin(this)) {
    unsigned int i;
    drawFrame(&qp);
    qp.translate( _w2, _h2);
		

    // paint grid system
    qp.setPen(gridColour);
    for (i = 0; i <= _max; i++) {
      qp.drawPoint(i, i);
      qp.drawPoint(-i, i);
      qp.drawPoint(i, -i);
      qp.drawPoint(-i, -i);
    }

    // label axes
    qp.drawText( _max, -_max-16, 16, 16, AlignHCenter |
		AlignVCenter, "R");
    qp.drawText(-_max-16, -_max-16, 16, 16, AlignHCenter |
		AlignVCenter, "L");

    // paint Lissajous-Figures
/*    qp.setPen(rayColour);

    for (i = 0; i < uTrace; i++)
      qp.drawPoint(x[i], y[i]);

  */
    qp.end();
  }

}

/** sets colour for scope ray */
void CorrelationScope::setRayColour(QColor colour){

	rayColour = colour;
}

/** sets colour for grid pen */
void CorrelationScope::setGridColour(QColor colour){

	gridColour = colour;
}
/** sets colour of background */
void CorrelationScope::setBackgroundColour(QColor colour){

  setBackgroundColor(colour);
	bgColour = colour;
}
/** Input for new sampled data */
void CorrelationScope::newData(const unsigned char *buffer,
																	unsigned int uDataStart,
																	unsigned int uDataEnd,
																	unsigned int uBuffer_Size){


																
																	
  QPainter qp;

  if (qp.begin(this)) {
    qp.translate( width()/2, height()/2);
    qp.setBackgroundColor(bgColour);

   uDots = (uDataEnd >= uDataStart ? uDataEnd - uDataStart : uDataEnd +
			 uBuffer_Size - uDataStart) / 2;


    // delete obsolete dots
    qp.setPen(bgColour);
    for (unsigned int i = 0; i < uDots; i++) {
      unsigned int j = (uDotPointer + i) % uTrace;
      if (abs(x[j]) == abs(y[j])) {
				qp.setPen(gridColour);
				qp.drawPoint(x[j], y[j]);
				qp.setPen(bgColour);
      } else
		qp.drawPoint(x[j], y[j]);
    }


    // draw new dots
    qp.setPen(rayColour);
    for (unsigned int i = 0; i < uDots; i++) {
      unsigned int j = (uDotPointer + i) % uTrace;
      unsigned int k = (uDataStart + i * 2) % uBuffer_Size;
      int r = buffer[k] - 128;
      int l = buffer[k + 1] - 128;

      x[j] = (l - r) ;
      y[j] = (-r - l);
			if(_max < 140){
				x[j] = x[j] >> 1;
				y[j] = y[j] >> 1;
			}else if(_max > 280){
				x[j] = x[j] << 1;
				y[j] = y[j] << 1;
			}

      qp.drawPoint(x[j], y[j]);
    }

 	 uDotPointer = (uDotPointer + uDots) % uTrace;
	
    qp.end();
  }																																	
}
/** adjust tracing */
void CorrelationScope::setTrace(unsigned int t){

  delete [] x;
  delete [] y;
  uTrace = t; //+50000;
  x = new int [uTrace];
  y = new int [uTrace];
  memset(x, 0, uTrace * sizeof(int));
  memset(x, 0, uTrace * sizeof(int));
  uDotPointer = 0;

}
/** returns background colour */
QColor CorrelationScope::getBackgroundColour(){

 return bgColour;
}

/** returns ray colour */
QColor CorrelationScope::getRayColour(){

 return rayColour;
}

/** returns grid colour */
QColor CorrelationScope::getGridColour(){

 return gridColour;
}

void CorrelationScope::mousePressEvent(QMouseEvent *e){

	if(e->button() == RightButton)
		emit rbPressed(e->globalPos());
}

