/* **************************************************************************
                          correlationscope.h  -  description
                             -------------------
    begin                : Sun Feb 18 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/
/** Scope displaying Lissajus figures */
/* *************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CORRELATIONSCOPE_H
#define CORRELATIONSCOPE_H
#define KDE_NO_COMPAT

#include <qframe.h>
#include <qcolor.h>

/**Widget for a scope showing the correlation between two stereo channels
  *@author M. Ritscher
  */

class CorrelationScope : public QFrame  {
   Q_OBJECT
public:
	CorrelationScope(QWidget *parent=0, const char *name=0, unsigned int t = 2000);
	~CorrelationScope();

  /** sets colour for scope ray */
  void setRayColour(QColor colour);
  /** sets colour for grid  */
  void setGridColour(QColor colour);
  /** sets colour of background */
  void setBackgroundColour(QColor colour);	
  /** returns background colour */
  QColor getBackgroundColour();
  /** returns background colour */
  QColor getRayColour();
  /** returns grid colour */
  QColor getGridColour();


  /** Input for new sampled data */
  void newData(const unsigned char  *buffer,
  							unsigned int uDataStart,
  							unsigned int uDataEnd,
  							unsigned int uBuffer_Size);
  /** adjust tracing */
  void setTrace(unsigned int);

protected:

void resizeEvent(QResizeEvent* qrevt);
void paintEvent(QPaintEvent* qpevt);
void mousePressEvent(QMouseEvent*);

private:

	QColor rayColour, gridColour, bgColour;
  /** tracing */
  unsigned int uTrace, uDotPointer;
  unsigned int uDots;
  int *x, *y;
	int _w2, _h2;
	unsigned int _max;

signals: // Signals
  /** sent if right mouse button is clicked */
  void rbPressed(QPoint);
};

#endif
