/***************************************************************************
                          kcorrmeter.cpp  -  description
                             -------------------
    begin                : Sam Feb 17 11:05:53 MET 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
// #include <kmenubar.h>
#include <kmessagebox.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kiconloader.h>
#include <qpopupmenu.h>

#include "kcorrmeter.h"
#include "kcorrview.h"

KCorrMeter::KCorrMeter(QWidget *parent, const char *name) : KMainWindow(parent, name)
{

  view = new KCorrView(this, "correlation");

 	connect(view, SIGNAL(rbPressed(QPoint)), this, SLOT(slotContextMenu(QPoint)));
	connect(view, SIGNAL(started(bool)), this, SLOT(slotToggleStartStop(bool)));
	
	initActions();
	
	view->resume();

	setCentralWidget(view);

}

KCorrMeter::~KCorrMeter()
{
}

/** Initialize all comand Actions */
void KCorrMeter::initActions(){

	actHalt = new KAction(i18n("Sto&p"),
													KGlobal::instance()->iconLoader()->loadIcon( "stop", KIcon::NoGroup, KIcon::SizeSmall ),
													0, view, SLOT(halt()), actionCollection(), "halt");
	actResume = new KAction( i18n("&Start"),
													KGlobal::instance()->iconLoader()->loadIcon( "resume", KIcon::NoGroup, KIcon::SizeSmall ),
													0, view, SLOT(resume()), actionCollection(), "resume");
	KStdAction::quit(this, SLOT(close()), actionCollection());

	corrSetup = new KAction(i18n("&Setup"),
													KGlobal::instance()->iconLoader()->loadIcon( "configure", KIcon::NoGroup, KIcon::SizeSmall ),
													CTRL+Key_C, view, SLOT(showSetupDlg()), actionCollection(), "corr_settings");
	//KGlobal::instance()->iconLoader()->loadIcon( "config", KIcon::NoGroup, KIcon::SizeSmall ))

	createGUI();
}


void KCorrMeter::slotContextMenu(QPoint p){

  rmbMenu =  static_cast<QPopupMenu *>(factory()->container("rb_popup", this) );   	
  if( rmbMenu)
  	{
  		rmbMenu->popup(p);
		}
}



/**  toggles state of controls for device */
void KCorrMeter::slotToggleStartStop(bool started){
	
	if(started)
	{
		actHalt->setEnabled(true);
		actResume->setEnabled(false);
	}else{
		actHalt->setEnabled(false);
		actResume->setEnabled(true);	
	}
}
