/***************************************************************************
                          kcorrsetupdlg.cpp  -  description
                             -------------------
    begin                : Sat Feb 17 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcorrsetupdlg.h"
#include <klocale.h>
//#include <kmessagebox.h>
//#include <kkeydialog.h>
//#include <kstddirs.h>
#include <kiconloader.h>
#include <kcolorbutton.h>
#include <kmessagebox.h>
#include <knuminput.h>

#include <qlayout.h>
#include <qvbox.h>
#include <qgrid.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qcombobox.h>


KCorrSetupDlg::KCorrSetupDlg(QWidget *parent, const char *name ) :
	KDialogBase ( IconList,                 // dialogFace
                i18n("Setup"),   					// caption
                Ok|Default|Apply|Cancel,  // buttonMask
                Ok,                       // defaultButton
                parent,
                name,
                true,                     // modal
                true)//,                  // separator
  							//wantsTreeRefresh(false)
{

	addCorrMeterPage();
	addColourPage();
	addVUPage();

}
KCorrSetupDlg::~KCorrSetupDlg(){
}

/** adds a page with settings for the correlation meter scope */
void KCorrSetupDlg::addCorrMeterPage()
{
	corrMeterPage = addGridPage(2, QGrid::Horizontal, i18n("Device"),i18n("Correlation Meter Configuration"),
	KGlobal::instance()->iconLoader()->loadIcon( "gear", KIcon::NoGroup, KIcon::SizeMedium ));

	QLabel* lSystem = new QLabel(i18n("System"), corrMeterPage);
	mDevice.cbSSystem = new QComboBox(corrMeterPage);
//	mDevice.cbSSystem->insertItem("other method e.g. Jack",ssystem_other);
	mDevice.cbSSystem->insertItem("ALSA ver. >=0.9",ssystem_asound09);
	QLabel* lDevice = new QLabel(i18n("Device"), corrMeterPage);
	mDevice.eDevice = new QLineEdit(mSState.sDevice, corrMeterPage);
	QLabel* lRate = new QLabel(i18n("Sampling Rate"), corrMeterPage);
	mDevice.isbRate = new KIntSpinBox(0, 96000, 400, mSState.uSampleRate, 10, corrMeterPage );
	mDevice.isbRate->setSuffix("Hz");
	QLabel* lInterval = new QLabel(i18n("Update Interval"), corrMeterPage);
	mDevice.isbInterval = new KIntSpinBox(5, 2000, 10, mSState.uIntervall, 10, corrMeterPage );
	mDevice.isbInterval->setSuffix("ms"); 	
	QLabel* lTrace = new QLabel(i18n("Persistence"), corrMeterPage);
	mDevice.isbTrace = new KIntSpinBox(100, 1000, 50, mSState.uTrace, 10, corrMeterPage );
	mDevice.isbTrace->setSuffix("ms"); 	
	QLabel* lAverage = new QLabel(i18n("Correlation Averaging Time"), corrMeterPage);
	mDevice.isbAverage = new KIntSpinBox(100, 1000, 50, mSState.uAverage, 10, corrMeterPage );
	mDevice.isbAverage->setSuffix("ms"); 	
}
/** colour settings for correlation meter */
void KCorrSetupDlg::addColourPage(){

	corrColourPage = addVBoxPage(i18n("Colours"),i18n("Colour Setup"),
  			KGlobal::instance()->iconLoader()->loadIcon( "colors", KIcon::NoGroup, KIcon::SizeMedium ));
	
	QGroupBox* sGBox = new QGroupBox(3, Qt::Horizontal, i18n("Scope Colours"),
									corrColourPage,"scopeBox");

	QLabel* lsRColour = new QLabel(i18n("Ray"),sGBox);	
	QLabel* lsBColour = new QLabel(i18n("Background"),sGBox);	
	QLabel* lsGColour = new QLabel(i18n("Grid"),sGBox);
	mColours.scopeRayColour = new KColorButton(sGBox);
	mColours.scopeBgColour = new KColorButton(sGBox);
	mColours.scopeGridColour = new KColorButton(sGBox);


	QGroupBox* mGBox = new QGroupBox(3, Qt::Horizontal,i18n("Meter Colours"),
									corrColourPage, "meterBox");
	QLabel* lmPColour = new QLabel(i18n("Pointer"),mGBox);	
	QLabel* lmBColour = new QLabel(i18n("Background"),mGBox);	 	
	QLabel* lmGColour = new QLabel(i18n("Grid"),mGBox);	 	
	mColours.meterPointerColour = new KColorButton(mGBox);
	mColours.meterBgColour = new KColorButton(mGBox);
	mColours.meterGridColour = new KColorButton(mGBox);
	
}
/** Just a test page without real function */
void KCorrSetupDlg::addVUPage(){

	corrVUPage = addPage(i18n("VU Meter"),i18n("VU Meter Settings"),
		KGlobal::instance()->iconLoader()->loadIcon( "vumeter", KIcon::User ));
 //,	UserIcon("vumeter"));
	QLabel* lmPDelay = new QLabel(i18n("Peak Delay"),corrVUPage);
	mVUMeter.isbPeakDelay = new KIntSpinBox(100, 5000, 500, mVUState.peakDelay, 10, corrVUPage );
	mVUMeter.isbPeakDelay->setSuffix("ms");

	
}


/** OK Button pressed */
void KCorrSetupDlg::slotOk(){

	slotApply();
	accept();
}
/** No descriptions */
void KCorrSetupDlg::slotApply(){

	switch( activePageIndex())
	{
		case page_device:
			
			switch(mDevice.cbSSystem->currentItem()){
				case 0:
					mSState.uSSystem = ssystem_asound09;
					break;
				case 1:
					mSState.uSSystem = ssystem_other;
					break;
				default:
					mSState.uSSystem = ssystem_asound09;
			}

			mSState.sDevice = mDevice.eDevice->text();
			mSState.uSampleRate = mDevice.isbRate->value();
			mSState.uIntervall = mDevice.isbInterval->value();
			mSState.uTrace =  mDevice.isbTrace->value();
			mSState.uAverage = mDevice.isbAverage->value();

			emit sampleDeviceChoice( mSState);
		break;
		case page_colour:
			mCState.scopeRayColour = mColours.scopeRayColour->color();
			mCState.scopeBgColour = mColours.scopeBgColour->color();
			mCState.scopeGridColour = mColours.scopeGridColour->color();
			mCState.meterPointerColour = mColours.meterPointerColour->color();
			mCState.meterBgColour = mColours.meterBgColour->color();
			mCState.meterGridColour = mColours.meterGridColour->color();
			emit colourChoice( mCState);
		break;
		case page_vu:
			mVUState.peakDelay = mVUMeter.isbPeakDelay->value();
			emit VUMeterChoice( mVUState );
		break;
	}
	

}
/** sets  values for the sample device page */
void KCorrSetupDlg::setSampleState(SSampleState state){

	mDevice.eDevice->setText(state.sDevice);
	mDevice.cbSSystem->setCurrentItem(state.uSSystem);
	mDevice.isbRate->setValue(state.uSampleRate);
	mDevice.isbInterval->setValue(state.uIntervall);
	mDevice.isbTrace->setValue(state.uTrace);
	mDevice.isbAverage->setValue(state.uAverage);

}

/** initializes all colour buttons */
void KCorrSetupDlg::setColourState(SColourState state){

	mColours.scopeRayColour->setColor(state.scopeRayColour);
	mColours.scopeBgColour->setColor(state.scopeBgColour);
	mColours.scopeGridColour->setColor(state.scopeGridColour);
	mColours.meterPointerColour->setColor(state.meterPointerColour);
	mColours.meterBgColour->setColor(state.meterBgColour);
	mColours.meterGridColour->setColor(state.meterGridColour);
}

/** initializes VU Meter Status */
void KCorrSetupDlg::setVUMeterState(SVUMeterState state){
	mVUMeter.isbPeakDelay->setValue(state.peakDelay);
}


/** sets default values for current page */
void KCorrSetupDlg::slotDefault(){

	switch( activePageIndex())
	{
		case page_device:	
			setSampleState( SSampleState() );
			mDevice.isbRate->setValue(mSState.uSampleRate );
			mDevice.isbInterval->setValue(mSState.uIntervall);
			mDevice.isbTrace->setValue(mSState.uTrace);
			mDevice.isbAverage->setValue(mSState.uAverage);
		break;
		case page_colour:	
			setColourState( SColourState() );		
			mColours.scopeRayColour->setColor(mCState.scopeRayColour);
			mColours.scopeBgColour->setColor(mCState.scopeBgColour);
			mColours.scopeGridColour->setColor(mCState.scopeGridColour);
			mColours.meterPointerColour->setColor(mCState.meterPointerColour);
			mColours.meterBgColour->setColor(mCState.meterBgColour);
			mColours.meterGridColour->setColor(mCState.meterGridColour);
		break;
		case page_vu:
			mVUMeter.isbPeakDelay->setValue(mVUState.peakDelay);
		break;		
	}

}
