/* **************************************************************************
                          kcorrsetupdlg.h  -  description
                             -------------------
    begin                : Sat Feb 17 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/

/** Setup Dialog Class for KCorrMeter */

/* **************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCORRSETUPDLG_H
#define KCORRSETUPDLG_H
#define KDE_NO_COMPAT

#include <qwidget.h>
#include <kdialogbase.h>

#include "optionstate.h"
class QVBox;
class QLineEdit;
class QComboBox;

class KIntSpinBox;
class KColorButton;

/**Preferences Dialog Class
  *@author M. Ritscher
  */

class KCorrSetupDlg : public KDialogBase  {
   Q_OBJECT
public:

	enum Page
	{
		page_device=0,
		page_colour,
		page_vu
	};

	KCorrSetupDlg(QWidget *parent=0, const char *name=0) ;
	~KCorrSetupDlg();
private: // Private methods
  /** adds a page with settings for the correlation meter scope */
  void addCorrMeterPage();
  /** colour settings for correlation meter */
  void addColourPage();
  /** VU Meter specific settings */
  void addVUPage();

private: //Private members

	struct SDeviceWidgets
	{
		QLineEdit* eDevice;
		QComboBox* cbSSystem;
		KIntSpinBox* isbRate;
		KIntSpinBox* isbInterval;
		KIntSpinBox* isbTrace;
		KIntSpinBox* isbAverage;
	};
	
	struct SColourWidgets
	{
		KColorButton* scopeRayColour;
		KColorButton* scopeBgColour;
		KColorButton* scopeGridColour;
		KColorButton* meterPointerColour;
		KColorButton* meterBgColour;
		KColorButton* meterGridColour;
	};
	
	struct SVUWidgets
	{
		KIntSpinBox* isbPeakDelay;
	};

	SDeviceWidgets mDevice;
	SColourWidgets mColours;
	SVUWidgets mVUMeter;
	
	QGrid* corrMeterPage;
  QVBox* corrColourPage;
  QFrame* corrVUPage;

  SSampleState mSState;
  SColourState mCState;
  SVUMeterState mVUState;


public slots: // Public slots
  /** No descriptions */
  virtual void slotApply();
  /** OK Button pressed */
  virtual void slotOk();
  /** initializes VU Meter Status */
  void setVUMeterState(SVUMeterState);
  /** sets both forground and background - colour */
  void setColourState(SColourState);
  /** sets  values for the sample device page */
  void setSampleState(SSampleState);
  /** sets default values for current page */
  void slotDefault();

signals: // Signals
  /** Update sample device settings */
  void sampleDeviceChoice( SSampleState );
  void colourChoice( SColourState );
  void VUMeterChoice(SVUMeterState);
};

#endif
