/* **************************************************************************
                          kcorrview.h  -  description
                             -------------------
    begin                : Sun Feb 18 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/
/** Main View for KCorrMeter */

/* **************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCORRVIEW_H
#define KCORRVIEW_H
#define KDE_NO_COMPAT

#include <qwidget.h>
#include "optionstate.h"
#include <errno.h>

//ALSA library
#define ALSA_PCM_NEW_HW_PARAMS_API
#include <alsa/asoundlib.h>

class KCorrSetupDlg;
class CorrelationMeter;
class CorrelationScope;
class MeterLabel;
class VUMeter;
class WaveView;

/**This is the main view for KCorrMeter.
It contains two child widgets. The 
correlation meter and the scope.

The timer event of this class will update
the sample buffer and signal the 
child widget every time it got new data.

It'll store relevant settings like
sample rate and colours.
  *@author M. Ritscher
  */

class KCorrView : public QWidget  {
   Q_OBJECT
public: 
	KCorrView(QWidget *parent=0, const char *name=0);
	~KCorrView();
  /** adjusting the timer interall */
  void setIntervall(unsigned int i);

  /** Retrieving new sample and refreshing screen */
  void timerEvent(QTimerEvent* tevt);
protected:	
  void	closeEvent(QCloseEvent* qcloseevent);
  /** overiding mouse events */
  void mousePressEvent(QMouseEvent *);
  		
public slots: //  slots
  /** Opens a Dialog which lets the user enter the Options */
  void showSetupDlg();
  /** updates sample device settings */
  void slotDeviceSettings(SSampleState state);
  /** sets for- and background colours for scope and meter */
  void slotColourSettings(SColourState);
  /** sets settings for VU Meter */
  void slotVUSettings(SVUMeterState);
  /** pops up a kontext menu */
  void rbPopup(QPoint);
  /** opens device and starts timer */
  void resume();
  /** stops timer and closes device */
  void halt();

private:
  /** Preferences Dialog */
  KCorrSetupDlg* setupDlg;
  /** Device Settings */
  unsigned int uSampleRate, uIntervall, uTrace, uAverage, uCaptureCount;

  QString sDevice;

  CorrelationMeter* cMeter;
  CorrelationScope* cScope;
  MeterLabel* cMeterScale;
  VUMeter* cVUMeter;
	WaveView* cWaveView;
  /** buffer for sampled data */
  unsigned char sBuf[65536];
  unsigned int buffer_size;

  /**  timer */
  int timer;
  /* asound 09 ALSA specific */
  snd_pcm_t *capture_handle;
  unsigned int ssystem;
	bool _deviceOpen;

private: // Private methods
  /** Opening and setting up DSP device  */
  bool openDevice();
  /** Shutting down DSP device */
  void closeDevice();
  /** No descriptions */
  void stop();
  /** No descriptions */
  void start();
  /** Opens the capturing device ALSA specific */
	int openALSADevice();
	/** for debugging only */
	void generateSignal();
signals: // Signals
  /** right mouse button was pressed */
  void rbPressed(QPoint);
  void started(bool);
};

#endif
