/***************************************************************************
                          meterlabel.cpp  -  description
                             -------------------
    begin                : Sun Apr 8 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "meterlabel.h"

#include <qlabel.h>

MeterLabel::MeterLabel(QWidget *parent, const char *name ) : QWidget(parent,name) {

  l[0] = new QLabel("0", this);
  l[0]->setAlignment(AlignHCenter | AlignTop);
  l[0]->adjustSize();

  setFixedHeight( l[0]->height() + 10);

  l[1] = new QLabel("1", this);
  l[1]->setAlignment(AlignHCenter | AlignTop);
  l[1]->adjustSize();

  l[2] = new QLabel("0.5", this);
  l[2]->setAlignment(AlignHCenter | AlignTop);
  l[2]->adjustSize();

  l[3] = new QLabel("-0.5", this);
  l[3]->setAlignment(AlignHCenter | AlignTop);
  l[3]->adjustSize();

  l[4] = new QLabel("-1", this);
  l[4]->setAlignment(AlignHCenter | AlignTop);
  l[4]->adjustSize();

}
MeterLabel::~MeterLabel(){
}

void MeterLabel::resizeEvent(QResizeEvent* qrevt) {
	
	int w = width();
	int w2 = w/2;
	/* labeling correlation meter */	
  l[0]->move( w2- l[0]->width() / 2, 5);

  l[1]->move(w-10 - l[1]->width() / 2, 5);

  l[2]->move((w-10 + w2 - l[2]->width()) / 2, 5);

  l[3]->move((10 + w2 - l[3]->width()) / 2, 5);

  l[4]->move(10 - l[4]->width() / 2, 5);

}

void MeterLabel::mousePressEvent(QMouseEvent *e){

	if(e->button() == RightButton)
		emit rbPressed(e->globalPos());
}


