/* **************************************************************************
                          optionstate.h  -  description
                             -------------------
    begin                : Thu Mar 1 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/

/* **************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _OPTION_STATE_H_
#define _OPTION_STATE_H_

#include <qstring.h>

/** Storage structure for sample device settings */
const char cDevice[]= "plughw:0,0";

enum SoundSystem{
	ssystem_asound09 =0,
	ssystem_other
};

struct SSampleState
{
  SSampleState()
  {
		uSSystem = ssystem_asound09;
		sDevice = cDevice;
		uSampleRate=22050;
		uIntervall=10;
		uTrace=100;
		uAverage=100;
  }

  unsigned int uSSystem;
	QString sDevice;
  unsigned int uSampleRate;
  unsigned int uIntervall;
	unsigned int uTrace;
	unsigned int uAverage;
};

/** Storage structure for colour settings */
struct SColourState
{
	SColourState()
	{
		scopeBgColour = Qt::black;
		scopeRayColour = Qt::red;
		scopeGridColour = Qt::gray;
		meterBgColour = Qt::black;
		meterPointerColour = Qt::red;
		meterGridColour = Qt::gray;
	}

	QColor scopeRayColour;
	QColor scopeBgColour;
	QColor scopeGridColour;
	QColor meterBgColour;
	QColor meterGridColour;
	QColor meterPointerColour;
};

/** Storage structure for VU Meter settings */
struct SVUMeterState
{
	SVUMeterState()
	{
		peakDelay = 500;
	}
	
	unsigned int peakDelay;

};

#endif
