/* **************************************************************************
                          vumeter.cpp  -  description
                             -------------------
    begin                : Sun Mar 18 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/

/* **************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "vumeter.h"

#include <qpainter.h>
#include <qfont.h>

#include <kmessagebox.h>
#include <kled.h>

#include <stdlib.h>
#include <math.h>

//#define PEAK_LED_WIDTH METER_HEIGHT/2
#define PEAK_LED_WIDTH 6
VUMeter::VUMeter(QWidget *parent, const char *name ) : QFrame(parent,name)
{

	setFixedHeight( METER_HEIGHT * 6);
	
	setBackgroundColor(Qt::black);
	setFrameStyle(WinPanel | Sunken);
	setLineWidth(2);
	setCaption("VU Meter");
	
	PeakLEDr = new KLed(Qt::red, KLed::Off, KLed::Flat, KLed::Rectangular, this,"ledr");
	PeakLEDr->setFixedSize(PEAK_LED_WIDTH,PEAK_LED_WIDTH);
	PeakLEDr->setDarkFactor(180);
	
	PeakLEDl = new KLed(Qt::red, KLed::Off, KLed::Flat, KLed::Rectangular, this,"ledl");
	PeakLEDl->setFixedSize(PEAK_LED_WIDTH,PEAK_LED_WIDTH);
	PeakLEDl->setDarkFactor(180);
	
	// initializing the maximum value the scale can have
	scaleMax = width()-2*X_OFFS-PEAK_LED_WIDTH;
	scaleFactor = 1;
	
	PeakLEDl->move(scaleMax,METER_HEIGHT );
	PeakLEDr->move(scaleMax,METER_HEIGHT*4 );
	
	dBTable = NULL;
	// set resolution 8 bit by default
	setResolution(8);
	setDelay(10);

	//create and prepare Buffer Device
	BufferDev = new QPixmap(scaleMax,METER_HEIGHT*2);
	prepareBufferDev();
	
	// initialize buffer	
	for(int i = 0; i<ConstEnd; i++)
	  t[i] = 0;

}

/** Desctructor */
VUMeter::~VUMeter(){

	if(dBTable)
		delete dBTable;

}
/** overwritten paintEvent 
	redraws the screen if necessary (e.g. after resize)
 */
void VUMeter::paintEvent(QPaintEvent*){

	int x, xmin, y, tf;
	
	y= (METER_HEIGHT * 2);
	xmin = X_OFFS+10;
	
	QPainter qp;

	if (qp.begin(this)) {
		drawFrame(&qp);

	/* draw the scale on the meter  */
		qp.setPen(Qt::gray);	
		QFont tFont("Courier",8);
		qp.setFont(tFont);

		tf =  AlignHCenter |AlignVCenter;

		qp.drawText(X_OFFS+2, y, 14, (int)(METER_HEIGHT * 1.8),tf,"dB");

		x =  scaleMax+X_OFFS - 60*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 16, METER_HEIGHT*2, tf, "-60");
		x =  scaleMax+X_OFFS - 50*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 16, METER_HEIGHT*2, tf, "-50");
		x =  scaleMax+X_OFFS - 40*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 16, METER_HEIGHT*2, tf, "-40");
		x =  scaleMax+X_OFFS - 30*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 16, METER_HEIGHT*2, tf, "-30");
		x =  scaleMax+X_OFFS - 25*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 16, METER_HEIGHT*2, tf, "-25");
		x =  scaleMax+X_OFFS - 20*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 16, METER_HEIGHT*2, tf, "-20");
		x =  scaleMax+X_OFFS - 15*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 16, METER_HEIGHT*2, tf, "-15");
		x =  scaleMax+X_OFFS - 10*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 16, METER_HEIGHT*2, tf, "-10");
		x =  scaleMax+X_OFFS - 7*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 10, METER_HEIGHT*2, tf, "-7");
		x =  scaleMax+X_OFFS - 5*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 10, METER_HEIGHT*2, tf, "-5");
		x =  scaleMax+X_OFFS - 3*scaleFactor;
		if( x > xmin)
			qp.drawText( x,y, 10, METER_HEIGHT*2, tf, "-3");
		x =  scaleMax-3;
		qp.drawText( x,y, 10, METER_HEIGHT*2, tf, "0");

		qp.end();
	}

   //draw current value of meters 
	if( t[cleft] != 0)
		bitBlt( this, X_OFFS, L_Y_OFFS, BufferDev, 0,0, t[cleft], METER_HEIGHT);
	if( t[cright] != 0)
		bitBlt( this, X_OFFS, R_Y_OFFS, BufferDev, 0,0, t[cright], METER_HEIGHT);
	
	//redras peak indicators
	if( t[counterl] > 0)
	{
		bitBlt( this, t[peakl]+X_OFFS-PEAK_WIDTH, L_Y_OFFS, BufferDev,t[peakl], 0, PEAK_WIDTH, METER_HEIGHT);
	}
	if(t[counterr] > 0)
	{
		bitBlt( this, t[peakr]+X_OFFS-PEAK_WIDTH, R_Y_OFFS, BufferDev,t[peakr], 0, PEAK_WIDTH, METER_HEIGHT);
	}
}

/** resize Event - overwirtten function 
	calculates new sizes for meters etc
*/

void VUMeter::resizeEvent(QResizeEvent* evt)
{
	// change buffer device before scaleMax otherwise
	// a new data might access a not existent
	// area in the buffer device
	BufferDev->resize((evt->size().width()- 2*X_OFFS-PEAK_LED_WIDTH), METER_HEIGHT*2 );
	prepareBufferDev();
	
	//calculate the max. value for meters
	//take frame and peak indicators into account
	scaleMax = evt->size().width() - 2*X_OFFS - PEAK_LED_WIDTH;

	//
	if(dBTable[0] != 0)
		scaleFactor = scaleMax/abs(dBTable[0]);
	else
		scaleFactor = 1;
  	
	PeakLEDl->move(evt->size().width()- X_OFFS-PEAK_LED_WIDTH,METER_HEIGHT );	
	PeakLEDr->move(evt->size().width()- X_OFFS-PEAK_LED_WIDTH,METER_HEIGHT*4 );	  	
	i35dB = scaleMax - 35 * scaleFactor;
	
	//do I have to call QFrame.resizeEvent here????
}

/** Prepares the Buffer Device from which
	a bitBlt operation is done to reflect
	the current level
			Paramters
			width
	args for future QtColour low, warn, high;
	alternatively an image could be provided which is copied into
	the buffer. Rescaling might be an issue though.
	Anyway, here is the place to make the meter themable. 
	You also could draw a gradient or whatever you like. E.g. LEDs
	but the algorithm doesn't support this. It would display fractions
	of LEDs     [xxx] [xxx] [x  ]
				[xxx] [xxx] [xx ]
	*/
void VUMeter::prepareBufferDev(void)
{
	
	QPainter qp;

	BufferDev->fill(Qt::black);
	qp.begin(BufferDev);
	qp.fillRect( 0 ,0, BufferDev->width()*6/10 ,METER_HEIGHT, Qt::green);    		
	qp.fillRect( BufferDev->width()*6/10, 0, BufferDev->width()*9/10, METER_HEIGHT, Qt::yellow);
	qp.fillRect( BufferDev->width()*9/10, 0, BufferDev->width(), METER_HEIGHT, Qt::red);
	qp.end();
	
}

/**
	sets Resolution of Sampling device e.g. 8bit 16bit
*/
void VUMeter::setResolution(int res)
{

	int tableSize = (int) pow(2,res)>>1;
	
	setMinimumWidth(tableSize + X_OFFS*3);
	if(dBTable)
		delete dBTable;
		
	dBTable = new int[tableSize];
	
	// prevents us from using 
	// "log((double i)/ (double)(tableSize -1));"
	// below
	double tempSize = tableSize-1;	
	
	// filling luckup table converting input values to dB
	// max input value equals 0dB  - 0 equals -Inf
	for(int i=1; i < tableSize; i++)
	{
		dBTable[i] = (int) (20.0 * log10( (double)i/ tempSize ));
	}
	
	// a input value of 0 won't show up on our meter
	dBTable[0] = dBTable[1]-1;
	
	// calculate the factor needed for converting
	// sample value to screen cooardinates
	scaleFactor = scaleMax/abs(dBTable[0]);
	
	// calculate threshold for peaks
	i35dB = scaleMax - 35 * scaleFactor;
	
}


/** Input for new sampled data. 
	recalculates new current value for meters
	deals with peak indicators too
	(main function)
	
	buffer - buffer for sampled data
	uDataStart - start of the data inside the ring buffer
	uDataEnd   - end of the data inside the ring buffer
	uBuffer_Size - buffer's size
*/
void VUMeter::newData(const unsigned char *buffer,
										unsigned int uDataStart,
										unsigned int uDataEnd,
										unsigned int uBuffer_Size){
																	
	unsigned int uDots = (uDataEnd >= uDataStart ? uDataEnd - uDataStart : uDataEnd + uBuffer_Size - uDataStart) / 2;																

	unsigned int i,k, r, l;
	
	t[cleft]=0;
	t[cright]=0;
	
	if(t[counterPeakr]>0)
	{
		t[counterPeakr]--;
	 	if(t[counterPeakr]==0)
			PeakLEDr->off();
	}
	if(t[counterPeakl]>0)
	{
		t[counterPeakl]--;
		if(t[counterPeakl]==0)
			PeakLEDl->off();
	}
	
	for (i = 0; i < uDots; i++) {

		k = (uDataStart + i * 2) % uBuffer_Size;

		r = (int)(buffer[k]  - 128);
		t[cright] += r*r;
		if( abs(r) > 120 )
		{
		/* alternativly the peak LEDs could be switched on 
		   if the level hits the threshold(maximum - 0dB)
		   for a minimum number of time in a row. 
		   This probably would be a better clipping
		   indicator. And this is, what they are meant to be.
          1234
         _____
        /     \
       /       \        /
                \      /
                 \____/
                  1234
		*/
			PeakLEDr->on();
			t[counterPeakr]=50;
		}	
		l = (int)(buffer[k+1]- 128);
		t[cleft] += l*l;
		if( abs(l) > 120 )
		{
			PeakLEDl->on();
			t[counterPeakl]=50;
		}	
	}


	t[cleft]  = (int) sqrt( t[cleft] / uDots);
	t[cright] = (int) sqrt( t[cright]/ uDots);

	t[aver] = t[cleft];
	// convert these value to dB
	t[db] = t[cleft] = dBTable[t[cleft]];
	t[cright] = dBTable[t[cright]];

	// convert dB valuse to screen coordinates
	t[cleft] = scaleMax - scaleFactor* abs(t[cleft]);
	t[cright] = scaleMax - scaleFactor* abs(t[cright]);
	
/***************************************************
	|F|        --------scaleMax---------        |F|
	|F|-X_OFFS-#########################-X_OFFS-|F|
	|F|                                         |F|
     0                                  width()
****************************************************/	

	if(t[cleft] < 0)
		KMessageBox::information(this,"negativ");

/* lllllllllllllllllllllll
	drawing LEFT channel
   lllllllllllllllllllllll
*/

	if( t[counterl] == 0)
	{// ereasing peak
 	  bitBlt( this, t[peakl]+X_OFFS-PEAK_WIDTH, L_Y_OFFS,
 	  				BufferDev, 0, METER_HEIGHT, PEAK_WIDTH, METER_HEIGHT);
 	  t[peakl] = 0;
	  t[counterl] --;
	}
 	
	// increasing vu bar length - current value higher than previous
	if(t[cleft] > t[tleft] )
	{
  		bitBlt( this, t[tleft]+X_OFFS, L_Y_OFFS,
  					BufferDev, t[tleft], 0,t[cleft]-t[tleft], METER_HEIGHT);
	 	t[tleft] = t[cleft];
		if((t[cleft] >= t[peakl]) && (t[cleft] > i35dB))
		{
			t[peakl] = t[cleft];
			t[counterl] = pDelay;
		}else if(t[counterl] > 0)
		{
			t[counterl]--;
		}
	}else if(t[cleft] < t[tleft])
	{ //decreasing vu bar length - current value smaller than previous

	// peak indicator has been ereased
		if( t[counterl] < 0)
     	{
			//if previous level exceeded the
			//peak treshold paint a new one
			if(t[tleft] > i35dB)
			{	
				t[peakl] = t[tleft];
				t[counterl] = pDelay;
			}
			}else{
				t[counterl]--;
			}
    	
			// if counter equals delay, we
			// erease the bar area except the
			// peak
    	if(t[counterl] == pDelay-1)
    	{
			//"drawing" peak
			if( (t[tleft]-t[cleft]) > PEAK_WIDTH)
			{
				bitBlt( this, t[cleft]+X_OFFS, L_Y_OFFS,
	      	 				BufferDev, 0, METER_HEIGHT, t[tleft]-t[cleft]-PEAK_WIDTH, METER_HEIGHT);
			}
  		}else
		{
			if( (t[peakl]-t[cleft]) > PEAK_WIDTH )
				bitBlt( this, t[cleft]+X_OFFS, L_Y_OFFS,
    	   					BufferDev, 0, METER_HEIGHT, t[tleft]-t[cleft], METER_HEIGHT);
		}	

    	t[tleft] = t[cleft];
    	
	}else if( (t[counterl]>0))
 	{
		if(t[cleft] >= t[peakl])
			t[counterl]=pDelay;
		else
			t[counterl]--;
	}
 		


/* 	rrrrrrrrrrrrrrrrrrr
	  RIGHT  channel
	rrrrrrrrrrrrrrrrrrr
*/

	if( t[counterr] == 0)
	{// ereasing peak
		bitBlt( this, t[peakr]+X_OFFS-PEAK_WIDTH, R_Y_OFFS,
 	  				BufferDev, 0, METER_HEIGHT, PEAK_WIDTH, METER_HEIGHT);
		t[peakr] = 0;
		t[counterr] --;
	}
 	
	// increasing vu bar
	if(t[cright] > t[tright] )
	{
		bitBlt( this, t[tright]+X_OFFS, R_Y_OFFS,
  					BufferDev, t[tright], 0,t[cright]-t[tright], METER_HEIGHT);
		t[tright] = t[cright];
		if((t[cright] >= t[peakr]) && (t[cright] > i35dB))
		{
			t[peakr] = t[cright];
			t[counterr] = pDelay;
		}else if(t[counterr] > 0)
		{
			t[counterr]--;
		}
	}else if(t[cright] < t[tright])
	{ //decreasing vu bar

		// peak indicator has been ereased
		if( t[counterr] < 0)
		{
			//if previous level exceeded the
			//peak treshold paint a new one
			if(t[tright] > i35dB)
			{	
				t[peakr] = t[tright];
				t[counterr] = pDelay;
			}
		}else{
			t[counterr]--;
		}

		// if counter equals delay, we
		// erease the bar area except the
		// peak
		if(t[counterr] == pDelay-1)
		{
			//"drawing" peak
			if( (t[tright]-t[cright]) > PEAK_WIDTH)
			{
				bitBlt( this, t[cright]+X_OFFS, R_Y_OFFS,
						BufferDev, 0, METER_HEIGHT, t[tright]-t[cright]-PEAK_WIDTH, METER_HEIGHT);
			}
  		}else
		{
			if( (t[peakr]-t[cright]) > PEAK_WIDTH )
				bitBlt( this, t[cright]+X_OFFS, R_Y_OFFS,
			BufferDev, 0, METER_HEIGHT, t[tright]-t[cright], METER_HEIGHT);
		}

		t[tright] = t[cright];
    	
	}else if( (t[counterr]>0))
	{
		if(t[cright] >= t[peakr])
			t[counterr]=pDelay;
		else
			t[counterr]--;
	}
 		

	if(t[cright] > t[tright] )
	{
		bitBlt( this, t[tright]+X_OFFS, R_Y_OFFS, BufferDev, t[tright], 0, t[cright]-t[tright], METER_HEIGHT);
		t[tright] = t[cright];

		if((t[cright] > t[peakr]) && (t[cright] > i35dB))
		{
			t[peakr] = t[cright];
			t[counterr] = pDelay;
		}
	}
	else if(t[cright] < t[tright])
	{
    	// deleting
		bitBlt( this, t[cright]+X_OFFS, R_Y_OFFS, BufferDev, 0, METER_HEIGHT, t[tright]-t[cright], METER_HEIGHT);
		t[tright] = t[cright];
 		
		//peak
		if(t[counterr]!=0)
		{
			bitBlt( this, t[peakr]+X_OFFS-PEAK_WIDTH, R_Y_OFFS, BufferDev,t[peakr], 0, PEAK_WIDTH, METER_HEIGHT);
			t[counterr]--;
		}else
		{ //ereasing peak
			bitBlt( this, t[peakr]+X_OFFS-PEAK_WIDTH, R_Y_OFFS, BufferDev,0, METER_HEIGHT, PEAK_WIDTH, METER_HEIGHT);
			t[peakr] = t[cright];
			t[counterr] = pDelay;
		}
	}


/* just a reminder how to use bitBlt to not to have to check
   doc all the time...
void bitBlt (QPaintDevice * dst, int dx, int dy,
const QPaintDevice * src, int sx, int sy, int sw, int sh,
Qt::RasterOp rop, bool ignoreMask)
*/

}

/** resetting Peak LEDs */
void VUMeter::mousePressEvent(QMouseEvent *e){

	if(e->button() == RightButton)
		emit rbPressed(e->globalPos());
	else
	{
		PeakLEDr->off();
		PeakLEDl->off();
		t[counterPeakr]=0;
		t[counterPeakl]=0;
	}
}
/** adjusts delay of peak indicator */
void VUMeter::setDelay( int d){

  // adjustment (d+1) is needed as
  // we test for pDelay-1 in newData
	(d==0)?pDelay = -1:pDelay = d+1;
	t[counterl] = 0;
	t[counterr] = 0;
}
