/***************************************************************************
                          vumeter.h  -  description
                             -------------------
    begin                : Sun Mar 18 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VUMETER_H
#define VUMETER_H
#define KDE_NO_COMPAT

#include <qframe.h>
#include <qpen.h>
#include <qpixmap.h>

class KLed;

#define METER_HEIGHT 6
#define L_Y_OFFS METER_HEIGHT
#define R_Y_OFFS METER_HEIGHT *4
#define X_OFFS 5
#define PEAK_WIDTH 3

enum MeterConsts{
	tleft,
	tright,
	cleft,
	cright,
	peakl,
	peakr,
	counterl,
	counterr,
	counterPeakl,
	counterPeakr,
	aver,
	db,
	ConstEnd

};

/**Displays level of captuered audio signal
  *@author M. Ritscher
  */

class VUMeter : public QFrame  {
   Q_OBJECT
public: 
	VUMeter(QWidget *parent=0, const char *name=0);
	~VUMeter();
	void newData(const unsigned char *buffer,
																	unsigned int uDataStart,
																	unsigned int uDataEnd,
																	unsigned int uBuffer_Size);	

/** sets resolution of meter scale
		Parameters:
			res - sampling resolution of input device
						e.g. 8bit 16bit
	*/																	
	void setResolution(int res);
  /** adjusts delay of peak indicator */
  void setDelay(int d);
	
private: // private functions																
	void prepareBufferDev(void);
	
private: // Private attributes
  QPixmap* BufferDev;
  
  KLed* PeakLEDr, *PeakLEDl;
  int t[ConstEnd];
  int* dBTable;
  int scaleMax, scaleFactor, i35dB;
  /** n times (call newDate) -> peakDelay */
  int pDelay;
protected: // Protected methods
  /** No descriptions */
  void paintEvent(QPaintEvent*);
  virtual void resizeEvent(QResizeEvent* ev);
  void mousePressEvent(QMouseEvent *);
signals: // Signals
  /** right mouse button was pressed */
  void rbPressed(QPoint);
};

#endif
