/**************************************************************************
 *   Copyright (C) 2006 by Meinhard Ritscher   *
 *   unreachable@gmx.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "waveview.h"

#include <qcolor.h>
#include <qpainter.h>

WaveView::WaveView(QWidget *parent, const char *name) : QWidget(parent,name)
{
	setMinimumSize(260, 136);
	setBackgroundColor(QColor(0,20,40));
}


WaveView::~WaveView()
{
}


void WaveView::newData(const unsigned char *buffer,
																	unsigned int uDataStart,
																	unsigned int uDataEnd,
																	unsigned int uBuffer_Size){

	int bufferLength = 0;

	if( uDataStart <= uDataEnd )
		bufferLength = uDataEnd - uDataStart;
	else
		bufferLength = uBuffer_Size - uDataStart + uDataEnd;
	bufferLength = bufferLength >> 1;  // da rechter und linker Kanal

	QPainter qp;
	int oldY = 0;

	// Set scale to one. This ignores points at the end
	// we just don't paint them
	float scale = 1.0;
	int drawEnd = _w;
	//and cut the rest of the points
	// for windows with width less than 
	// number of points to render !!

	// in case we have less captured points 
	// we set the scale so it we can fill
	// the complete width of the widget
	if(bufferLength < _w){
		scale =  (float) _w / (bufferLength -1 );
		drawEnd = bufferLength;
	}

  if (qp.begin(this)) {
		qp.fillRect(0,0,_w,height(), QColor(0,20,40));
		qp.translate( 0, _h2 );
		qp.setPen(QColor(146,146,146));
		qp.drawLine(0,0,_w,0);

		// Right channel
		qp.setPen(QColor(200,140,0));
		oldY = (buffer[  (0+uDataStart)*2 % uBuffer_Size  ]-128 );
		if(_h2 < 130) oldY = oldY >> 1;
		qp.drawPoint(0, oldY );
		int newY = 0;
		for(int i=1; i<drawEnd; i++){
			newY = (buffer[  (i+uDataStart)*2 % uBuffer_Size  ]-128 );
			if(_h2 < 130) newY = newY >> 1;
			qp.drawLine( (int)((i-1)*scale), oldY, (int)(i*scale), newY);
			oldY = newY;
		}

		// left channel
		qp.setPen(QColor(20,180,20));
		oldY = (buffer[  (0+uDataStart)*2 % uBuffer_Size + 1  ]-128 );
		if(_h2 < 130) oldY = oldY >> 1;
		qp.drawPoint(0, oldY );
		newY = 0;
		for(int i=1; i<drawEnd; i++){
			newY = (buffer[  (i+uDataStart)*2 % uBuffer_Size + 1 ]-128 );
			if(_h2 < 130) newY = newY >> 1;
			qp.drawLine( (int)((i-1)*scale), oldY, (int)( i*scale), newY);
			oldY = newY;
		}

		qp.end();
	}

}

void WaveView::paintEvent(QPaintEvent* qpevt) {

	QPainter qp;
	if(qp.begin(this)){
		qp.translate(0, _h2);
		qp.setPen(QColor(146,146,146));
		qp.drawLine(0,0,width(),0);

// 		qp.drawText(3,-100, "0,-100");
// 		qp.drawText(3,115, "0,100");
// 		
// 		qp.drawText(200,-100, "200,-100");
// 		qp.drawText(200,115, "200,100");

		qp.end();
	}
}

void WaveView::resizeEvent(QResizeEvent* qrevt) {
	QWidget::resizeEvent(qrevt);
	_h2 = height() >> 1;
	_w = width();
}
