/*
 * KDE Radio Station
 * Copyright (C) 2003, 2004 Josef Spillner <spillner@kde.org>
 * Published under GNU GPL conditions.
 */

#include "kradiopart.h"
#include "stationlist.h"
#include "config.h"

#include <kinstance.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <qwidget.h>

extern "C"
{
	void *init_libpyrokomponent()
	{
		return new KRadioFactory();
	}
};

KInstance *KRadioFactory::s_instance = 0L;

KRadioFactory::KRadioFactory()
{
}

KRadioFactory::~KRadioFactory()
{
	if (s_instance)
	{
		delete s_instance->aboutData();
		delete s_instance;
	}
	s_instance = 0L;
}

QObject *KRadioFactory::createObject(QObject *parent, const char *name, const char*, const QStringList& )
{
	QObject *obj = new KRadioPart((QWidget*)parent, name);
	emit objectCreated(obj);
	return obj;
}

KInstance *KRadioFactory::instance()
{
	if (!s_instance) s_instance = new KInstance( aboutData() );
	return s_instance;
}

KAboutData *KRadioFactory::aboutData()
{
	KAboutData *about = new KAboutData("kradiopart",
		I18N_NOOP("KDE Radio Station"),
		VERSION,
		I18N_NOOP("KPart for the internet radio station browser"),
		KAboutData::License_GPL,
		I18N_NOOP("Copyright (C) 2003, 2004 Josef Spillner"),
		QString::null,
		"http://kderadiostation.coolprojects.org/",
		"spillner@kde.org");

	return about;
}

KRadioPart::KRadioPart(QWidget *parent, const char *name)
: KParts::ReadOnlyPart(parent, name)
{
	setInstance(KRadioFactory::instance());

	m_widget = new StationList(parent);
	//m_widget->setFocusPolicy(QWidget::ClickFocus);
	setWidget(m_widget);

	/*m_extension = new KRadioBrowserExtension(this);*/
}

KRadioPart::~KRadioPart()
{
	closeURL();
}

bool KRadioPart::openFile()
{
	//m_widget->open(m_file);
	return true;
}

QWidget *KRadioPart::view()
{
	return m_widget;
}

QStringList KRadioPart::metaservers(bool writeable)
{
	return dynamic_cast<StationList*>(m_widget)->metaservers(writeable);
}

void KRadioPart::addStation(QString metaserver, QString stream, QString uri,
	QString location, QString speed, QString style, QString type)
{
	dynamic_cast<StationList*>(m_widget)->addStation(metaserver, stream, uri, location, speed, style, type);
}

/*KRadioBrowserExtension::KRadioBrowserExtension(KRadioPart *parent)
: KParts::BrowserExtension(parent, "KRadioBrowserExtension")
{
}

KRadioBrowserExtension::~KRadioBrowserExtension()
{
}*/


