/*
 * KDE Radio Station
 * Copyright (C) 2003, 2004 Josef Spillner <spillner@kde.org>
 * Published under GNU GPL conditions.
 */

#ifndef KRADIO_PART_H
#define KRADIO_PART_H

/*#include <kparts/browserextension.h>*/
#include <kparts/part.h>
#include <klibloader.h>

class KAboutData;
class KInstance;
/*class KRadioBrowserExtension;*/
//class StationList;

class KRadioFactory : public KLibFactory
{
	Q_OBJECT
	public:
		KRadioFactory();
		virtual ~KRadioFactory();

		virtual QObject *createObject(QObject* parent = 0, const char* name = 0,
			const char *classname = "QObject", const QStringList &args = QStringList());
		static KInstance *instance();
		static KAboutData *aboutData();

	private:
		static KInstance *s_instance;
};

class KRadioPart: public KParts::ReadOnlyPart
{
	Q_OBJECT
	public:
		KRadioPart(QWidget *parent, const char *name = NULL);
		virtual ~KRadioPart();

		QWidget *view();

		QStringList metaservers(bool writeable);
		void addStation(QString metaserver, QString stream, QString uri,
			QString location, QString speed, QString style, QString type);

	protected:
		virtual bool openFile();

	private:
		/*KRadioBrowserExtension *m_extension;*/
		QWidget *m_widget;
};

/*class KRadioBrowserExtension : public KParts::BrowserExtension
{
	Q_OBJECT
	friend class KRadioPart;
	public:
		KRadioBrowserExtension(KRadioPart *parent);
		virtual ~KRadioBrowserExtension();
};*/

#endif
