/*
 * KDE Radio Station
 * Copyright (C) 2003 Josef Spillner <spillner@kde.org>
 * Published under GNU GPL conditions.
 */

#ifndef OPTIONS_H
#define OPTIONS_H

#include <kdialogbase.h>
#include <qstringlist.h>
#include <qmap.h>

class KPushButton;
class QComboBox;
class QCheckBox;

class OptionsDialog : public KDialogBase
{
	Q_OBJECT

	public:
		OptionsDialog( QWidget *parent, const char *name = 0 );

	public slots:
		void slotNewMetaserver(QString uri);
		void slotStations();
		void slotUpdateMetaservers();
		void slotUpdateStations();
		void slotOk();

	signals:
		void signalUpdateMetaservers();
		void signalUpdateStations();
		void signalGrouping();

	private slots:
		void slotViewMetaservers();

	private:
		void load();

		QStringList metaservers;
		KPushButton *updateServers, *updateStations;
		QComboBox *outputPlugin, *listMode, *stationUpdateCombo;
		QString oldgrouping;
		QCheckBox *useCache;
		QMap<QString, QString> specmap;
};

#endif
