/***************************************************************************
 *   Copyright (C) 2004 by Oded Shimon                                     *
 *   ods15@ods15.dyndns.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "wcon.h"
#include "process.h"
#include "main.h"

#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>

#include <qsignal.h>
#include <qapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <qobjectlist.h>
#include <qregexp.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qlabel.h>
#include <knuminput.h>
#include <kurlrequester.h>
#include <qslider.h>
#include <qprogressbar.h>
#include <qbuttongroup.h>
#include <kmessagebox.h>
#include <qradiobutton.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qtextbrowser.h>
#include <qwidgetstack.h>
#include <qgroupbox.h>
#include <qtextedit.h>
#include <qtimer.h>
#include <qlayout.h>
#include <khtmlview.h>
#include <khtml_part.h>
#include <ktempdir.h>

#define QCB_PATTERN      "^[^_]+_([^_]+)_auto_1.._(.+)$"
#define VF_PATTERN       "^([^_]+)_vf_auto_"
#define DATA_PATTERN(a)  QString("^([^_]+)_" + a + "_auto_..1_(.+)$").latin1()
#define ALL_DATA_PATTERN "^([^_]+)_[^_]+_auto_.1._"

/*!
 @a =============================================================

 * @fn TODOS

> 1) forward/back buttons does not functions well, they just show the next
> frame for a bit, and returns to the keyframe while frame counter correctly
> increments...
Well, MPlayer can only seek to keyframes, so those simply do not work right...
> 2) we need buttons to go to the next/prev kframe
Thats pretty impossible, Kmenc15 knows nothing about the file, especially what 
keyframes are where.. All it can do is tell MPlayer to go here and there.
Actually, I just thought of an idea how this might be possible... We'll see.
> 3) we shortcut keyboard equals to mplayer and plus, for navigating in the
> file
That's a great idea! Thank you.
> 4) we need an indicator of current type frame (K, P and so on)
Pretty impossible for the same reason, Kmenc15 really doesn't know anything 
about the file it's playing, this is all up to MPlayer.
> 5) we need an indicator of current time on the right of current frame
I'm thinking the next version will not have the frame number at all, and will 
only be time based. This is because in MPEG's, "there is no frame", there is 
only time. Read my previous e-mail.
> 6) save the last option in a .kmencrc file
What do you mean?.. Did you notice the last 2 buttons in the 'Encode' tab in 
Kmenc15? It can save sessions and projects.
> 7) make the audio copy option default (like video process option)
Well, that's not too much of a problem, and yeah, I think I'll do it for 
consistency's sake.

 **** TODO make ovc layouted, some people with fonts are complaining
 *** change QFile in templates to QTextstream
 *** Idx changes length
 ** queueing
 ** croptedect
 ** make wizard - hmm, maybe not.
 * change picture to icon theme. KIconLoader
 * idx changes length etc. ... ? - no, it doesn't, because the header stays the same...
 * make main window resizeable... - practicly done. maybe cut/merge win should be fixed
 * change make_command and connect() and template etc. to QWidget - finishing up
 * enum-erate ovc and vf etc. - small change.
 * finish other options - including audio desync, and buttons working... - big one
 * make direct stream copy work - oh boy...
 ** tab order - err, seriously?
 * tooltips - sigh
 * mplayer not dying on exit - seems fixed...
 * preview tab - I think I'll just dump this
 ** seperate audio file - hmm...
 * support for mpeg's - big one..
 * allow deleting sections from files - annoying, cant think of design

 @a =============================================================
   
 * @fn NOTES
 
 * TYPES: qsb, qcb, qcmb, kdsb, qle
 * GROUPS: raw, nuv, divx4, lavc, xvid, mp3lamep, mp3lamem, alavc, vf
 *
 *                       TYPE | GROUP | "auto" | ?qcb? | ?data? | ?com_data? | text
 *                     =============================================================
 * QCB for enabling:      qcb | GROUP | "auto" |   ""  | ?data? |     ""     | text
 * VF for changing:      TYPE |  "vf" | "auto" | ?whatever?
 * 
 * @a ^[^_]+_([^_]+)_auto_1.._(.+)$       -     for connecting items with their qcb
 *                                               connected with: @a qcb_\1_auto_01?0_\2
 * 
 * @a ^([^_]+)_vf_auto_                   -     for connecting vf items with refresh
 *                                              use correct types and SIGNALs
 * 
 * @a ^([^_]+)_lavc_auto_.11_(.+)$        -     for adding data items to command line
 *                                              check their enables as necessary!
 *
 * @a ^([^_]+)_lavc_auto_.1._             -     for template saving.
 
 @a =============================================================

 * @fn CHANGES

 @a v0.04
 * New native MEncoder file merging
 * Help for main buttons

 @a v0.03
 * Major speed optimizations, far less processes necessary for encode
 * Almsot complete code re-write, more modular
 * More robustness against bad user input
 * Possibly more portability
 * Small bug fixes
 * Makfile improoved

 @a v0.02
 * Window is now Resizable.
 * Filter crop imporved.
 * Added startup logo.
 * Save/load template and session.
 * General addons and fixes.
 * Video filters Help added
 * My own hand made Makefile, no m4.

 @a v0.01
 * Initial release

 @a =============================================================
!*/

static class choverFilter : public QObject {
  kmenc15 * mainWin;
  const QString & findHelp(QObject * tmp) {
    static QString tmplist [] = {
      i18n("Move 1 frame forward"),
      i18n("Move 1 frame backward"),
      i18n("Move forward 10 frames"),
      i18n("Move backward 10 frames"),
      i18n("Move to start of clipped area"),
      i18n("Move to end of clipped area"),
      i18n("Currently displayed frame"),
      i18n("Set begginning of clipped area"),
      i18n("Set end of clipped area"),
      i18n("Switch to previous file"),
      i18n("Switch to next file"),
      i18n("Append a file after this one"),
      i18n("Close this file"),
      i18n("Generate Idx for this file"),
      i18n("Cancel Idx creation"),
      i18n("Delete Idx for this file")
    };
    for (uint i = 0; helpObjectList()[i]; i++) if (helpObjectList()[i] == tmp) return tmplist[i];
    return QString::null;
  }
public:
  choverFilter(kmenc15 * tmp) : mainWin(tmp) {}
  bool eventFilter(QObject * obj, QEvent * ev) {
    static QString before = QString::null;
    if (ev->type() == QEvent::Leave || ev->type() == QEvent::Enter && before != QString::null) {
      mainWin->ql_source_status->setText(before);
      before = QString::null;
    }
    //if (!((QWidget *)obj)->isEnabled()) return false;
    if (ev->type() == QEvent::Enter && findHelp(obj) != QString::null) {
      before = mainWin->ql_source_status->text();
      mainWin->ql_source_status->setText(findHelp(obj));
    }
    return false;
  }
  QObject ** helpObjectList() {
    static QObject * tmplist [] = {
      mainWin->qpb_source_prev,
      mainWin->qpb_source_next,
      mainWin->qpb_source_fastnext,
      mainWin->qpb_source_fastprev,
      mainWin->qpb_source_start,
      mainWin->qpb_source_end,
      mainWin->qsb_source_frame,
      mainWin->qpb_source_setbegin,
      mainWin->qpb_source_setend,
      mainWin->qpb_source_prevfile,
      mainWin->qpb_source_nextfile,
      mainWin->qpb_source_open,
      mainWin->qpb_source_close,
      mainWin->qpb_source_idx,
      mainWin->qpb_source_cancelidx,
      mainWin->qpb_source_delidx,
      0
    };
    return tmplist;
  }
} * hoverFilter = 0;

void kmenc15::init() {
  setMinimumSize(800,0);
  resize(806,747);

  qsv_lavc->addChild(qgb_lavc_scroll);

  setCaption(caption().append(" v") + version);

  ql_source_pic->setPixmap(QPixmap(myembed_findData("images/kmenc15.jpg")));

  tempDirectory = new KTempDir();
  source_preview = new MyProcess(this, "source_prview");
  tempDirectory->setAutoDelete(true);
  mainprogs.setAutoDelete(true);
  files.setAutoDelete(true);

  kur_wdir->setURL(tempDirectory->name());
  kur_ofile->setURL(QDir::homeDirPath() + "/test.avi");

  khp_vf_help->view()->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)2,(QSizePolicy::SizeType)2, 0, 0, khp_vf_help->view()->sizePolicy().hasHeightForWidth()));
  
  qtw_all->setTabEnabled(qtw_all->page(4),false);

  qws_vf->raiseWidget(3);

  QWidget * tmphide[] = { l_source_line_left_1,  l_source_line_left_2,  l_source_line_left_3,  l_source_line_left_4,
                                                 l_source_line_2,       l_source_line_3,       l_source_line_4,
                          l_source_line_right_1, l_source_line_right_2, l_source_line_right_3, l_source_line_right_4,
                          qpb_source_cancelidx, qpb_source_idxprogress, qpb_source_delidx,     khp_vf_help->view(), 0
  };

  for (uint i = 0; tmphide[i]; i++) tmphide[i]->setHidden(true);

  KDoubleSpinBox * tmpkdsb[] = {
    kdsb_vf_auto_000_unsharp_luma_strength,   kdsb_vf_auto_100_dint_level,       kdsb_vf_auto_100_dint_sense,
    kdsb_vf_auto_100_hue_hue,                 kdsb_vf_auto_100_hue_saturation,   kdsb_lavc_auto_111_lmax,
    kdsb_lavc_auto_111_lmin,                  kdsb_lavc_auto_111_vqblur,         kdsb_lavc_auto_111_vqcomp,
    kdsb_general_auto_110_ofps,               kdsb_vf_auto_000_sab_blur,         kdsb_vf_auto_000_sab_pf,
    kdsb_vf_auto_000_sab_threshold,           kdsb_vf_auto_000_smartblur_radius, kdsb_vf_auto_000_smartblur_strength,
    kdsb_vf_auto_000_unsharp_chroma_strength, kdsb_general_auto_110_desync,      0
  };

  double tmpkdsbvalues[] = {
    2, -1.5, 1.5, .1, -.5,                    2, 0., 1., .1, .15,                2, 0., 1., .1, .1,
    2, -180., 180., 1., 0.,                   2, -5., 5., .1, 1.,                2, .01, 255., 1., 31.,
    2, .01, 255., 1., 2.,                     2, 0., 1., .1, .5,                 2, -100., 100., .1, .5,
    3, 0., 1000., 1., 25.,                    2, .1, 4., .1, 1.,                 2, .1, 2., .1, 1.,
    2, .1, 100., 1., 5.,                      2, .1, 5., .1, 1.,                 2, -1., 1., .1, .5,
    2, -1.5, 1.5, .1, -.5,                    3, -1000., 1000., .01, 0.
  };


  for (uint i = 0; tmpkdsb[i]; i++) {
    tmpkdsb[i]->setPrecision(int(tmpkdsbvalues[i*5]));
    tmpkdsb[i]->setMinValue(tmpkdsbvalues[i*5+1]);
    tmpkdsb[i]->setMaxValue(tmpkdsbvalues[i*5+2]);
    tmpkdsb[i]->setLineStep(tmpkdsbvalues[i*5+3]);
    tmpkdsb[i]->setValue(tmpkdsbvalues[i*5+4]);
  }

  QRegExp tmp(QCB_PATTERN);
  QObjectList * tmplist = queryList(0, tmp.pattern(), true, true);

  for (uint i = 0; i < tmplist->count(); i++) {
    tmp.search(tmplist->at(i)->name());
    QObject * tmpobject = child(QString("qcb_" + tmp.cap(1) + "_auto_000_" + tmp.cap(2)).latin1());
    if (!tmpobject) tmpobject = child(QString("qcb_" + tmp.cap(1) + "_auto_010_" + tmp.cap(2)).latin1());
    if (tmpobject) connect(tmpobject, SIGNAL(toggled(bool)), tmplist->at(i), SLOT(setEnabled(bool)));
    else fprintf(stderr,"CRITICAL error at connecting objects.\n");

  }

  tmp.setPattern(VF_PATTERN);
  tmplist = queryList(0, tmp.pattern(), true, true);

  for (uint i = 0; i < tmplist->count(); i++) {
    tmp.search(tmplist->at(i)->name());
    if (tmp.cap(1) == "qsb")  connect(tmplist->at(i), SIGNAL(valueChanged(int)),           this, SLOT(callshowvf()));
    if (tmp.cap(1) == "qcb")  connect(tmplist->at(i), SIGNAL(toggled(bool)),               this, SLOT(callshowvf()));
    if (tmp.cap(1) == "qcmb") connect(tmplist->at(i), SIGNAL(activated(int)),              this, SLOT(callshowvf()));
    if (tmp.cap(1) == "kdsb") connect(tmplist->at(i), SIGNAL(valueChanged(int)),           this, SLOT(callshowvf()));
    if (tmp.cap(1) == "qle")  connect(tmplist->at(i), SIGNAL(textChanged(const QString&)), this, SLOT(callshowvf()));
  }
  
  QObject * tmpqcbcon [] = {
    qsb_lavc_auto_011_vqmin,                  qsb_lavc_auto_011_vqmax,
    qsb_xvid_auto_010_quant_rangemin,         qsb_xvid_auto_010_quant_rangemax,
    kdsb_vf_auto_000_unsharp_luma_strength,   qsb_vf_auto_000_unsharp_luma_x,   qsb_vf_auto_000_unsharp_luma_y,
    kdsb_vf_auto_000_unsharp_chroma_strength, qsb_vf_auto_000_unsharp_chroma_x, qsb_vf_auto_000_unsharp_chroma_y,
    qpb_vf_preview_now, qsb_vf_auto_000_crop_h,     qcmb_mp3lamep_auto_010_abr, qsb_mp3lamep_auto_011_preset, 0
  };
  
  QObject * tmpqcb [] = {
    qcb_lavc_auto_010_vqminmax,     qcb_lavc_auto_010_vqminmax,
    qcb_xvid_auto_010_quant_range,  qcb_xvid_auto_010_quant_range,
    qcb_vf_auto_000_unsharp_luma,   qcb_vf_auto_000_unsharp_luma,   qcb_vf_auto_000_unsharp_luma,
    qcb_vf_auto_000_unsharp_chroma, qcb_vf_auto_000_unsharp_chroma, qcb_vf_auto_000_unsharp_chroma,
    qpb_vf_preview, qrb_crop_custom,        qrb_mp3lamep_auto_010_qcb, qrb_mp3lamep_auto_010_qsb, 0
  };
  
  for (uint i = 0; tmpqcbcon[i]; i++) connect(tmpqcb[i], SIGNAL(toggled(bool)), tmpqcbcon[i], SLOT(setEnabled(bool)));

  if (!hoverFilter) hoverFilter = new choverFilter(this);
  for (uint i = 0; hoverFilter->helpObjectList()[i]; i++)
    hoverFilter->helpObjectList()[i]->installEventFilter(hoverFilter);
}
void kmenc15::destroy() {
  if (source_preview->isRunning()) {
    source_preview->immediateWrite("pause\nquit\n");
    if (!source_preview->wait(1)) source_preview->dieNow(2);
  }
  //delete source_preview;
  tempDirectory->unlink();
  delete tempDirectory;
}

bool kmenc15::addfile() {
  return addfile(KFileDialog::getOpenFileName("", "*.avi *.mpg mpe *.mpeg *.m1v *.m2p *.m2v *.mov *.asf *.vob *.mjpg *.wmv *.asx *.qt *.rm *.mkv *.ogm|Video Files", this, "Choose a file"));
}
bool kmenc15::addfile(const QString & filename) {
  if (!QFile::exists(filename)) {
    ql_source_status->setText("No Such File.");
    return false;
  }
  files.insert(files.at() + 1, new MovieFile);

  files.current()->origfile = filename;

  for (QPtrListIterator<MovieFile> it(files); *it; ++it)
    if (filename == (*it)->origfile) files.current()->origidx = (*it)->origidx;

  ql_source_status->setText("Loading...");
  ql_source_status->repaint();

  MyProcess tmpcommand;

  tmpcommand << QStringList::split(' ',"mplayer -v -frames 0 -ao null -vo null -loadidx");
  tmpcommand << files.current()->origidx;
  tmpcommand << files.current()->origfile;

  tmpcommand.start();

  if (!tmpcommand.waitForText("AVI Header", 4)) {
    tmpcommand.dieNow(2);
    delfile();
    ql_source_status->setText("Failed to load. 1");
    return false;
  }
  QString tmpstring = tmpcommand.waitForLines(20, 2);

  tmpcommand.dieNow(2);
  
  QRegExp tmpregexp;
  
  if (tmpregexp.search(tmpstring) == -1) {
    delfile();
    ql_source_status->setText("Failed to load.2");
    return false;
  }

  tmpregexp.setPattern("us/frame:\\s+\\d+\\s+\\(fps=(\\d*\\.\\d*)\\)");
  if (tmpregexp.search(tmpstring) == -1) {
    delfile();
    ql_source_status->setText("Failed to load.3");
    return false;
  }
  files.current()->fps = tmpregexp.cap(1).toDouble();
  
  tmpregexp.setPattern("Size:\\s+(\\d+)\\s+x\\s+(\\d+)\\n");
  if (tmpregexp.search(tmpstring) == -1) {
    delfile();
    ql_source_status->setText("Failed to load.4");
    return false;
  }
  files.current()->width = tmpregexp.cap(1).toInt();
  files.current()->height = tmpregexp.cap(2).toInt();
  
  tmpregexp.setPattern("Start: \\d+\\s+Len:\\s+(\\d+)\\n");
  if (tmpregexp.search(tmpstring) == -1) {
    delfile();
    ql_source_status->setText("Failed to load.5");
    return false;
  }
  files.current()->frames = tmpregexp.cap(1).toInt();
      
  if (files.current()->width != files.getFirst()->width || files.current()->height != files.getFirst()->height) {
    delfile();
    ql_source_status->setText("Bad Frame Size.");
    return false;
  }
  if (files.current()->fps != files.getFirst()->fps) {
    delfile();
    ql_source_status->setText("Bad Fps.");
    return false;
  }
  files.current()->end = files.current()->frames;
  
  if (!loadfile()) return false;
  
  if (!files.at()) {
    qsb_vf_auto_000_crop_w->blockSignals(true);
    qsb_vf_auto_000_crop_h->blockSignals(true);
    qsb_vf_auto_000_crop_w->setValue(files.current()->width);
    qsb_vf_auto_000_crop_h->setValue(files.current()->height);
    qsb_vf_auto_000_crop_w->blockSignals(false);
    qsb_vf_auto_000_crop_h->blockSignals(false);
  }

  fileprepare(true);
  
  ql_source_status->setText("Done loading.");

  return true;
}
void kmenc15::delfile() {
  files.remove();

  loadfile();
  fileprepare(!files.isEmpty());
}

bool kmenc15::loadfile() {
  static int tries = 0;
  if (tries == 5) {
    ql_source_status->setText("CRITICAL: Failed to load.");
    tries = 0;
    delfile();
    return false;
  }
  ql_source_pic->clear();
  if (source_preview->isRunning()) {
    source_preview->immediateWrite("pause\nquit\n");
    if (!source_preview->wait(1)) source_preview->dieNow(2);
  }

  if (!files.current()) return true;

  source_preview->clearArguments();
  MyProcess & tmpvar = * source_preview;
  
  tmpvar << QStringList::split(' ',"mplayer -vf-clr -xy 1 -nozoom -ao null -ac dummy -vo x11 -slave -fps 1 -benchmark -noquiet -osdlevel 0 -loop 0 -wid");
  tmpvar << QString::number(ql_source_pic->winId());
  tmpvar << "-loadidx";
  tmpvar << files.current()->origidx;
  tmpvar << files.current()->origfile;
  
  if (!source_preview->start()) { KMessageBox::sorry(this, "Could not open MPlayer. Bailing out."); exit(1); }
  source_preview->waitForOutput(0);

  source_preview->immediateWrite("pause\n");
  
  if (!source_preview->waitForText("  =====  ", 5)) { tries++; return loadfile(); }
  source_preview->readStdout();
  tries = 0;
  return true;
}

void kmenc15::fileprepare(bool enabled) {
  QWidget * tmpwidget [] = {
    qs_source_slider,  qpb_source_close, qpb_source_idx,      qsb_source_frame,    qpb_source_setbegin,
    qpb_source_setend, qpb_source_prev,  qpb_source_next,     qpb_source_fastprev, qpb_source_fastnext,
    qpb_source_start,  qpb_source_end,   qpb_source_prevfile, qpb_source_nextfile, 0
  };
    
  for (uint i = 0; tmpwidget[i]; i++) tmpwidget[i]->setEnabled(enabled);
  
  if (!enabled) { // disabled mode...
    qpb_source_idx->setHidden(false);
    qpb_source_delidx->setHidden(true);
  } else { // enabled mode
    qpb_source_cancelidx->setHidden(true);
    qpb_source_cancelidx->setEnabled(true);
    
    qpb_source_idx->setHidden(!files.current()->origidx.isEmpty());
    qpb_source_delidx->setHidden(files.current()->origidx.isEmpty());

    qpb_source_prevfile->setEnabled(files.at());
    qpb_source_nextfile->setEnabled(files.current() != files.getLast());  

    qsb_source_frame->setMaxValue(files.current()->frames);
    qs_source_slider->setMaxValue(files.current()->frames);
    qs_source_slider->setPageStep(files.current()->frames/10);

    resetline();

    qsb_source_frame->blockSignals(true); qs_source_slider->setValue(0); qsb_source_frame->blockSignals(false);
  }
}

void kmenc15::filenext() {
  files.next();
  loadfile();
  fileprepare(true);
}
void kmenc15::fileprev() {
  files.prev();
  loadfile();
  fileprepare(true);
}

void kmenc15::buildidx() {
  int i;

  for (i = 0; QFile::exists(tempDirectory->name() + "/idx_" + QString::number(i)); i++);

  mainprogs.append(new MyProcess());
  *mainprogs.current() << QStringList::split(' ',"mencoder -frames 0 -ovc copy -oac copy -o /dev/null -saveidx");
  *mainprogs.current() << tempDirectory->name() + "/idx_" + QString::number(i) << files.current()->origfile;

  fileprepare(false);
  
  qpb_source_open->setEnabled(false);
  qpb_source_cancelidx->setHidden(false);
  qpb_source_idx->setHidden(true);
  qpb_source_idxprogress->setHidden(false);
  qpb_source_idxprogress->setProgress(0);
  
  for (i = 1; i <= 5; i++) qtw_all->setTabEnabled(qtw_all->page(i), false);

  ql_source_status->setText("Building Idx...");
  ql_source_status->repaint();
  
  connect(mainprogs.current(), SIGNAL(readyReadStdout()), this, SLOT(idx_stdout()));
  connect(mainprogs.current(), SIGNAL(processExited(KProcess *)), this, SLOT(idx_done()));

  mainprogs.current()->start();
  mainprogs.current()->waitForOutput(0);
}
void kmenc15::idx_stdout() {
  QString tmptext(mainprogs.current()->readStdout());
  if(!tmptext.contains('%')) return;
  tmptext = tmptext.mid(tmptext.find('%') - 3, 2);
  if (qpb_source_idxprogress->progress() != tmptext.toInt()) qpb_source_idxprogress->setProgress(tmptext.toInt());
}
void kmenc15::idx_done() {
  bool tmp = mainprogs.current()->normalExit() && !mainprogs.current()->exitStatus();

  if (tmp) for (QPtrListIterator<MovieFile> it(files); *it; ++it)
      if ((*it)->origfile == QString(mainprogs.current()->args().last()))
        (*it)->origidx = mainprogs.current()->args()[mainprogs.current()->args().count() - 2];

  disconnect(mainprogs.current(), SIGNAL(readyReadStdout()), this, SLOT(idx_stdout()));
  disconnect(mainprogs.current(), SIGNAL(processExited(KProcess *)), this, SLOT(idx_done()));
  mainprogs.remove();
  
  qpb_source_open->setEnabled(true);
  qpb_source_idxprogress->setHidden(true);
  
  for (int i = 1; i <= 5; i++) qtw_all->setTabEnabled(qtw_all->page(i), true);
  qtw_all->setTabEnabled(qtw_all->page(4), false);

  if (tmp) ql_source_status->setText("Idx done."); else ql_source_status->setText("Idx Failed.");
  
  if (tmp) loadfile(); else changepic(0);

  fileprepare(true);
}
void kmenc15::cancelidx() {
  mainprogs.current()->selfDestruct(5000);
  qpb_source_cancelidx->setEnabled(false);
}
void kmenc15::delidx() {
  uint tmp = files.at();

  for (uint i = 0; i < files.count(); i++)
    if (files.at(tmp)->origfile == files.at(i)->origfile) files.at(i)->origidx = "";
  
  files.at(tmp);
  
  loadfile();
  fileprepare(true);
}

void kmenc15::changepic() {
  changepic(qsb_source_frame->value());
}
void kmenc15::changepic(int frame) {
  if (!source_preview->isRunning()) if (!loadfile()) { delfile(); return; }
  source_preview->immediateWrite("pause\nseek " + QString::number(frame ? frame - 1 : 0) + " 2\npause\n");
  if (!source_preview->waitForText("  =====  ", 5)) return;
  source_preview->readStdout();
}

void kmenc15::frame100up() {
  qsb_source_frame->setValue(qsb_source_frame->value() + 10);
}
void kmenc15::frame100down() {
  qsb_source_frame->setValue(qsb_source_frame->value() - 10);
}
void kmenc15::moveend() {
  qsb_source_frame->setValue(files.current()->end);
}
void kmenc15::movefirst() {
  qsb_source_frame->setValue(files.current()->start);
}

void kmenc15::framefirst() {
  if (qsb_source_frame->value() <= files.current()->end) files.current()->start = qsb_source_frame->value();
  resetline();
}
void kmenc15::framelast() {
  if (qsb_source_frame->value() >= files.current()->start) files.current()->end = qsb_source_frame->value();
  resetline();
}

void kmenc15::resetline() {
  uint nums[3];
  double f;

  QWidget * tmpobjects [3][5] = {
    {l_source_line_left_1,  l_source_line_left_2,  l_source_line_left_3,  l_source_line_left_4,  0},
    {l_source_line_1,       l_source_line_2,       l_source_line_3,       l_source_line_4,       0},
    {l_source_line_right_1, l_source_line_right_2, l_source_line_right_3, l_source_line_right_4, 0}
  };

  if (!files.current()) return;
  
  nums[0] = files.current()->start;
  nums[1] = files.current()->end - files.current()->start;
  nums[2] = files.current()->frames - files.current()->end;

  f = 1020. / max(nums[0], max(nums[1], nums[2]));
  
  nums[0] = uint(nums[0] * f);
  nums[1] = uint(nums[1] * f);
  nums[2] = uint(nums[2] * f);
  
  for (uint i = 0; i < 3; i++)
    for (uint j = 0; tmpobjects[i][j]; j++) {
      tmpobjects[i][j]->setHidden(nums[i] <= j * 255);
      tmpobjects[i][j]->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed,
                                      min(max(0, nums[i] - j * 255), 255), 0));
    }
}

void kmenc15::reset_ovc_text(int textnum) {
  ql_ovc_opt->setText(QStringList::split(',',"Copy,Raw,Nuppel Video,DivX4,Libavcodec,VfW,Quicktime,XviD,Audio Only")[textnum] + " Options");
}

void kmenc15::make_command() {
  enum ovc { e_copy=0, e_raw=1, e_nuv=2, e_divx4=3, e_lavc=4, e_vfw=5, e_qtvideo=6, e_xvid=7, e_frameno=8 };
  enum oac { e_mp3lame = 0, e_lavca = 1, e_copya = 2, e_pcm = 3 };
  
  QStringList menc_com1 = "mencoder"; ///< the core 2st pass command
  QStringList menc_com2; ///< the core 2nd pass command, or empty
  QStringList audio_com; ///< audio options to be appended for final pass
  QStringList fullfile; ///< temporary variable for MPlayer command
  QStringList kmenc15_com; ///< the 'kmenc15 -t /tmp/kmenc15 ...' command
  QString opts; ///< Temporary variable to store anything to do with single param options
  QString ofile; ///< final output file
  QString tmpdir; ///< location of temporary working directory
  QString twopass; ///< temp variable for two pass ovc options
  QString oc_name; ///< the ovc or oac name
  QString opts_name; ///< the ovc or oac's associated MEncoder option
  QString search_name; ///< the name to search in kmenc15's objects

  static int newVersionMPlayer = -1;

  if (qtw_all->currentPageIndex() != 5) return;

  //if (newVersionMPlayer == -1) newVersionMPlayer = !MyProcess::system("mplayer -aofile bla -bla &> /dev/null");
  // ^ cool hack. MPlayer developers changed -aofile to -ao pcm:file= ...
  
  fullcommand.clear();
  if (!files.count()) goto dontbother;      // Wait, Should I even bother? Is there a file loaded?...

  tmpdir = QDir(kur_wdir->url().isEmpty() ? tempDirectory->name() : kur_wdir->url()).canonicalPath() + "/";
  ofile = kur_ofile->url().isEmpty() ? QDir::homeDirPath() + "/test.avi" : kur_ofile->url();
  
  menc_com1 << "-of" << QStringList::split(' ',"avi mpeg rawvideo")[qbg_general_auto_010_of->selectedId()];
  if (kdsb_general_auto_110_ofps->isEnabled()) menc_com1 << "-ofps" << opts.number(kdsb_general_auto_110_ofps->value());
  
  menc_com1 << "-sws" << opts.number(qcmb_general_auto_010_sws->currentItem());
  menc_com1 += QStringList::split(' ',qle_general_auto_010_mencopts->text());
  if (qgb_general_auto_010_info->isChecked())      // AVI Info
    menc_com1 << "-info" << "name=" + qle_info_auto_010_title->text() + ":"
        "artist=" + qle_info_auto_010_artist->text() + ":"
        "genre=" + qle_info_auto_010_genre->text() + ":"
        "subject=" + qle_info_auto_010_subject->text() + ":"
        "copyright=" + qle_info_auto_010_copyright->text() + ":"
        "comment=" + qle_info_auto_010_comment->text();
  
  if (qlb_vf->count()) {            // Video filters
    menc_com1 << "-vf";
    opts = qlb_vf->item(0)->text();
    for (uint i = 1; i < qlb_vf->count(); i++) opts += "," + qlb_vf->item(i)->text();
    menc_com1 << opts;
  }
  
  opts = "";
  switch ((enum ovc)qbg_ovc_auto_010_ovc->selectedId()) {  // Video codec options
    case e_copy:    oc_name = "copy";    break;
    case e_vfw:     oc_name = "vfw";     break;
    case e_qtvideo: oc_name = "qtvideo"; break;
    case e_frameno: oc_name = "frameno"; break;
    case e_nuv:     oc_name = "nuv";     opts_name = "-nuvopts"; break;
    case e_divx4: { oc_name = "divx4";   opts_name = "-divx4opts";
      if (qbg_divx4_auto_010_pass->selectedId())
        twopass = (qbg_divx4_auto_010_pass->selectedId() == 1 ? "pass" : "vbrpass");
      break;
    }
    case e_lavc:  { oc_name = "lavc";    opts_name = "-lavcopts";
      if (qbg_lavc_auto_010_vpass->selectedId()) twopass = "vpass";
      opts += ":vcodec=" + QStringList::split(' ',"mpeg4 mpeg1video mpeg2video wmv1 wmv2 rv10 mjpeg ljpeg h263"
          " h263p msmpeg4 msmpeg4v2 huffyuv asv1 asv2 ffv1")[qcmb_lavc_auto_010_vcodec->currentItem()];
      break;
    }
    case e_xvid:  { oc_name = "xvid";    opts_name = "-xvidencopts";
      if (qbg_xvid_auto_010_pass->selectedId()) twopass = "pass";
      if (qsb_xvid_auto_010_quant_rangemin->isEnabled())
        opts += ":quant_range=" + opts.number(qsb_xvid_auto_010_quant_rangemin->value()) + "-"
            + opts.number(qsb_xvid_auto_010_quant_rangemax->value());
      break;
    }
    case e_raw:   { oc_name = "raw";
      menc_com1 << "-vf-add" << "format=fmt=" + qcb_raw_auto_010_fmt->currentText();
      break;
    }
  }
  menc_com1 << "-ovc" << oc_name;
  if (!opts_name.isEmpty()) {
    opts += object_data(oc_name);
    if (qle_general_auto_010_vcopts->text().length()) opts += ":" + qle_general_auto_010_vcopts->text();
    if (twopass.isEmpty()) {
      if (opts.length()) menc_com1 << opts_name << opts.mid(1);
    } else {
      opts += ":" + twopass + "=";
      opts = opts.mid(1);
      menc_com2 = menc_com1;
      menc_com1 << opts_name << opts + "1";
      menc_com2 << opts_name << opts + "2";
    }
  }

  opts_name = "";
  opts = "";
  switch ((enum oac)qbg_oac_auto_010_oac->selectedId()) {  // Audio codec options
    case e_copya:     oc_name = "copy";    break;
    case e_pcm:       oc_name = "pcm";     break;
    case e_mp3lame: { oc_name = "mp3lame"; opts_name = "-lameopts";
      if (qrb_mp3lame_auto_010_manual->isChecked()) {  // manual
        int tmp = qcmb_mp3lamem_auto_010_mode->currentItem();
        search_name = "mp3lamem";
        if (tmp) opts += ":mode=" + opts.number(tmp - 1);
      } else {  // preset
        search_name = "mp3lamep";
        if (qcmb_mp3lamep_auto_010_preset->currentItem() != 4) opts += ":preset=" +
              QStringList::split(' ',"medium standard extreme insane")[qcmb_mp3lamep_auto_010_preset->currentItem()];
        else if (qcmb_mp3lamep_auto_010_abr->isEnabled())      opts += ":preset=" +
              QStringList::split(' ',"phone phon+ mw-us voice 96 radio 128 hifi cd 224 studio 320"
                                )[qcmb_mp3lamep_auto_010_abr->currentItem()];
      }
      break;
    }
    case e_lavca:   { oc_name = "lavc";    opts_name = "-lavcopts";
      search_name = "alavc";
      opts += ":acodec="+QStringList::split(' ',"mp2 mp3 ac3 adpcm_ima_wav")[qcmb_alavc_auto_010_acodec->currentItem()];
      break;
    }
  }
  audio_com << "-oac" << oc_name;
  if (!opts_name.isEmpty()) {
    opts += object_data(search_name);
    if (qle_general_auto_010_acopts->text().length()) opts += ":" + qle_general_auto_010_acopts->text();
    if (opts.length()) audio_com << opts_name << opts.mid(1);
  }
  if (qle_general_auto_010_afopts->text().length()) audio_com << "-af" << qle_general_auto_010_afopts->text();
  
  if (0 && files.count() > 1) {
    opts = "mkdir -p " + MyProcess::shellescape(tmpdir) + " && cd " + MyProcess::shellescape(tmpdir) +
        " && mkfifo 2> /dev/null";
    for (uint i = 0; i < files.count() + 3; i++) opts += " tmp-part" + opts.number(i);
    fullcommand << QStringList("system") + QStringList(opts); // FIFO's made.

    if (!QDir::current().exists(KCmdLineArgs::appName(), true)) kmenc15_com << KCmdLineArgs::appName();
    else kmenc15_com << QDir::current().absFilePath(KCmdLineArgs::appName(), true);
    
    kmenc15_com << "-t" << tmpdir << opts.number(files.current()->fps)
        << opts.number(files.current()->width) << opts.number(files.current()->height);

    uint i = 3;
    for (QPtrListIterator<MovieFile> it(files); *it; ++it, i++) {
      fullfile << (*it)->origfile <<
          "-loadidx" << (*it)->origidx <<
          "-ss" << opts.number((*it)->start/(*it)->fps) <<
          "-frames" << opts.number((*it)->end - (*it)->start);
      if (newVersionMPlayer) fullfile << "-ao" << "pcm:nowaveheader:file=" + tmpdir + "tmp-part" + opts.number(i);
      else fullfile << "-aofile" << tmpdir + "tmp-part" + opts.number(i);
      
      kmenc15_com << opts.number((*it)->end - (*it)->start);
    }
    
    if (!menc_com2.isEmpty() && !qcb_general_skippass->isChecked()) {
      fullcommand << QStringList::split(' ',"mplayer -ac dummy -osdlevel 0 -fixed-vo -vf format=yv12 -benchmark -xy 1 -nozoom -vo") + QStringList("yuv4mpeg:file=" + tmpdir + "tmp-part0") + fullfile;
      fullcommand << kmenc15_com;
      menc_com1 << "-oac" << "copy" << tmpdir + "tmp-part1" << "-o" << "/dev/null";
      fullcommand << menc_com1;
      fullcommand << QStringList("wait");
    }
    if (!menc_com2.isEmpty()) menc_com1 = menc_com2;

    fullcommand << QStringList::split(' ',"mplayer -mc 0 -osdlevel 0 -fixed-vo -vf format=yv12 -benchmark -ao pcm -nowaveheader -af-adv force=1 -srate 44100 -autosync 2 -xy 1 -nozoom -ni -vo") + QStringList("yuv4mpeg:file=" + tmpdir + "tmp-part0") + fullfile;

    fullcommand << kmenc15_com;

    menc_com1 += audio_com;    
    menc_com1 << "-audio-demuxer" << "20" << "-audiofile" << tmpdir + "tmp-part2" << tmpdir + "tmp-part1" << "-o";
    menc_com1 << ofile;
    fullcommand << menc_com1;

    fullcommand << QStringList("wait");
  } else {                          // Only 1 file, trivial kid's stuff.
    for (QPtrListIterator<MovieFile> it(files); *it; ++it) {
      fullfile << (*it)->origfile <<
          "-loadidx" << (*it)->origidx <<
          "-ss" << opts.number((*it)->start/(*it)->fps) <<
          "-frames" << opts.number((*it)->end - (*it)->start);
    }
    if (!menc_com2.isEmpty()) {
      if (!qcb_general_skippass->isChecked()) {
        fullcommand << menc_com1 + menc_com1.split(' ',"-oac copy") + fullfile + menc_com1.split(' ',"-o /dev/null");
        fullcommand << QStringList("wait");
      }
      fullcommand << menc_com2 + fullfile + QStringList("-o") + QStringList(ofile) + audio_com;
    } else fullcommand << menc_com1 + fullfile + QStringList("-o") + QStringList(ofile) + audio_com;
    fullcommand << QStringList("wait");
  }
dontbother:
  globalpass = menc_com2.isEmpty() ? 0 : (qcb_general_skippass->isChecked() ? 2 : 1);
  shell_com();
}
const QString & kmenc15::object_data(const QString & oc_name) {
  static QString opts;
  QRegExp tmp(DATA_PATTERN(oc_name));
  QObjectList * tmplist = queryList(0, tmp.pattern(), true, true);
  opts = "";
  for (uint i = 0; i < tmplist->count(); i++) {
    if (!((QWidget *)tmplist->at(i))->isEnabled()) continue;
    tmp.search(tmplist->at(i)->name());
    if (tmp.cap(1) == "qsb")  opts += ":" + tmp.cap(2) + "=" + opts.number(((QSpinBox *)tmplist->at(i))->value());
    if (tmp.cap(1) == "kdsb") opts += ":" + tmp.cap(2) + "=" + opts.number(((KDoubleSpinBox*)tmplist->at(i))->value());
    if (tmp.cap(1) == "qle")  opts += ":" + tmp.cap(2) + "=" + ((QLineEdit *)tmplist->at(i))->text();
    if (tmp.cap(1) == "qcb")  if (((QCheckBox *)tmplist->at(i))->isChecked()) opts += ":" + tmp.cap(2);
    if (tmp.cap(1) == "qcmb") opts += ":" + tmp.cap(2) + "=" +opts.number(((QComboBox*)tmplist->at(i))->currentItem());
  }
  return opts;
}

void kmenc15::startencode() {
  if (!fullcommand.count()) return;
  qpb_progress->setProgress(0);
  qtb_output->setText("");
  uint totframes = 0;
  for (QPtrListIterator<MovieFile> it(files); *it; ++it) totframes += (uint)((*it)->end - (*it)->start);
  
  //for (uint i = 0; i < files.count(); i++) totframes += (uint)(files[i].end - files[i].start);
  qpb_progress->setTotalSteps(totframes * (globalpass?2:1));
  ql_encode_pass->setText(globalpass ? "1/2" : "1/1");

  qpb_encode->setEnabled(false);
  qpb_encode_cancel->setEnabled(true);
  qpb_opentemplate->setEnabled(false);
  for (int i = 0; i <= 4; i++) qtw_all->setTabEnabled(qtw_all->page(i), false);

  for (QValueList<QStringList>::Iterator tmpcom = fullcommand.begin(); tmpcom != fullcommand.end(); ++tmpcom) {
    mainprogs.append(new MyProcess(*tmpcom));
    mainprogs.current()->setWorkingDirectory(kur_wdir->url().isEmpty() ? tempDirectory->name() : kur_wdir->url());
  }

  for (mainprogs.first(); ; mainprogs.next())
    if (mainprogs.current()->args()[0] == "system") MyProcess::system(mainprogs.current()->args()[1]);
  else if (mainprogs.next()->args()[0] == "wait") break;
  else mainprogs.prev()->start();

  mainprogs.prev();
  connect(mainprogs.current(), SIGNAL(readyReadStdout()), this, SLOT(menc_stdout()));
  connect(mainprogs.current(), SIGNAL(processExited(KProcess *)), this, SLOT(menc_done()));
  mainprogs.current()->start();
  mainprogs.current()->waitForOutput(0);
}
void kmenc15::menc_stdout() {
  menc_stdout(false);
}
void kmenc15::menc_stdout(bool force) {
  static int fps = 5;
  static int i = 0;
  int frames, vbitrate, abitrate;
  QString stdoutData, stdoutData2;

  if (!force) switch (qbg_speed->selectedId()) {
    case 0: if (++i < (fps>200?1000:(fps>50?100:20))) return; break;
    case 1: if (++i < (fps>200?100 :(fps>50?10 :2 ))) return; break;
    case 2: if (++i < (fps>200?10  :(fps>50?2  :1 ))) return; break;
  }

  i = 0;

  stdoutData = mainprogs.current()->readStdout();
  stdoutData2 = stdoutData;
  
  QString tmp = qtb_output->text();

  int posenter = stdoutData.find('\n'), posclear = stdoutData.find('\r');
  
  while (posenter != -1 && (posenter < posclear || posclear == -1)) { // add any new lines
    tmp.append(stdoutData.left(posenter + 1));
    stdoutData = stdoutData.mid(posenter + 1);
    posenter = stdoutData.find('\n'), posclear = stdoutData.find('\r');
  }
  while (posclear != -1) { // add whatever is after the \r, in the position of the latest \n
    tmp = tmp.left(tmp.findRev('\n') + 1).append(stdoutData.left(posclear));
    stdoutData = stdoutData.mid(posclear + 1);
    posclear = stdoutData.find('\r');
  }
  tmp.append(stdoutData); // whatever is left, just add it
  
  qtb_output->setText(tmp);
  if (stdoutData2.find('\n') != -1) qtb_output->scrollToBottom();

  if (!(stdoutData2 = stdoutData2.mid(0,stdoutData2.findRev(']')))) return;
  if (!(stdoutData2 = stdoutData2.mid(stdoutData2.findRev("Pos")))) return;
  
  sscanf(stdoutData2.latin1(), "Pos: %*fs %df (%*d%%) %dfps Trem: %*dmin %*dmb A-V:%*f [%d:%d", &frames, &fps, &vbitrate, &abitrate);

  ql_encode_fps->setText(QString::number(fps));
  ql_encode_abitrate->setText(QString::number(abitrate) + " kbps");
  ql_encode_vbitrate->setText(QString::number(vbitrate) + " kbps");

  int totframes = qpb_progress->totalSteps() / (globalpass ? 2 : 1); // calculated at begginning of encode
  
  int tmpsecs = int(frames / files.current()->fps);
  int totsecs = int(totframes / files.current()->fps);

  qpb_progress->setProgress(frames + ((globalpass == 2) ? totframes : 0));
  ql_encode_frames->setText(tmp.number(frames) + "/" + tmp.number(totframes));

  ql_encode_time->setText(tmp.sprintf("%d:%02d:%02d/%d:%02d:%02d",
                          tmpsecs / 3600, (tmpsecs % 3600) / 60, tmpsecs % 60,
                          totsecs / 3600, (totsecs % 3600) / 60, totsecs % 60));

  ql_encode_size->setText(QString::number(double((abitrate + vbitrate) * totsecs) / 8192., 'f', 1) + " MB");
  
  tmpsecs = (qpb_progress->totalSteps() - qpb_progress->progress()) / (fps ? fps : 1);
  
  ql_encode_eta->setText(tmp.sprintf("%d:%02d:%02d",tmpsecs / 3600,(tmpsecs % 3600) / 60,tmpsecs % 60));
}
void kmenc15::menc_done() {
  menc_stdout(true);
  disconnect(mainprogs.current(), SIGNAL(readyReadStdout()), this, SLOT(menc_stdout()));
  disconnect(mainprogs.current(), SIGNAL(processExited(KProcess *)), this, SLOT(menc_done()));

  for (mainprogs.first(); mainprogs.current()->args()[0] != "wait"; mainprogs.remove()) mainprogs.current()->dieNow(0);
  mainprogs.remove();
  
  if (mainprogs.count() && qpb_encode_cancel->isEnabled()) { // there's more to do, and the user hasn't shut us down.
    globalpass++;
    ql_encode_pass->setText("2/2");

    for (mainprogs.first(); ; mainprogs.next())
      if (mainprogs.next()->args()[0] == "wait") break;
    else mainprogs.prev()->start();

    mainprogs.prev();
    connect(mainprogs.current(), SIGNAL(readyReadStdout()), this, SLOT(menc_stdout()));
    connect(mainprogs.current(), SIGNAL(processExited(KProcess *)), this, SLOT(menc_done()));
    mainprogs.current()->start();
    mainprogs.current()->waitForOutput(0);
  }
  else {
    if (qcb_general_auto_010_del2pass->isChecked() && qpb_encode_cancel->isEnabled() && globalpass) {
      QDir tmp(kur_wdir->url().isEmpty() ? tempDirectory->name() : kur_wdir->url());
      tmp.remove("divx2pass.log");
      tmp.remove("xvid-twopass.stats");
    }
    mainprogs.clear();
    globalpass = globalpass ? (qcb_general_skippass->isChecked() ? 2 : 1) : 0;

    qpb_encode->setEnabled(true);
    qpb_encode_cancel->setEnabled(false);
    qpb_opentemplate->setEnabled(true);
    for (int i = 0; i <= 4; i++) qtw_all->setTabEnabled(qtw_all->page(i), true);
    qtw_all->setTabEnabled(qtw_all->page(4), false);
  }
}
void kmenc15::cancel_encode() {
  mainprogs.current()->selfDestruct(5000);
  qpb_encode_cancel->setEnabled(false);
}

void kmenc15::movevfup() {
  int num = qlb_vf->currentItem();
  QString tmp(qlb_vf->text(num));
  qlb_vf->changeItem(qlb_vf->text(num - 1),num);
  qlb_vf->changeItem(tmp,--num);
  qpb_vf_up->setEnabled(num);
  qpb_vf_down->setEnabled(qlb_vf->count()-num-1);
}
void kmenc15::movevfdown() {
  int num = qlb_vf->currentItem();
  QString tmp(qlb_vf->text(num));
  qlb_vf->changeItem(qlb_vf->text(num + 1),num);
  qlb_vf->changeItem(tmp,++num);
  qpb_vf_up->setEnabled(num);
  qpb_vf_down->setEnabled(qlb_vf->count()-num-1);
}
void kmenc15::addvf() {
  qlb_vf->insertItem(createvftext(),qlb_vf->currentItem() + 1);
  qlb_vf->setCurrentItem(qlb_vf->currentItem() + 1);
  callshowvf();
}
void kmenc15::removevf() {
  uint tmp = qlb_vf->currentItem();
  qlb_vf->removeItem(tmp);
  if (qlb_vf->count()) {
    if (tmp == qlb_vf->count()) tmp--;
    qlb_vf->setCurrentItem(tmp);
    vf_selected(tmp);
  }
  else {
    qpb_vf_del->setEnabled(false);
    qpb_vf_up->setEnabled(false);
    qpb_vf_down->setEnabled(false);
  }
}
const QString & kmenc15::createvftext() {
  enum vf {
    e_crop = 0, e_cropdetect = 1, e_expand = 2, e_flip = 3, e_mirror = 4, e_rotate = 5, e_scale = 6,
    e_format = 7, e_noise = 8, e_denoise3d = 9, e_hqdn3d = 10, e_eq = 11, e_hue = 12, e_dint = 13, e_lavcdeint = 14,
    e_unsharp = 15, e_boxblur = 16, e_sab = 17, e_smartblur = 18, e_delogo = 19, e_custom = 20,
  };

  static QString tmp;
  tmp = "";
  switch ((enum vf)qlb_vf_source->currentItem()) {
    case e_crop: {      tmp = "crop=" +
      tmp.number(qsb_vf_auto_000_crop_w->value()) + ":" + tmp.number(qsb_vf_auto_000_crop_h->value()) + ":" +
          tmp.number(qsb_vf_auto_000_crop_x->value()) + ":" + tmp.number(qsb_vf_auto_000_crop_y->value());
      break;
    }
    case e_cropdetect:  tmp = "cropdetect=" + tmp.number(qsb_vf_auto_000_cropdetect->value()); break; //FIXME cropdetect
    case e_expand: {    tmp = "expand=" +
      tmp.number(qsb_vf_auto_000_expand_w->value()) + ":" + tmp.number(qsb_vf_auto_000_expand_h->value()) + ":" +
          tmp.number(qsb_vf_auto_000_expand_x->value()) + ":" + tmp.number(qsb_vf_auto_000_expand_y->value());
      break;
    }
    case e_flip:        tmp = "flip";                                                          break;
    case e_mirror:      tmp = "mirror";                                                        break;
    case e_rotate:      tmp = "rotate=" + tmp.number(qsb_vf_auto_000_rotate->value());         break;
    case e_scale: {     tmp = "scale=" +
      tmp.number(qsb_vf_auto_000_scale_w->value()) + ":" + tmp.number(qsb_vf_auto_000_scale_h->value());
      if (qcb_vf_auto_000_scale_interlaced->isChecked()) tmp += "1"; tmp += ":";
      if (qsb_vf_auto_100_scale_chroma->isEnabled()) tmp += tmp.number(qsb_vf_auto_100_scale_chroma->value()); tmp+=":";
      if (qsb_vf_auto_100_scale_param->isEnabled()) tmp += tmp.number(qsb_vf_auto_100_scale_param->value()); tmp += ":";
      break;
    }
    case e_format:      tmp = "format=fmt=" + qcmb_vf_auto_000_format->currentText();          break;
    case e_noise: {     tmp = "noise=";
      QString tmp2;
      if (qcb_vf_auto_000_noise_uniform->isChecked()) tmp2 += "u";
      if (qcb_vf_auto_000_noise_temporal->isChecked()) tmp2 += "t";
      if (qcb_vf_auto_000_noise_high->isChecked()) tmp2 += "h";
      if (qcb_vf_auto_000_noise_pattern->isChecked()) tmp2 += "p";
      tmp += tmp.number(qsb_vf_auto_000_noise_luma->value()) + tmp2 + ":" +
          tmp.number(qsb_vf_auto_000_noise_chroma->value()) + tmp2;
      break;
    }
    case e_denoise3d: { tmp = "denoise3d=" +
      tmp.number(qsb_vf_auto_000_denoise3d_luma->value()) + ":" +
          tmp.number(qsb_vf_auto_000_denoise3d_chroma->value()) + ":" +
          tmp.number(qsb_vf_auto_000_denoise3d_temporal->value());
      break;
    }
    case e_hqdn3d: {    tmp = "hqdn3d=" +
      tmp.number(qsb_vf_auto_000_hqdn3d_luma->value()) + ":" +
          tmp.number(qsb_vf_auto_000_hqdn3d_chroma->value()) + ":" +
          tmp.number(qsb_vf_auto_000_hqdn3d_temporal->value());
      break;
    }
    case e_eq: {        tmp = "eq=";
      if (qsb_vf_auto_100_eq_brightness->isEnabled()) tmp += tmp.number(qsb_vf_auto_100_eq_brightness->value());
      if (qsb_vf_auto_100_eq_contrast->isEnabled()) tmp += ":" + tmp.number(qsb_vf_auto_100_eq_contrast->value());
      break;
    }
    case e_hue: {       tmp = "hue=";
      if (kdsb_vf_auto_100_hue_hue->isEnabled()) tmp += tmp.number(kdsb_vf_auto_100_hue_hue->value());
      if (kdsb_vf_auto_100_hue_saturation->isEnabled()) tmp += ":"+tmp.number(kdsb_vf_auto_100_hue_saturation->value());
      break;
    }
    case e_dint: {      tmp = "dint=";
      if (kdsb_vf_auto_100_dint_sense->isEnabled()) tmp += tmp.number(kdsb_vf_auto_100_dint_sense->value());
      if (kdsb_vf_auto_100_dint_level->isEnabled()) tmp += ":" + tmp.number(kdsb_vf_auto_100_dint_level->value());
      break;
    }
    case e_lavcdeint:   tmp = "lavcdeint";                                                     break;    
    case e_unsharp:{    tmp = "unsharp=";
      if (qcb_vf_auto_000_unsharp_luma->isChecked()) tmp += "l" +
            tmp.number(qsb_vf_auto_000_unsharp_luma_x->value()) + "x" +
            tmp.number(qsb_vf_auto_000_unsharp_luma_y->value()) + ":" +
            tmp.number(kdsb_vf_auto_000_unsharp_luma_strength->value()) + ":";
      if (qcb_vf_auto_000_unsharp_chroma->isChecked()) tmp += "c" +
            tmp.number(qsb_vf_auto_000_unsharp_chroma_x->value()) + "x" +
            tmp.number(qsb_vf_auto_000_unsharp_chroma_y->value()) + ":" +
            tmp.number(kdsb_vf_auto_000_unsharp_chroma_strength->value());
      break;
    }
    case e_boxblur: {   tmp = "boxblur=" +
      tmp.number(qsb_vf_auto_000_boxblur_radius->value()) + ":" + tmp.number(qsb_vf_auto_000_boxblur_power->value());
      break;
    }
    case e_sab: {       tmp = "sab=" +
      tmp.number(kdsb_vf_auto_000_sab_blur->value()) + ":" +
          tmp.number(kdsb_vf_auto_000_sab_pf->value()) + ":" +
          tmp.number(kdsb_vf_auto_000_sab_threshold->value());
      break;
    }
    case e_smartblur: { tmp = "smartblur=" +
      tmp.number(kdsb_vf_auto_000_smartblur_radius->value()) + ":" +
          tmp.number(kdsb_vf_auto_000_smartblur_strength->value()) + ":" +
          tmp.number(qsb_vf_auto_000_smartblur_threshold->value());
      break;
    }
    case e_delogo: {    tmp = "delogo=" +
      tmp.number(qsb_vf_auto_000_delogo_x->value()) + ":" +
          tmp.number(qsb_vf_auto_000_delogo_y->value()) + ":" +
          tmp.number(qsb_vf_auto_000_delogo_w->value()) + ":" +
          tmp.number(qsb_vf_auto_000_delogo_h->value()) + ":" +
          tmp.number(qsb_vf_auto_000_delogo_border->value());
      break;
    }
    case e_custom:      tmp = qle_vf_auto_000_vf_custom->text();                               break;
  }
  return tmp;
}
void kmenc15::showvfhelp() {
  s_vf_help->changeSize(s_vf_help->sizeHint().width(),s_vf_help->sizeHint().height() ? 0 : 6);
  khp_vf_help->view()->setHidden(!khp_vf_help->view()->isHidden());
  //callshowvf();
}
void kmenc15::vf_selected(int num) {
  qpb_vf_up->setEnabled(num);
  qpb_vf_down->setEnabled(qlb_vf->count()-num-1);
  qpb_vf_del->setEnabled(true);
  callshowvf();
}
void kmenc15::showvf() {
  if (!files.count()) return;
  
  QString tmp;
      
  //QString tmp("mkdir -p /tmp/kmenc15/;cd /tmp/kmenc15/;rm -f vf.avi vf.pnm;yuvtoppm `mencoder -of rawvideo -ovc raw -ss %1 %2 -loadidx %3 -frames 1 -o vf.avi -vf-clr -v -vf '%4',yuvcsp,format=fmt=uyvy 2> badvf.log |grep mp_image_t |tail -n 1 |sed -r 's/[^0-9]*([0-9]+)x([0-9]+)x[0-9].+/\\1 \\2/'` vf.avi 2>/dev/null | pnmpad -white -width " + opts.number(ql_vf_pic->width()) + " -height " + opts.number(ql_vf_pic->height()) + " -right 50 -bottom 50 > vf.pnm 2> /dev/null");

  if (qlb_vf->count()) {
    tmp = qlb_vf->item(0)->text();
    for (int i = 1; i <= qlb_vf->currentItem(); i++) tmp += "," + qlb_vf->item(i)->text();
    tmp += "," + createvftext();
  } else tmp = createvftext();

  tmp = QString("cd " + MyProcess::quote(tempDirectory->name()) + " && rm -f vf.avi && touch vf.avi && mplayer -osdlevel 0 -vo yuv4mpeg:file=vf.avi -ac dummy -benchmark -vf %3,format=fmt=yv12 -frames 1 %1 -loadidx %2 -ss %4 > /dev/null 2> badvf.log").arg(MyProcess::quote(files.current()->origfile), MyProcess::quote(files.current()->origidx),
                  MyProcess::quote(tmp), tmp.number(double(qsb_source_frame->value()) / files.current()->fps));
  
  MyProcess::system(tmp);
  
  ql_vf_pic->setText("");
  
  QFile tmpfile(tempDirectory->qDir()->absFilePath("vf.avi"));
  if (QFileInfo(tmpfile).size() != 0) {
    QRegExp regex;
    QByteArray data;
    int w, h;
    
    tmpfile.open(IO_ReadOnly);
    tmpfile.readLine(tmp, 0xffffff);
    
    regex.setPattern(" W(\\d+) ");
    regex.search(tmp);
    w = regex.cap(1).toInt();
    regex.setPattern(" H(\\d+) ");
    regex.search(tmp);
    h = regex.cap(1).toInt();

    if ((w & 1) || (h & 1)) {
      ql_vf_pic->unsetPalette();
      ql_vf_pic->setText("Error: width or hieght not divisable by 2.");
      return;
    }
    
    data.resize(int(w * h * 1.5));
    
    tmpfile.readLine(tmp, 0xffffff); // FRAME header
    tmpfile.readBlock(data.data(), data.size()); // first frame, dumped.
    
    tmpfile.readLine(tmp, 0xffffff); // FRAME header again
    tmpfile.readBlock(data.data(), data.size()); // the second frame, the one i want
    
    ql_vf_pic->setPixmap(i420toRgb(data, w, h));
  }
  else {
    ql_vf_pic->unsetPalette();
    tmp = "Error:\n";
    QFile tmpfile(tempDirectory->qDir()->absFilePath("badvf.log"));
    if (tmpfile.open(IO_ReadOnly)) {
      QTextStream tmpstream(&tmpfile);
      while (!tmpstream.atEnd()) tmp += tmpstream.readLine() + '\n';
      tmpfile.close();
    }
    ql_vf_pic->setText(tmp);
  }
}
void kmenc15::vf_source_selected() {
  static QStringList tmp;
  /*tmp << "<b>crop[=w:h:x:y]</b><br>"
  "<p>Crops the given part of the image and discards the rest. Useful to remove black bands from widescreen movies.<br>"
      "<p>w,h  Cropped width and height, defaults to original width and height.<br>"
      "x,y  Position of the cropped picture, defaults to center.</p></p>";*/
  //for (int i = 0; i < 20; i++) tmp << "to be written...";

  if (tmp.isEmpty()) {
    tmp << "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><HTML><HEAD><style type=\"text/css\" xml:space=\"preserve\">body {background: white none;color: black;font-family: sans-serif;}DL{margin-top: 0em; margin-bottom: 0.5em; }DT { margin-top: 1em; }.option{background-color:rgb(255,255,255);color: rgb(0,96,160); font-weight: bold;}.parameter{background-color: rgb(255,255,255);color: rgb(0,128,64);font-style:italic;} h1, h2, h3, h4, h5, h6 { color: rgb(82,80,82); background-color: transparent;} </style></HEAD><BODY BGCOLOR=\"#FFFFFF\">";
    tmp << "</BODY></HTML>";
    tmp << "<div><DL><DT><span class=\"option\">crop[=w:h:x:y]</span><DD>Crops the given part of the image and discards the rest. Useful to remove black bands from widescreen movies.<DL><DT><DD><DL><DT>w,h<DD>Cropped width and height, defaults to original width and height.<DT>x,y<DD>Position of the cropped picture, defaults to center.</DL></DL></DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">cropdetect[=0-255]</span><DD>Calculates necessary cropping parameters and prints the recommended parameters to stdout. The threshold can be optionally specified from nothing (0) to everything (255). (default: 24)</DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">expand[=w:h:x:y:o]</span><DD>Expands (not scales) movie resolution to the given value and places the unscaled original at coordinates x, y. Can be used for placing subtitles/:OSD in the resulting black bands.<DL><DT><DD><DL><DT>w,h<DD>expanded width,height (default: original width,height). Negative values for w and h are treated as offsets to the original size.<P><span class=\"parameter\">EXAMPLE:</span><DL><DT><DD><DL><DT>expand=0:-50:0:0<DD>adds a 50 pixel border to the bottom of the picture</DL></DL><DT>x,y<DD>position of original image on the expanded image (default: center)<DT>o<DD>OSD/subtitle rendering<DL><DT><DD>0: disable (default)<BR>1: enable</DL></DL></DL></DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">flip&nbsp;&nbsp;&nbsp;</span><DD>Flips the image upside down. See also option -flip.</DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">mirror&nbsp;</span><DD>Mirrors the image on the Y axis.</DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">rotate[=&lt;0-7&gt;]</span><DD>Rotates and flips (optional) the image +/:- 90 degrees. For parameters between 4-7 rotation is only done if the movie's geometry is portrait and not landscape.</DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">scale[=w:h[:interlaced[:chr_drop[:param[:presize]]]]]</span><DD>Scales the image with the software scaler (slow) and performs a YUV&lt;-&gt;RGB colorspace conversion (also see -sws option).<DL><DT><DD><DL><DT>w,h&nbsp;&nbsp;<DD>scaled width/height (default: original width/height)<BR><span class=\"parameter\">NOTE:</span> If -zoom is used, and underlying filters (including libvo) are incapable of scaling, it defaults to d_width/:d_height!<DL><DT><DD><BR>&nbsp;0:&nbsp;&nbsp;&nbsp;scaled&nbsp;d_width/:d_height<BR>-1:   original width/:height<BR>-2:   Calculate w/:h using the other dimension and the prescaled aspect ratio.<BR>-3:   Calculate w/:h using the other dimension and the original aspect ratio.</DL><DT>interlaced<DD>Toggle interlaced scaling.<DT>chr_drop<DD>chroma skipping<DL><DT><DD>0: use all available input lines for chroma<BR>1: use only every 2. input line for chroma<BR>2: use only every 4. input line for chroma<BR>3: use only every 8. input line for chroma</DL><DT>param<DD>scaling parameter (depends upon the scaling method used)<DL><DT><DD>-sws 2 (bicubic):  sharpness (0 (soft) - 100 (sharp))<BR>-sws 7 (gaussian): sharpness (0 (soft) - 100 (sharp))<BR>-sws 9 (lanczos):  filter length (1-10)</DL><DT>presize<DD>Scale to preset sizes.<DL><DT><DD>qntsc:   352x240 (NTSC quarter screen)<BR>qpal:    352x288 (PAL quarter screen)<BR>ntsc:    720x480 (standard NTSC)<BR>pal:     720x576 (standard PAL)<BR>sntsc:   640x480 (square pixel NTSC)<BR>spal:    768x576 (square pixel PAL)</DL></DL></DL></DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">format[=fourcc]</span><DD>Restricts the colorspace for the next filter without doing any conversion. Use together with the scale filter for a real conversion. For a list of available formats see format=fmt=help.<DL><DT><DD><DL><DT>fourcc<DD>format name like rgb15, bgr24, yv12, etc (default: yuy2)</DL></DL></DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">noise[=luma[u][t|a][h][p]:chroma[u][t|a][h][p]]</span><DD>Adds noise.<DL><DT><DD><DL><DT>&lt;0-100&gt;<DD>luma noise<DT>&lt;0-100&gt;<DD>chroma noise<DT>u<DD>uniform noise (gaussian otherwise)<DT>t<DD>temporal noise (noise pattern changes between frames)<DT>a<DD>averaged temporal noise (smoother, but a lot slower)<DT>h<DD>high quality (slightly better looking, slightly slower)<DT>p<DD>mix random noise with a (semi)regular pattern</DL></DL></DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">denoise3d[=luma:chroma:time]</span><DD>This filter aims to reduce image noise producing smooth images and making still images really still (This should enhance compressibility.). It can be given from 0 to 3 parameters.  If you omit a parameter, a reasonable value will be inferred.<DL><DT><DD><DL><DT>luma&nbsp;<DD>spatial luma strength (default = 4)<DT>chroma<DD>spatial chroma strength (default = 3)<DT>time&nbsp;<DD>temporal strength (default = 6)</DL></DL></DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">hqdn3d[=luma:chroma:time]</span><DD>High precision/:quality version of the denoise3d filter. Parameters and usage are the same.</DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">eq[=bright:cont]</span><DD>Software equalizer with interactive controls just like the hardware equalizer, for cards/:drivers that do not support brightness and contrast controls in hardware. Might also be useful with MEncoder, either for fixing poorly captured movies, or for slightly reducing contrast to mask artifacts and get by with lower bitrates. Initial values in the range -100-100 may be given on the command line.</DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">hue[=hue:saturation]</span><DD>Defaults are hue=0.0, saturation=1.0. Value ranges are -180-180 for hue, -2-2 for saturation (negative values result in a negative chroma).</DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">dint[=sense:level]</span><DD>Detects and drops first of interlaced frames in video stream. Values can be from 0.0 to 1.0 - first (default 0.1) is relative difference between neighbor pixels, second (default 0.15) is what part of image have to be detected as interlaced to drop the frame.</DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">lavcdeint</span><DD>Use libavcodec's deinterlace filter.</DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">unsharp=l|cWxH:amount[:l|cWxH:amount]</span><DD>Unsharp mask / gaussian blur.<DL><DT><DD><DL><DT>l<DD>Apply effect on luma component.<DT>c<DD>Apply effect on chroma components.<DT>WxH<DD>width and height of the matrix, odd sized in both directions (min = 3x3, max = 13x11 or 11x13, usually something between 3x3 and 7x7)<DT>amount<DD>Relative amount of sharpness/:blur to add to the image (a sane range should be -1.5-1.5).<DL><DT><DD>&lt;0: blur<BR>&gt;0: sharpen</DL></DL></DL></DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">boxblur=radius:power[:radius:power]</span><DD>box blur<DL><DT><DD><DL><DT>radius<DD>size of the filter<DT>power<DD>How often the filter should be applied.</DL></DL></DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">sab=rad:pf:colorDiff[:rad:pf:colorDiff]</span><DD>shape adaptive blur<DL><DT><DD><DL><DT>rad&nbsp;&nbsp;&nbsp;<DD>blur filter strength (~0.1-4.0) (slower if larger)<DT>pf&nbsp;&nbsp;&nbsp;<DD>prefilter strength (~0.1-2.0)<DT>colorDiff<DD>How different the pixels are allowed to be considered. (~0.1-100.0)</DL></DL></DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">smartblur=rad:strength:thresh[:rad:strength:thresh]</span><DD>smart blur<DL><DT><DD><DL><DT>rad&nbsp;&nbsp;<DD>blur filter strength (~0.1-5.0) (slower if larger)<DT>strength<DD>blur (0.0-1.0) or sharpen (-1.0-0.0)<DT>thresh<DD>filter all (0), filter flat areas (0-30) or filter edges (-30-0)</DL></DL></DL></div>";
    tmp << "<div><DL><DT><span class=\"option\">delogo[=x:y:w:h:t]</span><DD>Suppresses a TV station logo by a simple interpolation of the surrounding pixels. Just set a rectangle covering the logo and watch it disappear (and sometimes something even uglier appear - your mileage may vary).<DL><DT><DD><DL><DT>x,y<DD>Position of the top left corner of the logo.<DT>w,h<DD>Width and height of the cleared rectangle.<DT>t<DD>Thickness of the fuzzy edge of the rectangle (added to w and h). When set to -1, a green rectangle is drawn on the screen to simplify finding the right x,y,w,h parameters.</DL></DL></DL></div>";

    tmp << "<span class=\"option\">All help relavent to MPlayer-1.0pre5.</span><br><br><H2>VIDEO FILTERS</H2><div>Video filter are plugins that allow you to modify the video stream and its properties. The syntax is:<br><br><DL>"
        "<DT><span class=\"option\">filter1[=parameters]</span><DD></DL><br><br>The parameters are optional and if omitted, some of them are set to default values. Use '-1' to keep the default value. Parameters w:h means width x height in pixels, x:y means x;y position counted from the upper left corner of the bigger image.<BR><span class=\"parameter\">NOTE:</span> To get a full list of available filters, see -vf help.<br><br>With filters that support it, you can access parameters by their name.<br><br><DL>"
        "<DT><span class=\"option\">-vf &lt;filter&gt;=help</span><DD>Prints the parameter names and parameter value ranges for a particular filter."
        "<DT><span class=\"option\">-vf &lt;filter=named_parameter1=value1[:named_parameter2=value2:...]&gt;</span><DD>Sets a named parameter to the given value. Use on and off or yes and no to set flag parameters.</DL><br><br>Available filters are:"
        "<DT><span class=\"option\">rectangle[=w:h:x:y]</span><DD>The plugin responds to the input.conf directive 'change_rectangle' that takes two parameters.<DL><DT><DD><DL><DT>w,h<DD>width and height (default: -1, maximum possible width where boundaries are still visible.<DT>x,y<DD>top left corner position (default: -1, uppermost leftmost)</DL></DL>"
        "<DT><span class=\"option\">dsize={aspect|w:h}</span><DD>Changes the intended display size/aspect at an arbitrary point in the filter chain. Aspect can be given as a fraction (4/3) or floating point number (1.33). Alternatively, you may specify the exact display width and height desired. Note that this filter does NOT do any scaling itself; it just affects what later scalers (software or hardware) will do when auto-scaling to correct aspect."
        "<DT><span class=\"option\">yuy2&nbsp;&nbsp;&nbsp;</span><DD>Forces software YV12/:I420 or 422P to YUY2 conversion. Useful for video cards/:drivers with slow YV12 but fast YUY2 support."
        "<DT><span class=\"option\">yvu9&nbsp;&nbsp;&nbsp;</span><DD>Forces software YVU9 to YV12 colorspace conversion. Deprecated in favor of the software scaler."
        "<DT><span class=\"option\">yuvcsp&nbsp;</span><DD>Clamps YUV color values to the CCIR 601 range without doing real conversion."
        "<DT><span class=\"option\">rgb2bgr[=swap]</span><DD>RGB 24/:32 &lt;-&gt; BGR 24/:32 colorspace conversion.<DL><DT><DD><DL><DT>swap&nbsp;<DD>Also perform  R &lt;-&gt; B swapping.</DL></DL>"
        "<DT><span class=\"option\">palette</span><DD>RGB/:BGR 8 -&gt; 15/:16/:24/:32bpp colorspace conversion using palette."
        "<DT><span class=\"option\">noformat[=fourcc]</span><DD>Restricts the colorspace for the next filter without doing any conversion. Unlike the format filter, this will allow any colorspace <span class=\"option\">except</span> the one you specify. For a list of available formats see noformat=fmt=help.<DL><DT><DD><DL><DT>fourcc<DD>format name like rgb15, bgr24, yv12, etc (default: yv12)</DL></DL>"
        "<DT><span class=\"option\">pp[=filter1[:option1[:option2...]]/[-]filter2...] (see -pphelp too)</span><DD>This option enables usage of MPlayer's internal postprocessing filter, and also gives an interface where you can pass options to the named filter. To get a list of available filters, use -pphelp. Note that each sub-filter must be separated with a / sign.<BR>Each filter defaults to 'c' (chrominance).<BR>The keywords accept a '-' prefix to disable the option.<BR>A ':' followed by a letter may be appended to the option to indicate its scope:<DL><DT><DD><DL><DT>a<DD>Automatically switches the filter off if the CPU is too slow.<DT>c<DD>Do chrominance filtering, too.<DT>y<DD>Do not do chrominance filtering (only luminance filtering).</DL></DL><P><DL><DT><DD><span class=\"parameter\">EXAMPLE:</span> </DL><DL><DT><DD><DL><DT>-vf pp=hb/vb/dr/al<DD>horizontal and vertical deblocking, deringing and automatic brightness/:contrast<DT>-vf pp=hb/vb/dr/al/lb<DD>horizontal and vertical deblocking, deringing, automatic brightness/:contrast and linear blend deinterlacer<DT>-vf pp=de/-al<DD>default filters without brightness/:contrast correction<DT>-vf pp=de/tn:1:2:3<DD>Enable default filters &amp; temporal denoiser.<DT>-vf pp=hb:y/vb:a -autoq 6<DD>Deblock horizontal only luminance and switch vertical deblocking on or off automatically depending on available CPU time.</DL></DL>"
        "<DT><span class=\"option\">spp[=quality[:qp[:mode]]]</span><DD>simple postprocessing filter<DL><DT><DD><DL><DT>quality<DD>0-6 (default: 3)<DT>qp&nbsp;&nbsp;&nbsp;<DD>force quantization parameter (default: 0, use qp from video)<DT>mode&nbsp;&nbsp;&nbsp;<DD>0: hard thresholding (default)<BR>1: soft thresholding (better deringing, but blurrier)</DL></DL>"
        "<DT><span class=\"option\">qp=equation</span><DD>qp change filter<DL><DT><DD><DL><DT>equation<DD>some equation like &quot;2+2*sin(PI*qp)&quot;</DL></DL>"
        "<DT><span class=\"option\">test&nbsp;&nbsp;&nbsp;</span><DD>Generate various test patterns."
        "<DT><span class=\"option\">rgbtest</span><DD>Generate an RGB test pattern useful for detecting RGB vs BGR issues. You should see a red, green and blue stripe from top to bottom."
        "<DT><span class=\"option\">lavc[=quality:fps]</span><DD>Fast software YV12 to MPEG1 conversion with libavcodec for use with DVB/:DXR3. Faster and of better quality than -vf fame.<DL><DT><DD><DL><DT>quality<DD><DL><DT><DD>1-31: fixed qscale<BR>32-:  fixed bitrate in kBits</DL><DT>fps&nbsp;&nbsp;<DD>force output fps (float value) (default: 0, autodetect based on height)</DL></DL>"
        "<DT><span class=\"option\">fame&nbsp;&nbsp;&nbsp;</span><DD>Fast software YV12 to MPEG1 conversion with libfame for use with DVB/:DXR3."
        "<DT><span class=\"option\">dvbscale[=aspect]</span><DD>Set up optimal scaling for DVB cards, scaling the X axis in hardware and calculating the Y axis scaling in software to keep aspect. It's only useful together with expand+scale (-vf dvbscale,scale=-1:0,expand=-1:576:-1:-1:1,lavc).<DL><DT><DD><DL><DT>aspect<DD>control aspect ratio, calculate as DVB_HEIGHT*ASPECTRATIO (default: 576*4/3=768), set it to 576*(16/9)=1024 for a 16:9 TV.</DL></DL>"
        "<DT><span class=\"option\">eq2[=gamma:contrast:brightness:saturation:rg:gg:bg:weight]</span><DD>Alternative software equalizer that uses lookup tables (very slow), allowing gamma correction in addition to simple brightness and contrast adjustment. Note that it uses the same MMX optimized code as -vf eq if all gamma values are 1.0. The parameters are given as floating point values. Parameters rg, gg, bg are the independent gamma values for the Red, Green and Blue components. The weight parameter can be used to reduce the effect of a high gamma value on bright image areas, e.g. keep them from getting overamplified and just plain white. A value of 0.0 turns the gamma correction all the way down while 1.0 leaves it at its full strength. Defaults are gamma=1.0, contrast=1.0, brightness=0.0, saturation=1.0, weight=1.0. Value ranges are 0.1-10 for gamma, -2-2 for contrast (negative values result in a negative image), -1-1 for brightness, 0-3 for saturation and 0-1 for weight."
        "<DT><span class=\"option\">halfpack[=f]</span><DD>Convert planar YUV 4:2:0 to half-height packed 4:2:2, downsampling luma but keeping all chroma samples. Useful for output to low-resolution display devices when hardware downscaling is poor quality or is not available. Can also be used as a primitive luma-only deinterlacer with very low cpu usage. By default, halfpack averages pairs of lines when downsampling. The optional parameter f can be 0 to only use even lines, or 1 to only use odd lines. Any other value for f gives the default (averaging) behavior."
        "<DT><span class=\"option\">ilpack[=mode]</span><DD>When interlaced video is stored in YUV 4:2:0 formats, chroma interlacing does not line up properly due to vertical downsampling of the chroma channels. This filter packs the planar 4:2:0 data into YUY2 (4:2:2) format with the chroma lines in their proper locations, so that in any given scanline, the luma and chroma data both come from the same field. The optional argument selects the sampling mode. By default, linear interpolation (mode 1) is used. Mode 0 uses nearest-neighbor sampling, which is fast but incorrect."
        "<DT><span class=\"option\">harddup</span><DD>Only useful with MEncoder. If harddup is used when encoding, it will force duplicate frames to be encoded in the output. This uses slightly more space, but is necessary for output to MPEG files or if you plan to demux and remux the video stream after encoding. Should be placed at or near the end of the filter chain unless you have a good reason to do otherwise."
        "<DT><span class=\"option\">softskip</span><DD>Only useful with MEncoder. Softskip moves the frame skipping (dropping) step of encoding from before the filter chain to some point during the filter chain. This allows filters which need to see all frames (inverse telecine, temporal denoising, etc.) to function properly. Should be placed after the filters which need to see all frames and before any subsequent filters that are CPU-intensive."
        "<DT><span class=\"option\">decimate[=max:hi:lo:frac]</span><DD>Drops frames that don't differ greatly from the previous frame in order to reduce framerate. The argument max (if positive) sets the maximum number of consecutive frames which can be dropped, or (if negative) the minimum interval between dropped frames. A frame is a candidate for dropping if no 8x8 region differs by more than a threshold of hi, and if not more than frac portion (1 meaning the whole image) differs by more than a threshold of lo. Values of hi and lo are for 8x8 pixel blocks and represent actual pixel value differences, so a threshold of 64 corresponds to 1 unit of difference for each pixel, or the same spread out differently over the block. The main use of this filter is for very-low-bitrate encoding (e.g. streaming over dialup modem), but it could in theory be used for fixing movies that were inverse-telecined incorrectly."
        "<DT><span class=\"option\">kerndeint[=thresh[:map[:order[:sharp[:twoway]]]]]</span><DD>Donald Graft's adaptive kernel deinterlacer. Deinterlaces parts of a video if a configurable threshold is exceeded.<DL><DT><DD><DL><DT>thresh (0 - 255)<DD>Threshold (default 10).<DT>map (0 or 1)<DD>Paint pixels which exceed the threshold white (default: 0).<DT>order (0 or 1)<DD>Swap fields if 1 (default: 0).<DT>sharp (0 or 1)<DD>Enable additional sharpening (default: 0).<DT>twoway (0 or 1)<DD>Enable twoway sharpening (default: 0).</DL></DL>"
        "<DT><span class=\"option\">swapuv&nbsp;</span><DD>Swap U &amp; V plane."
        "<DT><span class=\"option\">il=[d|i][s][:[d|i][s]]</span><DD>(de)interleaves lines. The goal of this filter is to add the ability to process interlaced images pre-field without deinterlacing them. You can filter your interlaced DVD and play it on a TV without breaking the interlacing. While deinterlacing (with the postprocessing filter) removes interlacing permanently (by smoothing, averaging, etc) deinterleaving splits the frame into 2 fields (so called half pictures), so you can process (filter) them independently and then re-interleave them.<DL><DT><DD><DL><DT>d<DD>deinterleave (placing one above the other)<DT>i<DD>interleave<DT>s<DD>swap fields (exchange even &amp; odd lines)</DL></DL>"
        "<DT><span class=\"option\">fil=[i|d]</span><DD>(de)interleaves lines. This filter is very similar to the il filter but much faster, the main disadvantage is that it doesn't always work. Especially if combined with other filters it may produce randomly messed up images, so be happy if it works but don't complain if it doesn't for your combination of filters.<DL><DT><DD><DL><DT>d<DD>Deinterleave fields, placing them side by side.<DT>i<DD>Interleave fields again (reversing the effect of fil=d).</DL></DL>"
        "<DT><span class=\"option\">field[=n]</span><DD>Extracts a single field from an interlaced image using stride arithmetic to avoid wasting CPU time. The optional argument n specifies whether to extract the even or the odd field (depending on whether n is even or odd)."
        "<DT><span class=\"option\">detc[=var1=value2:var2=value2:...]</span><DD>Attempts to reverse the 'telecine' process to recover a clean, non-interlaced stream at film framerate. This was the first and most primitive inverse telecine filter to be added to MPlayer/MEncoder. It works by latching onto the telecine 3:2 pattern and following it as long as possible. This makes it suitable for perfectly-telecined material, even in the presence of a fair degree of noise, but it will fail in the presence of complex post-telecine edits. Development on this filter is no longer taking place, as ivtc, pullup, and filmdint are better for most applications. The following arguments (see syntax above) may be used to control detc's behavior:<DL><DT><DD><DL><DT>dr<DD>Set the frame dropping mode. 0 (default) means don't drop frames to maintain fixed output framerate. 1 means always drop a frame when there have been no drops or telecine merges in the past 5 frames. 2 means always maintain exact 5:4 input to output frame ratio. <span class=\"parameter\">NOTE:</span> Use mode 1 or 2 with MEncoder.<DT>am<DD>Analysis mode. Available values are 0 (fixed pattern with initial frame number specified by fr=#) and 1 (agressive search for telecine pattern). Default is 1.<DT>fr<DD>Set initial frame number in sequence. 0-2 are the three clean progressive frames; 3 and 4 are the two interlaced frames. The default, -1, means 'not in telecine sequence'. The number specified here is the type for the imaginary previous frame before the movie starts.<DT>tr0, tr1, tr2, tr3<DD>Threshold values to be used in certain modes.</DL></DL>"
        "<DT><span class=\"option\">ivtc[=1]</span><DD>Experimental 'stateless' inverse telecine filter. Rather than trying to lock on to a pattern like the detc filter does, ivtc makes its decisions independently for each frame. This will give much better results for material that has undergone heavy editing after telecine was applied, but as a result it is not as forgiving of noisy input, for example TV capture. The optional parameter (ivtc=1) corresponds to the dr=1 option for the detc filter, and should be used with MEncoder but not with MPlayer. As with detc, you must specify the correct output framerate (-ofps 23.976) when using MEncoder. Further development on ivtc has stopped, as the pullup and filmdint filters appear to be much more accurate."
        "<DT><span class=\"option\">pullup[=jl:jr:jt:jb:sb]&nbsp;</span><DD>Third-generation pulldown reversal (inverse telecine) filter, capable of handling mixed hard-telecine, 24 fps progressive, and 30 fps progressive content. The pullup filter is designed to be much more robust than detc or ivtc, by taking advantage of future context in making its decisions. Like ivtc, pullup is stateless in the sense that it does not lock onto a pattern to follow, but it instead looks forward to the following fields in order to identify matches and rebuild progressive frames. It is still under development, but believed to be quite accurate. The jl, jr, jt, and jb options set the amount of &quot;junk&quot; to ignore at the left, right, top, and bottom of the image, respectively. Left/right are in units of 8 pixels, while top/bottom are in units of 2 lines. The default is 8 pixels on each side. Setting the sb (strict breaks) option to 1 will reduce the chances of pullup generating an occasional mismatched frame, but it may also cause an excessive number of frames to be dropped during high motion sequences. <span class=\"parameter\">NOTE:</span> Always follow pullup with the softskip filter when encoding to ensure that pullup is able to see each frame. Failure to do so will lead to incorrect output and will usually crash, due to design limitations in the codec/filter layer."
        "<DT><span class=\"option\">filmdint[=options]</span><DD>Inverse telecine filter, similar to the pullup filter above. It is designed to handle any pulldown pattern, including mixed soft and hard telecine and limited support for movies that are slowed down or sped up from their original framerate for TV. Only the luma plane is used to find the frame breaks. If a field has no match, it is deinterlaced with simple linear approximation. If the source is MPEG-2, and this must be the first filter to allow access to the field-flags set by the MPEG-2 decoder. Depending on the source mpeg, you may be fine ignoring this advice, as long as you do not see lots of &quot;Bottom-first field&quot; warnings. With no options it does normal inverse telecine, and should be used together with mencoder -fps 29.97 -ofps 23.976. When this filter is used with mplayer, it will result in an uneven framerate during playback, but it is still generally better than using pp=lb or no deinterlacing at all. Multiple options can be specified separated by /.<DL><DT><DD><DL><DT>crop=w:h:x:y<DD>Just like the crop filter, but faster, and works on mixed hard and soft telecined content as well as when y is not a multiple of 4. If x or y would require cropping fractional pixels from the chroma planes, the crop area is extended. This usually means that x and y must be even.<DT>io=ifps:ofps<DD>For each ifps input frames the filter will output ofps frames. The ratio of ifps/ofps should match the -fps/-ofps ratio. This could be used to filter movies that are broadcast on TV at a frame rate different from their original frame rate.<DT>luma_only=n<DD>If n is nonzero, the chroma plane is copied unchanged. This is useful for YV12 sampled TV, which discards one of the chroma fields.<DT>mmx2=n<DD>On x86, if n=1, use MMX2 optimized functions, if n=2, use 3DNow! optimized functions, othewise, use plain C. If this option is not specified, MMX2 and 3DNow! are auto-detected, use this option to override auto-detection.<DT>fast=n<DD>The larger n will speed up the filter at the expense of accuracy. The default value is n=3. If n is odd, a frame immediately following a frame marked with the REPEAT_FIRST_FIELD mpeg flag is assumed to be progressive, thus filter will not spend any time on soft-telecined MPEG-2 content. This is the only effect of this flag if MMX2 or 3DNow! is available. Without MMX2 and 3DNow, if n=0 or 1, the same calculations will be used as with n=2 or 3. If n=2 or 3, the number of luma levels used to find the frame breaks is reduced from 256 to 128, which results in a faster filter without losing much accuracy. If n=4 or 5, a faster, but much less accurate metric will be used to find the frame breaks, which is more likely to misdetect high vertical detail as interlaced content.<DT>verbose=n<DD>If n is nonzero, print the detailed metrics for each frame. Useful for debugging.<DT>dint_thres=n<DD>Deinterlace threshold. Used during de-interlacing of unmatched frames. Larger value means less deinterlacing, use n=256 to completely turn off deinterlacing. Default is n=8.<DT>comb_thres=n<DD>Threshold for comparing a top and bottom fields. Defaults to 128.<DT>diff_thres=n<DD>Threshold to detect temporal change of a field. Default is 128.<DT>sad_thres=n<DD>Sum of Absolute Difference threshold, default is 64.</DL></DL>"
        "<DT><span class=\"option\">softpulldown</span><DD>This filter works only correct with MEncoder and acts on the MPEG2 flags used for soft 3:2 pulldown (soft telecine). If you want to use the ivtc or detc filter on movies that are partly soft telecined, inserting this filter before them should make them more reliable. Currently only libmpeg2 exports the needed flags. If used on material that does not set them, the filter does nothing."
        "<DT><span class=\"option\">divtc[=options]</span><DD>Inverse telecine for deinterlaced video. If 3:2-pulldown telecined video has lost one of the fields or is deinterlaced using a method that keeps one field and interpolates the other, the result is a juddering video that has every fourth frame duplicated. This filter is intended to find and drop those duplicates and restore the original film frame rate. When using this filter, you must specify -ofps that is 4/5 of the fps of the input file (23.976 if the input is 29.97fps). The options are:<DL><DT><DD><DL><DT>pass=1|2<DD>Use two-pass mode. This produces best results. Pass 1 analyzes the video and writes the results to a log file. Pass 2 then reads this log file and uses the information to do the actual work. Note that these passes do NOT correspond to pass 1 and 2 of the encoding process. In order to use divtc two-pass with two-pass video encoding, you must perform three passes: first divtc pass 1 and encoder pass 1, then divtc pass 2 and encoder pass 1, and finally divtc pass 2 and encoder pass 2.<DT>file=filename<DD>Set the 2-pass log file name (default: &quot;framediff.log&quot;).<DT>threshold=value<DD>Set the minimum strength the telecine pattern must have for the filter to believe in it (default: 0.5). This is used to avoid recognizing false pattern from the parts of the video that are very dark or very still.<DT>window=numframes<DD>Set the number of past frames to look at when searching for pattern (default: 30). Longer window improves the reliability of the pattern search, but shorter window improves the reaction time to the changes in the telecine phase. This only affects the one-pass mode. The two-pass mode currently uses fixed window that extends to both future and past.<DT>phase=0|1|2|3|4<DD>Sets the initial telecine phase for one-pass mode (default: 0). The two-pass mode can see the future, so it is able to use the correct phase from the beginning, but one-pass mode can only guess. It catches the correct phase when it finds it, but this option can be used to fix the possible juddering at the beginning. The first pass of the two-pass mode also uses this, so if you save the output from the first pass, you get constant phase result.<DT>deghost=value<DD>Set the deghosting threshold (0-255 for one-pass mode, -255-255 for two-pass mode, default 0). If nonzero, deghosting mode is used. This is for video that has been deinterlaced by blending the fields together instead of dropping one of the fields. Deghosting amplifies any compression artifacts in the blended frames, so the parameter value is used as a threshold to exclude those pixels from deghosting that differ from the previous frame less than specified value. If two-pass mode is used, then negative value can be used to make the filter analyze the whole video in the beginning of pass-2 to determine whether it needs deghosting or not and then select either zero or the absolute value of the parameter. Specify this option for pass-2, it makes no difference on pass-1.</DL></DL>"
        "<DT><span class=\"option\">phase=[t|b|p|a|u|T|B|A|U][:v]</span><DD>Delay interlaced video by one field time so that the field order changes. The intended use is to fix PAL movies that have been captured with the opposite field order to the film-to-video transfer. The options are:<DL><DT><DD><DL><DT>t<DD>Capture field order top-first, transfer bottom-first. Filter will delay the bottom field.<DT>b<DD>Capture bottom-first, transfer top-first. Filter will delay the top field.<DT>p<DD>Capture and transfer with the same field order. This mode only exists for the documentation of the other options to refer to, but if you actually select it, the filter will faithfully do nothing ;-)<DT>a<DD>Capture field order determined automatically by field flags, transfer opposite. Filter selects among t and b modes on a frame by frame basis using field flags. If no field information is available, then this works just like u.<DT>u<DD>Capture unknown or varying, transfer opposite. Filter selects among t and b on a frame by frame basis by analyzing the images and selecting the alternative that produces best match between the fields.<DT>T<DD>Capture top-first, transfer unknown or varying. Filter selects among t and p using image analysis.<DT>B<DD>Capture bottom-first, transfer unknown or varying. Filter selects among b and p using image analysis.<DT>A<DD>Capture determined by field flags, transfer unknown or varying. Filter selects among t, b and p using field flags and image analysis. If no field information is available, then this works just like U. This is the default mode.<DT>U<DD>Both capture and transfer unknown or varying. Filter selects among t, b and p using image analysis only.<DT>v<DD>Verbose operation. Prints the selected mode for each frame and the average squared difference between fields for t, b, and p alternatives.</DL></DL>"
        "<DT><span class=\"option\">telecine[=start]</span><DD>Apply 3:2 'telecine' process to increase framerate by 20%. This most likely will not work correctly with MPlayer, but it can be used with 'mencoder -fps 29.97 -ofps 29.97 -vf telecine'. Both fps options are essential! (A/V sync will break if they are wrong.) The optional start parameter tells the filter where in the telecine pattern to start (0-3)."
        "<DT><span class=\"option\">tinterlace[=mode]</span><DD>Temporal field interlacing - merge pairs of frames into an interlaced frame, halving the framerate. Even frames are moved into the upper field, odd frames to the lower field. This can be used to fully reverse the effect of the tfields filter (in mode 0). Available modes are:<DL><DT><DD><DL><DT>0<DD>odd frames into upper field, even to lower, generating a full-height frame at half the framerate<DT>1<DD>only output odd frames, even frames are dropped, height unchanged<DT>2<DD>only output even frames, odd frames are dropped, height unchanged<DT>3<DD>expand each frame to full height, but pad alternate lines with black, framerate unchanged</DL></DL>"
        "<DT><span class=\"option\">tfields[=mode]</span><DD>Temporal field separation - split fields into frames, doubling the output framerate. Like the telecine filter, tfields will only work properly with MEncoder, and only if both -fps and -ofps are set to the desired (double) framerate! Available modes are:<DL><DT><DD><DL><DT>0<DD>leave fields unchanged (this will jump/flicker)<DT>1<DD>interpolate missing lines (the algorithm used might not be so good)<DT>2<DD>translate fields by 1/4 pixel with linear interp (no jump)<DT>4<DD>translate fields by 1/4 pixel with 4tap filter (higher quality)</DL></DL>"
        "<DT><span class=\"option\">perspective=x0:y0:x1:y1:x2:y2:x3:y3:t</span><DD>perspective correction<DL><DT><DD><DL><DT>x0,y0,...<DD>coordinates of the top left, top right, bottom left, bottom right corners<DT>t&nbsp;&nbsp;&nbsp;&nbsp;<DD>linear (0) or cubic resampling (1)</DL></DL>"
        "<DT><span class=\"option\">2xsai&nbsp;&nbsp;</span><DD>Use the 2x scale and interpolate algorithm for scaling and smoothing images."
        "<DT><span class=\"option\">1bpp&nbsp;&nbsp;&nbsp;</span><DD>1bpp bitmap to YUV/BGR 8/15/16/32 conversion"
        "<DT><span class=\"option\">down3dright[=lines]</span><DD>Reposition and resize stereoscopic images. Extracts both stereo fields and places them side by side, resizing them to maintain the original movie aspect.<DL><DT><DD><DL><DT>lines<DD>number of lines to select from the middle of the image (default: 12)</DL></DL>"
        "<DT><span class=\"option\">bmovl=hidden:opaque:&lt;fifo&gt;</span><DD>Read bitmaps from a FIFO and display them in a window.<DL><DT><DD><DL><DT>hidden<DD>sets the default value of the 'hidden' flag (boolean)<DT>opaque<DD>flag switching between alphablended (transparent) and opaque (fast) mode<DT>fifo&nbsp;<DD>path/filename for the FIFO (named pipe connecting mplayer -vf bmovl to the controlling application)</DL></DL><P><DL><DT><DD>FIFO commands are:</DL><DL><DT><DD><DL><DT>RGBA32 width height xpos ypos alpha clear<DD>followed by width*height*4 Bytes of raw RGBA32 data.<DT>ABGR32 width height xpos ypos alpha clear<DD>followed by width*height*4 Bytes of raw ABGR32 data.<DT>RGB24 width height xpos ypos alpha clear<DD>followed by width*height*3 Bytes of raw RGB32 data.<DT>BGR24 width height xpos ypos alpha clear<DD>followed by width*height*3 Bytes of raw BGR32 data.<DT>ALPHA width height xpos ypos alpha<DD>change alpha for area<DT>CLEAR width height xpos ypos<DD>clear area<DT>OPAQUE<DD>disable all alpha transparency. Send &quot;ALPHA 0 0 0 0 0&quot; to enable it again.<DT>HIDE&nbsp;<DD>hide bitmap<DT>SHOW&nbsp;<DD>show bitmap</DL></DL><P><DL><DT><DD>Arguments are:</DL><DL><DT><DD><DL><DT>width, height<DD>size of image/area<DT>xpos, ypos<DD>start blitting at X/Y position<DT>alpha<DD>set alpha difference. If you set this to -255 you can then send a sequence of ALPHA-commands to set the area to -225, -200, -175 etc for a nice fade-in-effect! ;)<DL><DT><DD>0:    same as original<BR>255:  makes everything opaque<BR>-255: makes everything transparent</DL><DT>clear<DD>clear the framebuffer before blitting.<DL><DT><DD>0: The image will just be blitted on top of the old one, so you don't need to send 1,8MB of RGBA32 data everytime a small part of the screen is updated.<BR>1: clear</DL></DL></DL>"
        "<DT><span class=\"option\">framestep=I|[i]step</span><DD>Renders only every nth frame or every Intra (key) frame.<P>If you call the filter with I (uppercase) as the parameter, then ONLY  keyframes are rendered. For DVDs it generally means one in every 15/12  frames (IBBPBBPBBPBBPBB), for AVI it means every scene change or every keyint value (see -lavcopts keyint= value if you use MEncoder to encode the video).<P>When a key frame is found, an 'I!' string followed by a newline character is printed, leaving the current line of mplayer/mencoder output on the screen, because it contains the time (in seconds) and frame number of the keyframe (You can use this information to split the AVI.).<P>If you call the filter with a numeric parameter 'step' then only one in every 'step' frames is rendered.<P>If you put an 'i' (lowercase) before the number then an I! is printed  (like the I parameter).<P>If you give only the i then nothing is done to the frames, only I! is  printed."
        "<DT><span class=\"option\">tile=xtile:ytile:output:start:delta</span><DD>Tile a series of images into a single, bigger image. If you omit a parameter or use a value less than 0, then the default value is used. You can also stop when you're OK (... -vf tile=10:5 ...) It is probably a good idea to put the scale filter before the tile :-)<BR>The parameters are:<P><DL><DT><DD><DL><DT>xtile<DD>number of tiles on the x axis (default: 5)<DT>ytile<DD>number of tiles on the y axis (default: 5)<DT>output<DD>Render the tile when 'output' number of frames are reached, where 'output' should be a number less than xtile * ytile. Missing tiles are left blank. You could, for example, write an 8 * 7 tile every 50 frames to have one image every 2 seconds @ 25 fps.<DT>start<DD>pixel at the start (x/y) (default: 2)<DT>delta<DD>pixel between 2 tiles, (x/y) (default: 4)</DL></DL>"
        "<DT><span class=\"option\">zrmjpeg[=options]</span><DD>Software YV12 to MJPEG encoder for use with the zr2 video output device.<DL><DT><DD><DL><DT>maxheight=h|maxwidth=w<DD>These options set the maximum width and height the zr card can handle (the MPlayer filter layer currently cannot query those).<DT>{dc10+,dc10,buz,lml33}-{PAL|NTSC}<DD>Use these options to set maxwidth and maxheight automatically to the  values known for card/mode combo. For example, valid options are: dc10-PAL and buz-NTSC (default: dc10+PAL)<DT>color|bw<DD>Select color or black and white encoding. Black and white encoding is faster. Color is the default.<DT>hdec={1,2,4}<DD>Horizontal decimation 1, 2 or 4.<DT>vdec={1,2,4}<DD>Vertical decimation 1, 2 or 4.<DT>quality=1-20<DD>Set JPEG compression quality [BEST] 1 - 20 [VERY BAD].<DT>fd|nofd<DD>By default, decimation is only performed if the Zoran hardware can upscale the resulting MJPEG images to the original size. The option fd instructs the filter to always perform the requested decimation (ugly).</DL></DL></div>";
  }

  khp_vf_help->begin();
  khp_vf_help->write(tmp[0]);
  khp_vf_help->write(tmp[qlb_vf_source->currentItem() + 2]);
  khp_vf_help->write(tmp[1]);
  khp_vf_help->end();

  qpb_vf_add->setEnabled(true);
  callshowvf();
}
void kmenc15::callshowvf() {
  static QTimer timervf;
  static bool connected = false;
  if (!connected) connect(&timervf, SIGNAL(timeout()), this, SLOT(showvf()));
  connected = true;
  
  if (!qpb_vf_preview->isOn()) timervf.start(500, true);
}

void kmenc15::qsb_crop_x_valueChanged(int i) {
  static int cur = 0;
  if (qpb_crop_locked->isOn())
    qsb_vf_auto_000_crop_w->setValue(qsb_vf_auto_000_crop_w->value() + ((((cur + 1) >> 1) - ((i + 1) >> 1)) << 1));
  cur = i;
}
void kmenc15::qsb_crop_y_valueChanged(int i) {
  static int cur = 0;
  if (qpb_crop_locked->isOn() && qrb_crop_custom->isChecked())
    qsb_vf_auto_000_crop_h->setValue(qsb_vf_auto_000_crop_h->value() + ((((cur + 1) >> 1) - ((i + 1) >> 1)) << 1));
  cur = i;
}
void kmenc15::qsb_crop_w_valueChanged() {
  if (qbg_crop->selectedId())
    qsb_vf_auto_000_crop_h->setValue(2*(int)(0.5*(double)qsb_vf_auto_000_crop_w->value() *
        (qbg_crop->selectedId() == 1 ? 9./16 : 3./4)));
  callshowvf();
}

void kmenc15::qcb_mp3lame_manual_vbr_highlighted(int tmp) {
  qsb_mp3lamem_auto_011_br->setEnabled(tmp == 0 || tmp == 3);
  qcb_mp3lamem_auto_010_q->setEnabled(tmp == 3);
  qsb_mp3lamem_auto_111_q->setEnabled(tmp == 3 && qcb_mp3lamem_auto_010_q->isChecked());
}
void kmenc15::qcb_mp3lame_preset_highlighted(int tmp) {
  qbg_mp3lamep_preset->setEnabled(tmp == 4);
  qcb_mp3lamep_auto_011_fast->setEnabled(tmp != 4);
}
void kmenc15::qrb_xvid_2pass_toggled(bool tmp) {
  qcb_xvid_auto_011_mod_quant->setEnabled(tmp);
  qcb_xvid_auto_010_min_key_interval->setEnabled(tmp);
  qcb_xvid_auto_010_keyframe_boost->setEnabled(tmp);
  qcb_xvid_auto_010_kfreduction->setEnabled(tmp);
  qsb_xvid_auto_111_min_key_interval->setEnabled(tmp && qcb_xvid_auto_010_min_key_interval->isChecked());
  qsb_xvid_auto_111_keyframe_boost->setEnabled(tmp && qcb_xvid_auto_010_keyframe_boost->isChecked());
  qsb_xvid_auto_111_kfreduction->setEnabled(tmp && qcb_xvid_auto_010_kfreduction->isChecked());
}
void kmenc15::qrb_lavc_2pass_toggled(bool tmp) {
  kdsb_lavc_auto_111_vqblur->setMaxValue(tmp?99.:1.);
  kdsb_lavc_auto_111_vqblur->setLineStep(tmp?.1:.01);
}

void kmenc15::shell_com() {
  static bool perltmp = MyProcess::system("perl -v &> /dev/null") == 0;
  int tmppass = globalpass;
  uint totframes = 0;
  for (QPtrListIterator<MovieFile> it(files); *it; ++it) totframes += (uint)((*it)->end - (*it)->start);
  uint TOTframes = totframes * (tmppass ? 2 : 1);

  if (!qcb_shell->isChecked()) {
    QStringList tmp;
    for (QValueList<QStringList>::iterator it = fullcommand.begin(); it != fullcommand.end(); it++)
      tmp << (*it).join(" ");
    qtb_command->setText(tmp.join("\n"));
    return;
  }

  QString shell("#!/bin/bash\n");
  if (!perltmp && qbg_speed->selectedId()) shell += "# Ack, no perl found. Thats ok. Shame though.\n";
  for (QValueListIterator<QStringList> it = fullcommand.begin(); it != fullcommand.end();) {
    if (*(*it).begin() == "system") {
      shell += (*it)[1] + "\n";
      shell += "cd " + MyProcess::shellescape(kur_wdir->url().isEmpty() ? tempDirectory->name() : kur_wdir->url());
      it++;
    }
    else if (*((*it).begin()) != "wait") { // THIS item, is not wait, however, it might be the waiting piece
      for (QStringList::iterator it2 = (*it).begin(); it2 != (*it).end(); it2++)
        shell += MyProcess::shellescape(*it2) + ' ';
      it++;
      if (*((*it).begin()) != "wait") shell += "&> /dev/null &";  // ok, this process is a crap process.
      else if (perltmp && qbg_speed->selectedId()) { // THIS is (one of) the main process, let's parse its output
        
        shell += "| perl -015 -pe '"                                          // pipe to perl, start script.
            "$| = 1;"                                                         // turn on autofulsh
            "next unless /^Pos:/;"                                            // skip stuff that doesnt need parsing
            "s/\\s+//g;"                                                      // remove annoying spaces
            "s#^Pos:\\d*\\.?\\d*s(\\d+)f\\(\\d*%\\)(\\d+)fps"                 // catch needed vars
            "Trem:\\d*min\\d*mbA-V:-?\\d*\\.?\\d*\\[(\\d+):(\\d+)\\]$#"       // catch needed vars
                                                                              /// Pattern done, now replacement:
            "$totsecs = " + QString::number(totframes/files.current()->fps) + ";"  // prepare total time
            "$tmpsecs2= (" + QString::number(tmppass == 1?TOTframes:totframes) + " - $1)/($2?$2:25);"; // prepare ETA
        if (qbg_speed->selectedId() == 1) shell +=
              "$tmpsecs = $1 / " + QString::number(files.current()->fps) + ";"// prepare time encoded
              "sprintf(\""                                                    /// and PRINT....
              "ETA %d:%02d:%02d %.1fMB %2d%% %dfps [%d:%d]kbps %02d:%02d/%02d:%02d %5d/%-5d %d/%d %c"
              "\","                                                           // some %c here for special chars
              "$tmpsecs2/3600,($tmpsecs2%3600)/60,$tmpsecs2%60,"              // ETA
              "($3 + $4) * $totsecs / 8 / 1024,"                              // estimated file size
              "$1 / " + QString::number(TOTframes) + " * 100 + " + QString::number(tmppass == 2?50:0) + "," // percent
              "$2,"                                                           // encoding fps
              "$3,$4,"                                                        // vbitrate and abitrate
              "$tmpsecs/60,$tmpsecs%60,"                                      // time encoded
              "$totsecs/60,$totsecs%60,"                                      // total time
              "$1," + QString::number(totframes) + ","                        // encopded and total frames
              + QString::number(tmppass?tmppass:1) + ","                      // pass
              + QString::number(tmppass?2:1) + ","                            // total amount of passes
              ",13)#e;'";                                                     // carriage runner char, and close
        else shell +=
              "$tmpp = \"\"; $tmpp .= \"=\" x "                               // creates dashes for progress bar, by
              "($1 / " + QString::number(TOTframes) + " * 24 + " + QString::number(tmppass == 2?12:0) + ");" // amount
              "$tmpp .= \">\";"                                               // add the trailing '>'...
              "sprintf(\""                                                    /// and PRINT....
              "ETA %d:%02d:%02d %.1fMB %2d%% %dfps [%-25s] %5d/%-5d %d/%d %c"
              "\","                                                           // some %c here for special chars
              "$tmpsecs2/3600,($tmpsecs2%3600)/60,$tmpsecs2%60,"              // ETA
              "($3 + $4) * $totsecs / 8 / 1024,"                              // estimated file size
              "$1 / " + QString::number(TOTframes) + " * 100 + " + QString::number(tmppass == 2?50:0) + "," // percent
              "$2,"                                                           // encoding fps
              "$tmpp,"                                                        // progress bar
              "$1," + QString::number(totframes) + ","                        // encoded and total frames
              + QString::number(tmppass?tmppass:1) + ","                      // pass
              + QString::number(tmppass?2:1) + ","                            // total amount of passes
              ",13)#e;'";                                                     // carriage runner char, and close
      }
    } else { // we are SITTING on "wait"
      tmppass++;
      it++;
    }
    shell += "\n";
  }
  if (globalpass && qcb_general_auto_010_del2pass->isChecked()) shell += "rm -f divx2pass.log xvid-twopass.stats";
  qtb_command->setText(shell);
}

void kmenc15::qpb_opentemplate_clicked() {
  QFile filetmp(KFileDialog::getOpenFileName("", "*.kmt *.kmp|Kmenc15 Files (*.kmt *.kmp)", this, "Choose a File"));
  QString opts, tmpopt;
  QObject * tmpobject;
  double fvar = 0;
  QString svar;
  int ivar = 0;
  bool bvar = false;

  if (!filetmp.name().length()) return;
  if (!filetmp.open(IO_ReadOnly)) {
    KMessageBox::sorry(this,
                       i18n("Could not open file for reading: %1").arg(qApp->translate("QFile",filetmp.errorString())),
                       "Open Failed");
    return;
  }

  filetmp.readLine(opts,0xffffff);
  if (opts == "<kmenc15 v0.1 project>\n") {
    while (!files.isEmpty()) delfile();
    filetmp.readLine(opts,0xffffff); opts = opts.left(opts.length() - 1);
    while (opts != "-" && !filetmp.atEnd()) {
      addfile(opts.mid(5));
      filetmp.readLine(opts,0xffffff); opts = opts.left(opts.length() - 1);
      files.current()->origidx = opts;
      filetmp.readLine(opts,0xffffff); opts = opts.left(opts.length() - 1);
      files.current()->start  = opts.section(',',0,0).toInt();
      files.current()->end    = opts.section(',',1,1).toInt();
      filetmp.readLine(opts,0xffffff); opts = opts.left(opts.length() - 1);
    }
    resetline();
  }
  else if (opts != "<kmenc15 v0.1 template>\n") {
    KMessageBox::error(this, i18n("Invalid Kmenc15 template/project file."), "Open Failed");
    return;
  }

  bool tmpbool = qpb_vf_preview->isOn();
  qpb_vf_preview->setOn(true);
  while (qlb_vf->count()) removevf();
  filetmp.readLine(opts,0xffffff); opts = opts.left(opts.length() - 1);
  while (opts != "-" && !filetmp.atEnd()) {
    qlb_vf->insertItem(opts.mid(3));
    qlb_vf->setCurrentItem(qlb_vf->count() - 1);
    vf_selected(qlb_vf->count() - 1);
    filetmp.readLine(opts,0xffffff); opts = opts.left(opts.length() - 1);
  }
  qpb_vf_preview->setOn(tmpbool);
  
  while (!filetmp.atEnd()) {
    filetmp.readLine(opts,0xffffff); opts = opts.left(opts.length() - 1);
    tmpopt = opts.left(opts.find('='));
    tmpopt = tmpopt.mid(tmpopt.find(':') + 1);
    tmpobject = child(tmpopt.ascii());
    if (tmpobject == NULL) continue;
    tmpopt = opts.left(3);

    svar = opts.mid(opts.find('=') + 1);
    if (tmpopt == "kds") fvar = svar.toDouble();
    if (tmpopt == "qsb") ivar = svar.toInt();
    if (tmpopt == "qcb") bvar = svar == "y";

    tmpopt = opts.left(opts.find('_'));
    
    if (tmpopt == "qcb:qcb")  ((QCheckBox*)     tmpobject)->setChecked(bvar);
    if (tmpopt == "qcb:qrb")  ((QRadioButton*)  tmpobject)->setChecked(bvar);
    if (tmpopt == "qcb:qgb")  ((QGroupBox*)     tmpobject)->setChecked(bvar);
    if (tmpopt == "qsb:qsb")  ((QSpinBox*)      tmpobject)->setValue(ivar);
    if (tmpopt == "qsb:qcmb") ((QComboBox*)     tmpobject)->setCurrentItem(ivar);
    if (tmpopt == "kdsb:kdsb")((KDoubleSpinBox*)tmpobject)->setValue(fvar);
    if (tmpopt == "qle:qle")  ((QLineEdit*)     tmpobject)->setText(svar);
    if (tmpopt == "qle:kur")  ((KURLRequester*) tmpobject)->setURL(svar);
    if (tmpopt == "qsb:qbg")  { QSignal*        tmpsignal = new QSignal();
                              ((QSignal*)       tmpsignal)->setValue(ivar);
                              ((QButtonGroup*)  tmpobject)->setButton(ivar);
                              ((QSignal*)       tmpsignal)->connect(
                              ((QButtonGroup*)  tmpobject),SIGNAL(clicked(int)));
                              ((QSignal*)       tmpsignal)->activate();
                              delete            tmpsignal;}
  }
  filetmp.close();
  make_command();
}

void kmenc15::qpb_savetemplate_clicked() {
  QFile filetmp(KFileDialog::getSaveFileName("", "*.kmt|Kmenc15 Template (*.kmt)\n"
      "*.kmp|Kmenc15 Project (*.kmp)", this, "Choose a File"));
  if (!filetmp.name().length()) return;
  if (filetmp.name().right(4) != ".kmt" && filetmp.name().right(4) != ".kmp") filetmp.setName(filetmp.name()+".kmt");

  if (!filetmp.open(IO_WriteOnly)) {
    KMessageBox::sorry(this,
                       i18n("Could not open file for writing: %1").arg(qApp->translate("QFile",filetmp.errorString())),
                       "Open Failed");
    return;
  }

  QStringList opts;
  QString qstr;
  QRegExp tmp(ALL_DATA_PATTERN);
  QObjectList * tmplist;

  if (filetmp.name().right(4) == ".kmp") {
    opts << "<kmenc15 v0.1 project>\n";

    for (QPtrListIterator<MovieFile> it(files); *it; ++it)
      opts << "file=" << (*it)->origfile << "\n" << (*it)->origidx << "\n"
          << qstr.number((*it)->start)   << "," << qstr.number((*it)->end) << "\n";
    
    opts << "-\n";
  }
  else opts << "<kmenc15 v0.1 template>\n";

  // =============== vf ===============
  for (uint i = 0; i < qlb_vf->count(); i++) opts << "vf=" << qlb_vf->item(i)->text() << "\n";
  opts << "-\n";

  if (filetmp.name().right(4) == ".kmp") {
    opts << "qle:kur_ofile=" << kur_ofile->url() << "\n";
    opts << "qcb:qcb_general_skippass=" << (qcb_general_skippass->isChecked() ? "y" : "n") << "\n";
  }
  
  tmplist = queryList(0,tmp.pattern(), true, true);
  for (uint i = 0; i < tmplist->count(); i++) {
    QString type, val;
    tmp.search(tmplist->at(i)->name());
    
    if (tmp.cap(1) == "qcb")  type = "qcb",  val = (((QCheckBox    *)tmplist->at(i))->isChecked() ? "y" : "n");
    if (tmp.cap(1) == "qrb")  type = "qcb",  val = (((QRadioButton *)tmplist->at(i))->isChecked() ? "y" : "n");
    if (tmp.cap(1) == "qgb")  type = "qcb",  val = (((QGroupBox    *)tmplist->at(i))->isChecked() ? "y" : "n");
    
    if (tmp.cap(1) == "qsb")  type = "qsb",  val = qstr.number(((QSpinBox       *)tmplist->at(i))->value());
    if (tmp.cap(1) == "qcmb") type = "qsb",  val = qstr.number(((QComboBox      *)tmplist->at(i))->currentItem());
    if (tmp.cap(1) == "qbg")  type = "qsb",  val = qstr.number(((QButtonGroup   *)tmplist->at(i))->selectedId());
    if (tmp.cap(1) == "kdsb") type = "kdsb", val = qstr.number(((KDoubleSpinBox *)tmplist->at(i))->value());
    
    if (tmp.cap(1) == "qle")  type = "qle",  val = ((QLineEdit *)tmplist->at(i))->text();
    if (tmp.cap(1) == "kur")  type = "qle",  val = ((KURLRequester *)tmplist->at(i))->url();

    opts << type << ":" << tmplist->at(i)->name() << "=" << val << "\n";
  }
  
  filetmp.writeBlock(opts.join("").ascii(),opts.join("").length());
  filetmp.close();
}
