/***************************************************************************
 *   Copyright (C) 2004 by Oded Shimon                                     *
 *   ods15@ods15.dyndns.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "images.h"
 
const QImage & myembed_findImage(const QString & tmp) { return qembed_findImage(tmp); }
const QByteArray & myembed_findData(const char * tmp) { return qembed_findData(tmp); }

// based on some great ideas from Avisynth. their code seems insane at first, but it's actually very optimized

static class ClipPixelClass {
  public:
    char buffer[320 * 2 + 256];
    ClipPixelClass() {
      memset(buffer, 0, 320);
      for (uint i = 0; i < 256; i++) buffer[i + 320] = i;
      memset(buffer + 320 + 256, 255, 320);
    }
} ClipPixelObject;

#define ClipPixel(a) (ClipPixelObject.buffer[(a) + 320])
#define RoundPixel(a) ClipPixel(((a) + 32768) >> 16)

static inline void yuv2rgb(uchar y, uchar u, uchar v, char * bgr) {
  static const int crv = int(1.596 * 65536 + 0.5);
  static const int cgv = int(0.813 * 65536 + 0.5);
  static const int cgu = int(0.391 * 65536 + 0.5);
  static const int cbu = int(2.018 * 65536 + 0.5);
  static const int cy = int((255.0 / 219.0) * 65536 + 0.5);

  int scaled_y = (y - 16) * cy;

  bgr[0] = RoundPixel(scaled_y + (u - 128) * cbu); // blue
  bgr[1] = RoundPixel(scaled_y - (u - 128) * cgu - (v - 128) * cgv); // green
  bgr[2] = RoundPixel(scaled_y + (v - 128) * crv); // red
}

const QPixmap & i420toRgb(const QByteArray & data, uint w, uint h) {
  QByteArray output, input(data);
  static QPixmap image;
  uint y_offset = 0;
  uint u_offset = w * h;
  uint v_offset = uint(w * h * 0.25);
  output.resize(w * h * 4);
  for (uint i = 0; i < h; i++) {
    for (uint j = 0; j < w; j += 2) {
      yuv2rgb(input[y_offset], input[u_offset], input[u_offset + v_offset], &output[y_offset * 4]);
      y_offset++;
      yuv2rgb(input[y_offset], input[u_offset], input[u_offset + v_offset], &output[y_offset * 4]);
      y_offset++;
      u_offset++;
    }
    if (!(i & 1)) u_offset -= w / 2;
  }
  image = QPixmap(QImage((uchar *)output.data(), w, h, 32, 0, 0, QImage::BigEndian));
  return image;
}
