/***************************************************************************
 *   Copyright (C) 2004 by Oded Shimon                                     *
 *   ods15@ods15.dyndns.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "wcon.h"
#include "main.h"
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kapplication.h>

static const char description[] =
    I18N_NOOP("An Advanced Qt/KDE MEncoder Frontend.");

const char version[] = "0.04";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
//    { "+[-t]", I18N_NOOP( "Pipe thread mode. Don't use this." ), 0 },
    KCmdLineLastOption
};

int main(int argc, char * argv[])
{
    //if (argc > 1 && !strcmp(argv[1],"-t")) return pipe_rotate(argc, argv);
    KAboutData about("Kmenc15", I18N_NOOP("Kmenc15"), version, description,
                     KAboutData::License_GPL, "(C) 2004 Oded Shimon", 0, 0, "ods15@ods15.dyndns.org");
    about.addAuthor("Oded Shimon", 0, "ods15@ods15.dyndns.org");
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    kmenc15 mainWin;
    
    /*if (app.isRestored())
    {
        RESTORE(kmenc15);
    }
    else
    {*/
        // no session.. just start up normally
        // KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        app.setMainWidget(&mainWin);
        mainWin.show();

        // args->clear();
    //}

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

