/***************************************************************************
 *   Copyright (C) 2004 by Oded Shimon                                     *
 *   ods15@ods15.dyndns.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MAIN_H
#define MAIN_H

#define min(a,b) ((a) > (b) ? (b) : (a))
#define max(a,b) ((a) > (b) ? (a) : (b))

class QImage;
class QString;
class KApplication;
    
extern const char version[];

extern const QImage & myembed_findImage(const QString &);
extern const QByteArray & myembed_findData(const char *);
extern const QPixmap & i420toRgb(const QByteArray &, uint, uint);
//extern "C" { int pipe_rotate(int argc, char * argv []); }

struct MovieFile {
  QString origfile;
  QString origidx;
  //int usperf;
  int frames;
  int width;
  int height;
  double fps;
  int start;
  int end;
};

#endif // MAIN_H
