/***************************************************************************
 *   Copyright (C) 2004 by Oded Shimon                                     *
 *   ods15@ods15.dyndns.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "process.h"
#include "process.moc"
#include <signal.h>
#include <qregexp.h>
#include <qtimer.h>
#include <qsocketdevice.h>
#include <qdatetime.h>
#define QT_THREAD_SUPPORT
#include <qwaitcondition.h>

MyProcess::MyProcess(const QStringList & tmp) {
  connect(this, SIGNAL(receivedStdout(KProcess *, char *, int)),
          this,  SLOT(getKProcessData(KProcess *, char *, int)));
  connect(this, SIGNAL(receivedStderr(KProcess *, char *, int)),
          this,  SLOT(getKProcessData(KProcess *, char *, int)));
  connect(this, SIGNAL(processExited(KProcess *)), this, SLOT(processDied()));
  killer = new QTimer(this, "killer");
  *this << tmp;
}

MyProcess::MyProcess(QObject * parent, const char * name) : KProcess(parent, name), processData(false) {
  connect(this, SIGNAL(receivedStdout(KProcess *, char *, int)),
          this,  SLOT(getKProcessData(KProcess *, char *, int)));
  connect(this, SIGNAL(receivedStderr(KProcess *, char *, int)),
          this,  SLOT(getKProcessData(KProcess *, char *, int)));
  connect(this, SIGNAL(processExited(KProcess *)), this, SLOT(processDied()));
  killer = new QTimer(this, "killer");
}

QString MyProcess::shellescape(const QString & tmp) {
  if (tmp.contains(QRegExp("^[=~]|[\\[\\]{}()<>&;|*?^`!$#\t \n'\"\\\\]|^$")) || tmp.isEmpty()) return quote(tmp);
  return tmp;
}

int MyProcess::system(const QString & tmp) {
  KProcess tmpproc;
  tmpproc << tmp;
  tmpproc.setUseShell(true);
  tmpproc.start(Block, All);
  if (tmpproc.normalExit()) return tmpproc.exitStatus(); else return -1;
}

void MyProcess::immediateWrite(const QString & text) {
  QWaitCondition tmp;
  writeStdin(text.ascii(), text.length());  
  while (input_data) { tmp.wait(50); slotSendData(0); }
} 

void MyProcess::getKProcessData(KProcess *, char * buffer, int buflen) {
  if (processData) stdoutData += QString::fromLatin1(buffer, buflen);
  // if (processRawData) stdoutRawData.writeBlock(buffer, buflen);
  emit readyReadStdout();
}

const QString & MyProcess::readStdout() {
  static QString tmp;
  tmp = stdoutData;
  stdoutData.truncate(0);
  return tmp;
}

void MyProcess::term() {
  kill(SIGTERM);
}
void MyProcess::killNow() {
  kill(SIGKILL);
}
bool MyProcess::start() {
  //for (uint i = 0; i < args().count(); i++) qDebug("%s", (const char *)args()[i]);
  setEnvironment("LC_ALL", "C");
  bool r = KProcess::start(NotifyOnExit, All);
  if (r) stdoutWatcher = new QSocketDevice(out[0], QSocketDevice::Datagram);
  return r;
}

#if 0    // stupid raw stuff i made for no apperant reason...
bool MyProcess::startRaw() {
  if (KProcess::start(NotifyOnExit, All)) {
    stdoutRawData.open(IO_WriteOnly);
    processRawData = true;
    return true;
  }
  return false;
}

const QByteArray & MyProcess::readRawNow(int length, int timeout) {
  static QByteArray tmp;
  QTime tmptime;
  tmptime.start();
  while (isRunning()) {
    waitForOutput(1000);
    if (stdoutRawData.size() >= length) break;
    if (tmptime.elapsed() >= timeout) break;
  }
  
  stdoutRawData.close();
  stdoutRawData.open(IO_ReadOnly);
  if (stdoutRawData.size() > length) tmp.resize(length);
  else tmp.resize(stdoutRawData.size());
  
  stdoutRawData.readBlock(tmp.data(), tmp.size());
  
  QByteArray tmp2 = stdoutRawData.readAll();
  stdoutRawData.close();
  stdoutRawData.setBuffer(tmp2);
  stdoutRawData.open(IO_WriteOnly | IO_Append);
  
  return tmp;
}
const QString & MyProcess::readRawLine(int timeout) {
  static QString tmp;
  if (stdoutRawData.buffer().find('\n') == -1) {
    QTime tmptime;
    tmptime.start();
    while (isRunning()) {
      waitForOutput(1000);
      if (stdoutRawData.buffer().find('\n') != -1) break;
      if (tmptime.elapsed() >= timeout) break;
    }
  }
  if (stdoutRawData.buffer().find('\n') == -1) return QString::null;

  QByteArray tmpbyte(stdoutRawData.buffer().find('\n') + 1);
  
  stdoutRawData.close();
  
  stdoutRawData.open(IO_ReadOnly);
  stdoutRawData.readLine(tmpbyte.data(), tmpbyte.size());
  QByteArray tmp2 = stdoutRawData.readAll();
  stdoutRawData.close();
  
  stdoutRawData.setBuffer(tmp2);
  stdoutRawData.open(IO_WriteOnly | IO_Append);

  tmp = QString(tmpbyte);
  
  return tmp;
}
#endif

bool MyProcess::waitForOutput(int timeout) {
  //if (!processRawData)
  processData = true;
  int r = stdoutWatcher->waitForMore(timeout);
  if (r) slotChildOutput(out[0]);
  return r;
}
bool MyProcess::waitForText(const QString & searchtext, int timeout) {
  QString tmptext;
  QTime tmptime;
  tmptime.start();
  while (isRunning()) {
    if (waitForOutput(1000)) tmptext += readStdout();
    if (tmptext.find(searchtext) != -1) break;
    if (tmptime.elapsed() >= timeout * 1000) break;
  }
  if (tmptext.find(searchtext) != -1) {
    tmptext = tmptext.mid(tmptext.find(searchtext));
    getKProcessData(0, (char *)tmptext.latin1(), tmptext.length());
    return true;
  }
  return false;
}
const QString & MyProcess::waitForLines(int lineamount, int timeout) {
  static QString tmptext;
  tmptext = "";
  QTime tmptime;
  tmptime.start();
  while (isRunning()) {
    if (waitForOutput(1000)) tmptext += readStdout();
    if (tmptext.contains('\n') >= lineamount) return tmptext;
    if (tmptime.elapsed() >= timeout * 1000) break;
  }
  tmptext = "";
  return tmptext;
}

void MyProcess::selfDestruct(int time) {
  if (killer->isActive()) return;
  term();
  connect(killer, SIGNAL(timeout()), this, SLOT(killNow()));
  killer->start(time, true);
}
void MyProcess::processDied() {
  killer->stop();
  //stdoutData = "";
  //stdoutRawData.close();
  delete stdoutWatcher;
}
void MyProcess::dieNow(int time) {
  if (!isRunning()) return;
  term();
  if (!wait(time)) killNow();
  wait();
}
