/***************************************************************************
 *   Copyright (C) 2004 by Oded Shimon                                     *
 *   ods15@ods15.dyndns.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MYPROCESS_H
#define MYPROCESS_H

#include <kprocess.h>
#include <qbuffer.h>

class QTimer;
class QSocketDevice;

class MyProcess : public KProcess {

  Q_OBJECT

private:
  bool processData;
  //bool processRawData;
  QString stdoutData;
  //QBuffer stdoutRawData;
  QSocketDevice * stdoutWatcher;
  QTimer * killer;

private slots:
  void getKProcessData(KProcess *, char *, int);
  void processDied();

public:
  MyProcess(QObject * = 0, const char * = 0);
  MyProcess(const QStringList &);
  const QString & readStdout();
  bool waitForOutput(int); // Unlike rest, timeout in ms. Enables processing stdout data
  bool waitForText(const QString &, int); // seconds.
  const QString & waitForLines(int, int); // seconds.
  bool start();
  // bool startRaw();
  // const QByteArray & readRawNow(uint, int); // miliseconds.
  // const QString & readRawLine(int); // miliseconds.

  static QString shellescape(const QString &);
  static int system(const QString &);

public slots:
  void immediateWrite(const QString &);
  void term();
  void killNow();
  void dieNow(int); // seconds.
  void selfDestruct(int); // seconds.

signals:
  void readyReadStdout();
};

#endif
