// deinterlace.c
// weed plugin
// (c) G. Finch (salsaman) 2006
//
// released under the GNU GPL 2.0 or higher
// see file COPYING or www.gnu.org for details

#include "weed.h"

///////////////////////////////////////////////////////////////////

static int num_versions=1; // number of different weed api versions supported
static int api_versions[]={100}; // array of weed api versions supported in plugin, in order of preference (most preferred first)

// api functions for this version
weed_leaf_set_f weed_leaf_set;
weed_leaf_get_f weed_leaf_get;
weed_plant_new_f weed_plant_new;
weed_plant_list_leaves_f weed_plant_list_leaves;
weed_leaf_num_elements_f weed_leaf_num_elements;
weed_leaf_element_size_f weed_leaf_element_size;
weed_leaf_seed_type_f weed_leaf_seed_type;
weed_leaf_get_flags_f weed_leaf_get_flags;

weed_malloc_f weed_malloc;
weed_free_f weed_free;
weed_memcpy_f weed_memcpy;
weed_memset_f weed_memset;


static int package_version=1; // version of this package

//////////////////////////////////////////////////////////////////

#include "weed-utils.c" // optional
#include "weed-plugin-utils.c" // optional

/////////////////////////////////////////////////////////////

#include <stdlib.h>


static unsigned char *mix(unsigned char *a, unsigned char *b)
{
  unsigned char *mixed=(unsigned char *)weed_malloc(3);
  mixed[0]=(*a+*b)>>1;
  mixed[1]=(*(a+1)+*(b+1))>>1;
  mixed[2]=(*(a+2)+*(b+2))>>1;
  return mixed;
}


int deinterlace_process (weed_plant_t *inst, weed_timecode_t timestamp) {
  int error;
  weed_plant_t *in_channel=weed_get_plantptr_value(inst,"in_channels",&error),*out_channel=weed_get_plantptr_value(inst,"out_channels",&error);
  unsigned char *src=weed_get_voidptr_value(in_channel,"pixel_data",&error);
  unsigned char *dst=weed_get_voidptr_value(out_channel,"pixel_data",&error);
  int width=weed_get_int_value(in_channel,"width",&error);
  int height=weed_get_int_value(in_channel,"height",&error);
  int irowstride=weed_get_int_value(in_channel,"rowstrides",&error);
  int orowstride=weed_get_int_value(out_channel,"rowstrides",&error);
  unsigned char *end=src+height*irowstride-irowstride*2;
  register int x;
  
  unsigned char *val1a,*val2a,*val3a,*val4a;
  unsigned char *val1b,*val2b,*val3b,*val4b;
  unsigned char *val1c,*val2c,*val3c,*val4c;
  unsigned char *res1,*res2,*res3,*res4,*res5,*res6;
  int d1,d2;
  unsigned char m1,m2,m3,m4,m5,m6,m7,m8;

  int irowstride2=irowstride*2;
  int width3=width*3-9;

  src+=irowstride;
  dst+=orowstride;

  for (; src < end ; src+=irowstride2) {
    for (x=0; x<width3; x+=9){
      val1a = (src-irowstride+x);
      val2a = (src+x);
      val3a = (src+irowstride+x);
      val4a = (src+irowstride2+x);

      val1b = (src-irowstride+x+3);
      val2b = (src+x+3);
      val3b = (src+irowstride+x+3);
      val4b = (src+irowstride2+x+3);

      val1c = (src-irowstride+x+6);
      val2c = (src+x+6);
      val3c = (src+irowstride+x+6);
      val4c = (src+irowstride2+x+6);
      
      res1=val2a;
      res3=val2b;
      res5=val2c;
      
      m1=(*(val1a+1)+*(val1c+1))>>1;
      m2=(*(val3a+1)+*(val3c+1))>>1;
      m3=(*(val2a+1)+*(val2c+1))>>1;
      m4=(*(val4a+1)+*(val4c+1))>>1;

      d1=abs(m1-m2)+abs(m3-m4);

      m5=(*(val1a+1)+*(val1c+1))>>1;
      m6=(*(val4a+1)+*(val4c+1))>>1;
      m7=(*(val2a+1)+*(val2c+1))>>1;
      m8=(*(val3a+1)+*(val3c+1))>>1;

      d2=abs(m5-m6)+abs(m7-m8);

      if ((d1) < (d2)) {
	res2=mix(val2a,val4a);
	res4=mix(val2b,val4b);
	res6=mix(val2c,val4c);
      }
      else {
	res2=val3a;
	res4=val3b;
	res6=val3c;
      }

      memcpy(dst+x-orowstride,res1,3);
      memcpy(dst+x,res2,3);
      memcpy(dst+x+3-orowstride,res3,3);
      memcpy(dst+x+3,res4,3);
      memcpy(dst+x+6-orowstride,res5,3);
      memcpy(dst+x+6,res6,3);

      if ((d1) < (d2)) {
	weed_free(res2);
	weed_free(res4);
	weed_free(res6);
      }
    }
    dst+=orowstride*2;
  }
  return WEED_NO_ERROR;
}



weed_plant_t *weed_setup (weed_bootstrap_f weed_boot) {
  weed_plant_t *plugin_info=weed_plugin_info_init(weed_boot,num_versions,api_versions);
  if (plugin_info!=NULL) {
    int palette_list[]={WEED_PALETTE_BGR24,WEED_PALETTE_RGB24,WEED_PALETTE_END};

    weed_plant_t *in_chantmpls[]={weed_channel_template_init("in channel 0",0,palette_list),NULL};
    weed_plant_t *out_chantmpls[]={weed_channel_template_init("out channel 0",0,palette_list),NULL};
    weed_plant_t *filter_class=weed_filter_class_init("deinterlace","salsaman",1,0,NULL,&deinterlace_process,NULL,in_chantmpls,out_chantmpls,NULL,NULL);

    weed_plugin_info_add_filter_class (plugin_info,filter_class);

    weed_set_int_value(plugin_info,"version",package_version);
  }
  return plugin_info;
}

