// audio.h
// LiVES (lives-exe)
// (c) G. Finch 2005 - 2006
// Released under the GPL 2.0 or higher
// see file ../COPYING for licensing details

#ifndef _HAS_LIVES_AUDIO_H
#define _HAS_LIVES_AUDIO_H

#define SAMPLE_MAX_16BIT  32767.0f
#define SAMPLE_MAX_16BITI  32767

// defaults for when not specifed
# define DEFAULT_AUDIO_RATE 44100
# define DEFAULT_AUDIO_CHANS 2
# define DEFAULT_AUDIO_SAMPS 16
# define DEFAULT_AUDIO_SIGNED !(AFORM_UNSIGNED)

#define WAV_HEADER_BYTES 44 // size of a wav header

void sample_silence_dS (float *dst, unsigned long nsamples);

void sample_move_d8_d16(short *dst, guchar *src,
			unsigned long nsamples, float scale, int nDstChannels, int nSrcChannels);

void sample_move_d16_d16(short *dst, short *src,
			 unsigned long nsamples, float scale, int nDstChannels, int nSrcChannels, int swap_endian);

void sample_move_d16_float (float *dst, short *src, unsigned long nsamples, unsigned long src_skip, int is_unsigned, float vol);

long sample_move_float_int(void *holding_buff, float **float_buffer, int nsamps, float scale, int chans, int asamps, int usigned, int swap_endian); // returns frames output

void render_audio_segment(gint from_file, gint to_file, gdouble avel, gdouble fromtime, gdouble uptotime, weed_timecode_t tc, gdouble autofade_start, gdouble autofade_end); // render part of one audio file to another


void aud_fade(gint fileno, gdouble startt, gdouble endt, gdouble startv, gdouble endv); // fade in/fade out

#ifdef ENABLE_JACK
void rec_audio_to_clip(gint fileno, gboolean is_window_grab);  // record from external source to clip
void rec_audio_end(void);
#endif

#endif
